/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.extension.api.persistence;

import com.google.gson.JsonArray;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.google.gson.TypeAdapter;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import org.mule.metadata.api.model.MetadataType;
import org.mule.metadata.persistence.MetadataTypeGsonTypeAdapter;
import org.mule.metadata.persistence.NullObjectTypeReferenceHandler;
import org.mule.metadata.persistence.ObjectTypeReferenceHandler;
import org.mule.runtime.extension.api.introspection.property.ImportedTypesModelProperty;

class ImportedTypesModelPropertyTypeAdapter
extends TypeAdapter<ImportedTypesModelProperty> {
    private static final String EXTENSION = "extension";
    private static final String TYPE = "type";
    private final MetadataTypeGsonTypeAdapter typeAdapter;

    public ImportedTypesModelPropertyTypeAdapter() {
        this((ObjectTypeReferenceHandler)new NullObjectTypeReferenceHandler());
    }

    public ImportedTypesModelPropertyTypeAdapter(ObjectTypeReferenceHandler referenceHandler) {
        this.typeAdapter = new MetadataTypeGsonTypeAdapter(referenceHandler);
    }

    public void write(JsonWriter out, ImportedTypesModelProperty value) throws IOException {
        out.beginArray();
        for (Map.Entry entry : value.getImportedTypes().entrySet()) {
            out.beginObject();
            out.name(TYPE);
            this.typeAdapter.write(out, (MetadataType)entry.getKey());
            out.name(EXTENSION).value((String)entry.getValue());
            out.endObject();
        }
        out.endArray();
    }

    public ImportedTypesModelProperty read(JsonReader in) throws IOException {
        HashMap importedTypesMap = new HashMap();
        JsonArray importedTypesArray = new JsonParser().parse(in).getAsJsonArray();
        importedTypesArray.iterator().forEachRemaining(importedTypeElement -> {
            JsonObject tuple = importedTypeElement.getAsJsonObject();
            importedTypesMap.put(this.typeAdapter.fromJsonTree(tuple.get(TYPE)), tuple.get(EXTENSION).getAsString());
        });
        return new ImportedTypesModelProperty(importedTypesMap);
    }
}

