/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.extension.api.persistence;

import com.google.gson.Gson;
import com.google.gson.TypeAdapter;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import java.io.IOException;
import java.util.Map;
import java.util.Optional;
import org.mule.runtime.extension.api.introspection.ModelProperty;
import org.mule.runtime.extension.api.persistence.ExtensionModelSerializationException;
import org.mule.runtime.extension.api.persistence.JsonSerializationConstants;
import org.mule.runtime.extension.internal.util.HierarchyClassMap;

final class ModelPropertyMapTypeAdapter
extends TypeAdapter<HierarchyClassMap<ModelProperty>> {
    private static final Map<Class<? extends ModelProperty>, String> classNameMapping = JsonSerializationConstants.getClassNameMapping();
    private static final Map<String, Class<? extends ModelProperty>> nameClassMapping = JsonSerializationConstants.getNameClassMapping();
    private final Gson gson;

    ModelPropertyMapTypeAdapter(Gson gson) {
        this.gson = gson;
    }

    public void write(JsonWriter out, HierarchyClassMap<ModelProperty> modelPropertyMap) throws IOException {
        out.beginObject();
        for (Map.Entry entry : modelPropertyMap.entrySet()) {
            ModelProperty modelProperty = (ModelProperty)entry.getValue();
            Class modelPropertyClass = (Class)entry.getKey();
            if (!modelProperty.isExternalizable()) continue;
            out.name(this.getSerializableModelPropertyName(modelPropertyClass));
            TypeAdapter adapter = this.gson.getAdapter(modelPropertyClass);
            adapter.write(out, (Object)modelProperty);
        }
        out.endObject();
    }

    public HierarchyClassMap<ModelProperty> read(JsonReader in) throws IOException {
        HierarchyClassMap modelPropertyHashMap = new HierarchyClassMap();
        in.beginObject();
        while (in.hasNext()) {
            Optional<Class<? extends ModelProperty>> modelPropertyClass = this.getClassForModelProperty(in.nextName());
            if (!modelPropertyClass.isPresent()) continue;
            Class<? extends ModelProperty> type = modelPropertyClass.get();
            TypeAdapter adapter = this.gson.getAdapter(type);
            ModelProperty read = (ModelProperty)adapter.read(in);
            modelPropertyHashMap.put(type, (Object)read);
        }
        in.endObject();
        return modelPropertyHashMap;
    }

    private Optional<Class<? extends ModelProperty>> getClassForModelProperty(String modelPropertyName) {
        Class<Object> modelPropertyClass = null;
        if (nameClassMapping.containsKey(modelPropertyName)) {
            modelPropertyClass = nameClassMapping.get(modelPropertyName);
        } else {
            try {
                modelPropertyClass = Class.forName(modelPropertyName);
            }
            catch (ClassNotFoundException e) {
                throw new ExtensionModelSerializationException(String.format("Error loading [%s] ModelProperty. Class not found in the current classloader", modelPropertyName), e);
            }
        }
        return Optional.ofNullable(modelPropertyClass);
    }

    private String getSerializableModelPropertyName(Class<?> modelPropertyClass) {
        return classNameMapping.getOrDefault(modelPropertyClass, modelPropertyClass.getName());
    }
}

