/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.extension.api.persistence;

import com.google.gson.JsonArray;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.google.gson.TypeAdapter;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import java.io.IOException;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.mule.metadata.api.model.MetadataType;
import org.mule.metadata.persistence.MetadataTypeGsonTypeAdapter;
import org.mule.metadata.persistence.NullObjectTypeReferenceHandler;
import org.mule.metadata.persistence.ObjectTypeReferenceHandler;
import org.mule.runtime.extension.api.introspection.property.SubTypesModelProperty;

class SubTypesModelPropertyTypeAdapter
extends TypeAdapter<SubTypesModelProperty> {
    public static final String SUB_TYPES = "subTypes";
    private static final String BASE_TYPE = "baseType";
    private final MetadataTypeGsonTypeAdapter typeAdapter;

    public SubTypesModelPropertyTypeAdapter() {
        this((ObjectTypeReferenceHandler)new NullObjectTypeReferenceHandler());
    }

    public SubTypesModelPropertyTypeAdapter(ObjectTypeReferenceHandler referenceHandler) {
        this.typeAdapter = new MetadataTypeGsonTypeAdapter(referenceHandler);
    }

    public void write(JsonWriter out, SubTypesModelProperty value) throws IOException {
        out.beginArray();
        for (Map.Entry entry : value.getSubTypesMapping().entrySet()) {
            out.beginObject();
            out.name(BASE_TYPE);
            this.typeAdapter.write(out, (MetadataType)entry.getKey());
            out.name(SUB_TYPES);
            out.beginArray();
            for (MetadataType subType : (List)entry.getValue()) {
                this.typeAdapter.write(out, subType);
            }
            out.endArray();
            out.endObject();
        }
        out.endArray();
    }

    public SubTypesModelProperty read(JsonReader in) throws IOException {
        HashMap subTypesMap = new HashMap();
        JsonArray subTypesArray = new JsonParser().parse(in).getAsJsonArray();
        subTypesArray.iterator().forEachRemaining(importedTypeElement -> {
            JsonObject tuple = importedTypeElement.getAsJsonObject();
            MetadataType baseType = (MetadataType)this.typeAdapter.fromJsonTree(tuple.get(BASE_TYPE));
            LinkedList subTypes = new LinkedList();
            tuple.get(SUB_TYPES).getAsJsonArray().forEach(subTypeElement -> subTypes.add(this.typeAdapter.fromJsonTree(subTypeElement)));
            subTypesMap.put(baseType, subTypes);
        });
        return new SubTypesModelProperty(subTypesMap);
    }
}

