/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.extension.api.persistence.manifest;

import com.sun.org.apache.xml.internal.serialize.OutputFormat;
import com.sun.org.apache.xml.internal.serialize.XMLSerializer;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.Marshaller;
import javax.xml.bind.Unmarshaller;
import org.mule.runtime.extension.api.manifest.DescriberManifest;
import org.mule.runtime.extension.api.manifest.ExtensionManifest;
import org.mule.runtime.extension.api.manifest.ExtensionManifestBuilder;
import org.mule.runtime.extension.internal.manifest.XmlDescriberManifest;
import org.mule.runtime.extension.internal.manifest.XmlExtensionManifest;

public final class ExtensionManifestXmlSerializer {
    public String serialize(ExtensionManifest manifest) {
        XmlExtensionManifest xmlManifest = new XmlExtensionManifest();
        xmlManifest.setName(manifest.getName());
        xmlManifest.setDescription(manifest.getDescription());
        xmlManifest.setVersion(manifest.getVersion());
        xmlManifest.setMinMuleVersion(manifest.getMinMuleVersion());
        xmlManifest.setExportedPackages(manifest.getExportedPackages());
        xmlManifest.setExportedResources(manifest.getExportedResources());
        xmlManifest.setDescriberManifest(this.asXml(manifest.getDescriberManifest()));
        try {
            JAXBContext jaxbContext = JAXBContext.newInstance((Class[])new Class[]{XmlExtensionManifest.class});
            Marshaller marshaller = jaxbContext.createMarshaller();
            ByteArrayOutputStream out = new ByteArrayOutputStream(1024);
            marshaller.marshal((Object)xmlManifest, this.getXMLSerializer(out).asContentHandler());
            return out.toString();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public ExtensionManifest deserialize(String xml) {
        XmlExtensionManifest xmlManifest;
        try {
            JAXBContext jaxbContext = JAXBContext.newInstance((Class[])new Class[]{XmlExtensionManifest.class});
            Unmarshaller unmarshaller = jaxbContext.createUnmarshaller();
            xmlManifest = (XmlExtensionManifest)unmarshaller.unmarshal((InputStream)new ByteArrayInputStream(xml.getBytes()));
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        ExtensionManifestBuilder builder = new ExtensionManifestBuilder();
        builder.setName(xmlManifest.getName()).setDescription(xmlManifest.getDescription()).setVersion(xmlManifest.getVersion()).setMinMuleVersion(xmlManifest.getMinMuleVersion()).addExportedPackages(xmlManifest.getExportedPackages()).addExportedResources(xmlManifest.getExportedResources()).withDescriber().setId(xmlManifest.getDescriberManifest().getId()).addProperties(xmlManifest.getDescriberManifest().getProperties());
        return builder.build();
    }

    private XMLSerializer getXMLSerializer(OutputStream out) {
        OutputFormat of = new OutputFormat();
        of.setCDataElements(new String[]{"^description"});
        of.setIndenting(true);
        XMLSerializer serializer = new XMLSerializer(of);
        serializer.setOutputByteStream(out);
        return serializer;
    }

    private XmlDescriberManifest asXml(DescriberManifest manifest) {
        XmlDescriberManifest xmlManifest = new XmlDescriberManifest();
        xmlManifest.setId(manifest.getId());
        xmlManifest.setProperties(manifest.getProperties());
        return xmlManifest;
    }
}

