/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.extension.internal.persistence.metadata.dto;

import java.util.Collections;
import java.util.List;
import java.util.Optional;
import org.mule.runtime.api.metadata.descriptor.ImmutableComponentMetadataDescriptor;
import org.mule.runtime.api.metadata.descriptor.ImmutableOutputMetadataDescriptor;
import org.mule.runtime.api.metadata.descriptor.OutputMetadataDescriptor;
import org.mule.runtime.api.metadata.descriptor.TypeMetadataDescriptor;
import org.mule.runtime.api.metadata.resolving.FailureCode;
import org.mule.runtime.api.metadata.resolving.MetadataResult;
import org.mule.runtime.extension.internal.persistence.metadata.dto.Descriptable;
import org.mule.runtime.extension.internal.persistence.metadata.dto.Failure;
import org.mule.runtime.extension.internal.persistence.metadata.dto.TypeMetadata;

public class OutputMetadata
implements Descriptable<OutputMetadataDescriptor> {
    static final String OUTPUT_PAYLOAD = "OUTPUT_PAYLOAD";
    static final String OUTPUT_ATTRIBUTES = "OUTPUT_ATTRIBUTES";
    static final String OUTPUT = "OUTPUT";
    private final TypeMetadata content;
    private final TypeMetadata attributes;

    OutputMetadata(ImmutableComponentMetadataDescriptor result) {
        OutputMetadataDescriptor outputDescriptor = (OutputMetadataDescriptor)result.getOutputMetadata().get();
        this.content = new TypeMetadata(((TypeMetadataDescriptor)outputDescriptor.getPayloadMetadata().get()).getType(), true);
        this.attributes = new TypeMetadata(((TypeMetadataDescriptor)outputDescriptor.getAttributesMetadata().get()).getType(), true);
    }

    TypeMetadata getContent() {
        return this.content;
    }

    TypeMetadata getAttributes() {
        return this.attributes;
    }

    @Override
    public MetadataResult<OutputMetadataDescriptor> toDescriptorResult(List<Failure> failures) {
        Optional<Failure> metadataFailure = this.getComponentFailure(failures, OUTPUT);
        List<Failure> attributesFailure = this.getComponentFailure(failures, OUTPUT_ATTRIBUTES).map(Collections::singletonList).orElse(Collections.emptyList());
        List<Failure> payloadFailure = this.getComponentFailure(failures, OUTPUT_PAYLOAD).map(Collections::singletonList).orElse(Collections.emptyList());
        ImmutableOutputMetadataDescriptor descriptor = new ImmutableOutputMetadataDescriptor(this.content.toDescriptorResult(payloadFailure), this.attributes.toDescriptorResult(attributesFailure));
        if (metadataFailure.isPresent()) {
            return MetadataResult.failure((Object)descriptor, (String)metadataFailure.get().getMessage(), (FailureCode)metadataFailure.get().getFailureCode(), (String)metadataFailure.get().getReason());
        }
        return MetadataResult.success((Object)descriptor);
    }
}

