/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.extension.xml.dsl.test;

import java.util.Arrays;
import java.util.Optional;
import java.util.stream.Stream;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.junit.Assert;
import org.junit.Before;
import org.junit.runner.RunWith;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.runners.MockitoJUnitRunner;
import org.mule.metadata.api.ClassTypeLoader;
import org.mule.metadata.api.builder.BaseTypeBuilder;
import org.mule.metadata.api.model.MetadataFormat;
import org.mule.runtime.extension.api.introspection.ExtensionModel;
import org.mule.runtime.extension.api.introspection.config.ConfigurationModel;
import org.mule.runtime.extension.api.introspection.connection.ConnectionProviderModel;
import org.mule.runtime.extension.api.introspection.declaration.type.ExtensionsTypeLoaderFactory;
import org.mule.runtime.extension.api.introspection.operation.OperationModel;
import org.mule.runtime.extension.api.introspection.parameter.ExpressionSupport;
import org.mule.runtime.extension.api.introspection.parameter.ParameterModel;
import org.mule.runtime.extension.api.introspection.property.ImportedTypesModelProperty;
import org.mule.runtime.extension.api.introspection.property.SubTypesModelProperty;
import org.mule.runtime.extension.api.introspection.source.SourceModel;
import org.mule.runtime.extension.xml.dsl.api.DslElementDeclaration;
import org.mule.runtime.extension.xml.dsl.api.property.XmlModelProperty;

@RunWith(value=MockitoJUnitRunner.class)
public abstract class BaseXmlDeclarationTestCase {
    protected static final String NAMESPACE = "mockns";
    protected static final String NAMESPACE_URI = "http://www.mulesoft.org/schema/mule/mockns";
    protected static final String SCHEMA_LOCATION = "http://www.mulesoft.org/schema/mule/mockns/current/mule-mockns.xsd";
    protected static final String PARAMETER_NAME = "myCamelCaseName";
    protected static final String EXTENSION_NAME = "extension";
    protected static final String OPERATION_NAME = "mockOperation";
    protected static final String SOURCE_NAME = "source";
    protected static final String CONFIGURATION_NAME = "configuration";
    protected static final String CONNECTION_PROVIDER_NAME = "connection";
    protected static final String IMPORT_NAMESPACE = "importns";
    protected static final String IMPORT_NAMESPACE_URI = "http://www.mulesoft.org/schema/mule/importns";
    protected static final String IMPORT_EXTENSION_NAME = "importExtension";
    protected static final BaseTypeBuilder<?> TYPE_BUILDER = BaseTypeBuilder.create((MetadataFormat)MetadataFormat.JAVA);
    @Mock
    protected ExtensionModel extension;
    @Mock
    protected ConfigurationModel configuration;
    @Mock
    protected OperationModel operation;
    @Mock
    protected ConnectionProviderModel connectionProvider;
    @Mock
    protected ParameterModel parameterModel;
    @Mock
    protected SourceModel source;
    protected ClassTypeLoader TYPE_LOADER = ExtensionsTypeLoaderFactory.getDefault().createTypeLoader();

    @Before
    public void before() {
        Mockito.when((Object)this.extension.getName()).thenReturn((Object)EXTENSION_NAME);
        Mockito.when((Object)this.extension.getConfigurationModels()).thenReturn(Arrays.asList(this.configuration));
        Mockito.when((Object)this.extension.getConfigurationModels()).thenReturn(Arrays.asList(this.configuration));
        Mockito.when((Object)this.extension.getOperationModels()).thenReturn(Arrays.asList(this.operation));
        Mockito.when((Object)this.extension.getSourceModels()).thenReturn(Arrays.asList(this.source));
        Mockito.when((Object)this.extension.getConnectionProviders()).thenReturn(Arrays.asList(this.connectionProvider));
        Mockito.when((Object)this.extension.getModelProperty(SubTypesModelProperty.class)).thenReturn(Optional.empty());
        Mockito.when((Object)this.extension.getModelProperty(ImportedTypesModelProperty.class)).thenReturn(Optional.empty());
        Mockito.when((Object)this.extension.getModelProperty(XmlModelProperty.class)).thenReturn(Optional.of(new XmlModelProperty("", NAMESPACE, NAMESPACE_URI, "", SCHEMA_LOCATION)));
        Mockito.when((Object)this.configuration.getOperationModels()).thenReturn(Arrays.asList(this.operation));
        Mockito.when((Object)this.configuration.getSourceModels()).thenReturn(Arrays.asList(this.source));
        Mockito.when((Object)this.configuration.getConnectionProviders()).thenReturn(Arrays.asList(this.connectionProvider));
        Mockito.when((Object)this.parameterModel.getName()).thenReturn((Object)PARAMETER_NAME);
        Mockito.when((Object)this.parameterModel.getExpressionSupport()).thenReturn((Object)ExpressionSupport.SUPPORTED);
        Mockito.when((Object)this.source.getName()).thenReturn((Object)SOURCE_NAME);
        Mockito.when((Object)this.operation.getName()).thenReturn((Object)OPERATION_NAME);
        Mockito.when((Object)this.configuration.getName()).thenReturn((Object)CONFIGURATION_NAME);
        Mockito.when((Object)this.connectionProvider.getName()).thenReturn((Object)CONNECTION_PROVIDER_NAME);
        Stream.of(this.configuration, this.operation, this.connectionProvider, this.source).forEach(model -> Mockito.when((Object)model.getParameterModels()).thenReturn(Arrays.asList(this.parameterModel)));
    }

    protected void assertChildElementDeclarationIs(boolean expected, DslElementDeclaration result) {
        Assert.assertThat((String)"Expected attribute only declaration", (Object)result.supportsChildDeclaration(), (Matcher)CoreMatchers.is((Object)expected));
    }

    protected void assertIsWrappedElement(boolean expected, DslElementDeclaration result) {
        Assert.assertThat((String)"Expected no wrapping but element is wrapped", (Object)result.isWrapped(), (Matcher)CoreMatchers.is((Object)expected));
    }

    protected void assertAttributeName(String expected, DslElementDeclaration result) {
        Assert.assertThat((Object)result.getAttributeName(), (Matcher)CoreMatchers.equalTo((Object)expected));
    }

    protected void assertElementName(String expected, DslElementDeclaration result) {
        Assert.assertThat((Object)result.getElementName(), (Matcher)CoreMatchers.equalTo((Object)expected));
    }

    protected void assertElementNamespace(String expected, DslElementDeclaration result) {
        Assert.assertThat((Object)result.getElementNamespace(), (Matcher)CoreMatchers.equalTo((Object)expected));
    }
}

