/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.extension.xml.dsl.test;

import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.Mockito;
import org.mockito.runners.MockitoJUnitRunner;
import org.mule.metadata.api.model.ArrayType;
import org.mule.metadata.api.model.MetadataType;
import org.mule.metadata.api.model.impl.DefaultStringType;
import org.mule.metadata.utils.MetadataTypeUtils;
import org.mule.runtime.extension.api.annotation.Extension;
import org.mule.runtime.extension.api.annotation.capability.Xml;
import org.mule.runtime.extension.api.introspection.property.ImportedTypesModelProperty;
import org.mule.runtime.extension.api.introspection.property.SubTypesModelProperty;
import org.mule.runtime.extension.api.util.NameUtils;
import org.mule.runtime.extension.xml.dsl.api.DslElementDeclaration;
import org.mule.runtime.extension.xml.dsl.api.resolver.DslElementResolver;
import org.mule.runtime.extension.xml.dsl.test.BaseXmlDeclarationTestCase;
import org.mule.runtime.extension.xml.dsl.test.model.AbstractType;
import org.mule.runtime.extension.xml.dsl.test.model.ChildOfAbstractType;
import org.mule.runtime.extension.xml.dsl.test.model.ComplexFieldsType;
import org.mule.runtime.extension.xml.dsl.test.model.EmptyType;
import org.mule.runtime.extension.xml.dsl.test.model.ExtensibleType;
import org.mule.runtime.extension.xml.dsl.test.model.InterfaceDeclaration;
import org.mule.runtime.extension.xml.dsl.test.model.InterfaceDeclarationWithMapping;
import org.mule.runtime.extension.xml.dsl.test.model.InterfaceImplementation;
import org.mule.runtime.extension.xml.dsl.test.model.NonDefaultConstructor;
import org.mule.runtime.extension.xml.dsl.test.model.SimpleFieldsType;

@RunWith(value=MockitoJUnitRunner.class)
public class ParameterXmlDeclarationTestCase
extends BaseXmlDeclarationTestCase {
    @Test
    public void testSimpleTypeParameter() {
        Mockito.when((Object)this.parameterModel.getType()).thenReturn((Object)this.TYPE_LOADER.load(String.class));
        DslElementDeclaration result = new DslElementResolver(this.extension).resolve(this.parameterModel);
        this.assertAttributeName("myCamelCaseName", result);
        this.assertElementName(NameUtils.hyphenize((String)"myCamelCaseName"), result);
        this.assertElementNamespace("mockns", result);
        this.assertChildElementDeclarationIs(false, result);
        this.assertIsWrappedElement(false, result);
    }

    @Test
    public void testSimplePojoParameter() {
        Mockito.when((Object)this.parameterModel.getType()).thenReturn((Object)this.TYPE_LOADER.load(SimpleFieldsType.class));
        DslElementDeclaration result = new DslElementResolver(this.extension).resolve(this.parameterModel);
        this.assertChildElementDeclarationIs(true, result);
        this.assertIsWrappedElement(false, result);
    }

    @Test
    public void testComplexPojoParameter() {
        Mockito.when((Object)this.parameterModel.getType()).thenReturn((Object)this.TYPE_LOADER.load(ComplexFieldsType.class));
        DslElementDeclaration result = new DslElementResolver(this.extension).resolve(this.parameterModel);
        this.assertChildElementDeclarationIs(true, result);
        this.assertIsWrappedElement(false, result);
    }

    @Test
    public void testEmptyTypeParameter() {
        Mockito.when((Object)this.parameterModel.getType()).thenReturn((Object)this.TYPE_LOADER.load(EmptyType.class));
        DslElementDeclaration result = new DslElementResolver(this.extension).resolve(this.parameterModel);
        this.assertChildElementDeclarationIs(false, result);
        this.assertIsWrappedElement(false, result);
    }

    @Test
    public void testExtensibleTypeParameter() {
        Mockito.when((Object)this.parameterModel.getType()).thenReturn((Object)this.TYPE_LOADER.load(ExtensibleType.class));
        DslElementDeclaration result = new DslElementResolver(this.extension).resolve(this.parameterModel);
        this.assertChildElementDeclarationIs(true, result);
        this.assertIsWrappedElement(true, result);
    }

    @Test
    public void testInterfaceTypeParameter() {
        Mockito.when((Object)this.parameterModel.getType()).thenReturn((Object)this.TYPE_LOADER.load(InterfaceDeclaration.class));
        DslElementDeclaration result = new DslElementResolver(this.extension).resolve(this.parameterModel);
        this.assertChildElementDeclarationIs(false, result);
        this.assertIsWrappedElement(false, result);
    }

    @Test
    public void testAbstractClassParameter() {
        Mockito.when((Object)this.parameterModel.getType()).thenReturn((Object)this.TYPE_LOADER.load(AbstractType.class));
        DslElementDeclaration result = new DslElementResolver(this.extension).resolve(this.parameterModel);
        this.assertChildElementDeclarationIs(false, result);
        this.assertIsWrappedElement(false, result);
    }

    @Test
    public void testNonDefaultConstructorParameter() {
        Mockito.when((Object)this.parameterModel.getType()).thenReturn((Object)this.TYPE_LOADER.load(NonDefaultConstructor.class));
        DslElementDeclaration result = new DslElementResolver(this.extension).resolve(this.parameterModel);
        this.assertChildElementDeclarationIs(false, result);
        this.assertIsWrappedElement(false, result);
    }

    @Test
    public void testInterfaceWithMappingParameter() {
        HashMap<MetadataType, List<MetadataType>> mapping = new HashMap<MetadataType, List<MetadataType>>();
        mapping.put(this.TYPE_LOADER.load(InterfaceDeclarationWithMapping.class), Collections.singletonList(this.TYPE_LOADER.load(InterfaceImplementation.class)));
        Mockito.when((Object)this.extension.getModelProperty(SubTypesModelProperty.class)).thenReturn(Optional.of(new SubTypesModelProperty(mapping)));
        Mockito.when((Object)this.parameterModel.getType()).thenReturn((Object)this.TYPE_LOADER.load(InterfaceDeclarationWithMapping.class));
        DslElementDeclaration result = new DslElementResolver(this.extension).resolve(this.parameterModel);
        this.assertChildElementDeclarationIs(true, result);
        this.assertIsWrappedElement(true, result);
    }

    @Test
    public void testAbstractWithMappingParameter() {
        HashMap<MetadataType, List<MetadataType>> mapping = new HashMap<MetadataType, List<MetadataType>>();
        mapping.put(this.TYPE_LOADER.load(AbstractType.class), Collections.singletonList(this.TYPE_LOADER.load(ChildOfAbstractType.class)));
        Mockito.when((Object)this.extension.getModelProperty(SubTypesModelProperty.class)).thenReturn(Optional.of(new SubTypesModelProperty(mapping)));
        Mockito.when((Object)this.parameterModel.getType()).thenReturn((Object)this.TYPE_LOADER.load(AbstractType.class));
        DslElementDeclaration result = new DslElementResolver(this.extension).resolve(this.parameterModel);
        this.assertChildElementDeclarationIs(true, result);
        this.assertIsWrappedElement(true, result);
    }

    @Test
    public void testImportedFinalTypeWithXmlParameter() {
        HashMap<MetadataType, MetadataType> imports = new HashMap<MetadataType, MetadataType>();
        imports.put(this.TYPE_LOADER.load(SimpleFieldsType.class), this.TYPE_LOADER.load(ExtensionForImportsDeclaresXml.class));
        Mockito.when((Object)this.extension.getModelProperty(ImportedTypesModelProperty.class)).thenReturn(Optional.of(new ImportedTypesModelProperty(imports)));
        Mockito.when((Object)this.parameterModel.getType()).thenReturn((Object)this.TYPE_LOADER.load(SimpleFieldsType.class));
        DslElementDeclaration result = new DslElementResolver(this.extension).resolve(this.parameterModel);
        this.assertElementNamespace("mockns", result);
        this.assertChildElementDeclarationIs(true, result);
        this.assertIsWrappedElement(false, result);
    }

    @Test
    public void testImportedFinalTypeWithoutXmlParameter() {
        HashMap<MetadataType, MetadataType> imports = new HashMap<MetadataType, MetadataType>();
        imports.put(this.TYPE_LOADER.load(SimpleFieldsType.class), this.TYPE_LOADER.load(ExtensionForImportsNoXml.class));
        Mockito.when((Object)this.extension.getModelProperty(ImportedTypesModelProperty.class)).thenReturn(Optional.of(new ImportedTypesModelProperty(imports)));
        Mockito.when((Object)this.parameterModel.getType()).thenReturn((Object)this.TYPE_LOADER.load(SimpleFieldsType.class));
        DslElementDeclaration result = new DslElementResolver(this.extension).resolve(this.parameterModel);
        this.assertElementNamespace("mockns", result);
        this.assertChildElementDeclarationIs(true, result);
        this.assertIsWrappedElement(false, result);
    }

    @Test
    public void testExtensibleImportParameter() {
        HashMap<MetadataType, MetadataType> imports = new HashMap<MetadataType, MetadataType>();
        imports.put(this.TYPE_LOADER.load(ExtensibleType.class), this.TYPE_LOADER.load(ExtensionForImportsDeclaresXml.class));
        Mockito.when((Object)this.extension.getModelProperty(ImportedTypesModelProperty.class)).thenReturn(Optional.of(new ImportedTypesModelProperty(imports)));
        Mockito.when((Object)this.parameterModel.getType()).thenReturn((Object)this.TYPE_LOADER.load(ExtensibleType.class));
        DslElementDeclaration result = new DslElementResolver(this.extension).resolve(this.parameterModel);
        this.assertElementNamespace("importns", result);
        this.assertChildElementDeclarationIs(true, result);
        this.assertIsWrappedElement(true, result);
    }

    @Test
    public void testExtensibleImportedTypeWithoutXmlParameter() {
        HashMap<MetadataType, MetadataType> imports = new HashMap<MetadataType, MetadataType>();
        imports.put(this.TYPE_LOADER.load(ExtensibleType.class), this.TYPE_LOADER.load(ExtensionForImportsNoXml.class));
        Mockito.when((Object)this.extension.getModelProperty(ImportedTypesModelProperty.class)).thenReturn(Optional.of(new ImportedTypesModelProperty(imports)));
        Mockito.when((Object)this.parameterModel.getType()).thenReturn((Object)this.TYPE_LOADER.load(ExtensibleType.class));
        DslElementDeclaration result = new DslElementResolver(this.extension).resolve(this.parameterModel);
        this.assertElementNamespace(NameUtils.defaultNamespace((String)"importExtension"), result);
        this.assertChildElementDeclarationIs(true, result);
        this.assertIsWrappedElement(true, result);
    }

    @Test
    public void testMapOfSimpleTypeParameter() {
        DefaultStringType keyType = TYPE_BUILDER.stringType().id(String.class.getName()).build();
        DefaultStringType valueType = TYPE_BUILDER.stringType().id(String.class.getName()).build();
        Mockito.when((Object)this.parameterModel.getType()).thenReturn((Object)TYPE_BUILDER.dictionaryType().id(Map.class.getName()).ofKey((MetadataType)keyType).ofValue((MetadataType)valueType).build());
        DslElementDeclaration result = new DslElementResolver(this.extension).resolve(this.parameterModel);
        this.assertAttributeName("myCamelCaseName", result);
        this.assertElementName(NameUtils.hyphenize((String)NameUtils.pluralize((String)"myCamelCaseName")), result);
        this.assertElementNamespace("mockns", result);
        this.assertChildElementDeclarationIs(true, result);
        this.assertIsWrappedElement(false, result);
        DslElementDeclaration innerElement = this.getGenericTypeDsl((MetadataType)valueType, result);
        this.assertElementName(NameUtils.hyphenize((String)"myCamelCaseName"), innerElement);
        this.assertChildElementDeclarationIs(false, innerElement);
        this.assertIsWrappedElement(false, innerElement);
    }

    @Test
    public void testMapOfComplexTypeParameter() {
        DefaultStringType keyType = TYPE_BUILDER.stringType().id(String.class.getName()).build();
        MetadataType valueType = this.TYPE_LOADER.load(SimpleFieldsType.class);
        Mockito.when((Object)this.parameterModel.getType()).thenReturn((Object)TYPE_BUILDER.dictionaryType().id(Map.class.getName()).ofKey((MetadataType)keyType).ofValue(valueType).build());
        DslElementDeclaration result = new DslElementResolver(this.extension).resolve(this.parameterModel);
        this.assertAttributeName("myCamelCaseName", result);
        this.assertElementName(NameUtils.hyphenize((String)NameUtils.pluralize((String)"myCamelCaseName")), result);
        this.assertElementNamespace("mockns", result);
        this.assertChildElementDeclarationIs(true, result);
        this.assertIsWrappedElement(false, result);
        DslElementDeclaration innerElement = this.getGenericTypeDsl(valueType, result);
        this.assertElementName(NameUtils.hyphenize((String)"myCamelCaseName"), innerElement);
        this.assertChildElementDeclarationIs(true, innerElement);
        this.assertIsWrappedElement(false, innerElement);
    }

    @Test
    public void testMapOfWrappedTypeParameter() {
        DefaultStringType keyType = TYPE_BUILDER.stringType().id(String.class.getName()).build();
        MetadataType valueType = this.TYPE_LOADER.load(ExtensibleType.class);
        Mockito.when((Object)this.parameterModel.getType()).thenReturn((Object)TYPE_BUILDER.dictionaryType().id(Map.class.getName()).ofKey((MetadataType)keyType).ofValue(valueType).build());
        DslElementDeclaration result = new DslElementResolver(this.extension).resolve(this.parameterModel);
        this.assertAttributeName("myCamelCaseName", result);
        this.assertElementName(NameUtils.hyphenize((String)NameUtils.pluralize((String)"myCamelCaseName")), result);
        this.assertElementNamespace("mockns", result);
        this.assertChildElementDeclarationIs(true, result);
        this.assertIsWrappedElement(false, result);
        DslElementDeclaration innerElement = this.getGenericTypeDsl(valueType, result);
        this.assertElementName(NameUtils.hyphenize((String)"myCamelCaseName"), innerElement);
        this.assertChildElementDeclarationIs(true, innerElement);
        this.assertIsWrappedElement(false, innerElement);
    }

    @Test
    public void testMapOfNonInstantiableValueTypeParameter() {
        DefaultStringType keyType = TYPE_BUILDER.stringType().id(String.class.getName()).build();
        MetadataType valueType = this.TYPE_LOADER.load(InterfaceDeclaration.class);
        Mockito.when((Object)this.parameterModel.getType()).thenReturn((Object)TYPE_BUILDER.dictionaryType().id(Map.class.getName()).ofKey((MetadataType)keyType).ofValue(valueType).build());
        DslElementDeclaration result = new DslElementResolver(this.extension).resolve(this.parameterModel);
        this.assertAttributeName("myCamelCaseName", result);
        this.assertElementName(NameUtils.hyphenize((String)NameUtils.pluralize((String)"myCamelCaseName")), result);
        this.assertElementNamespace("mockns", result);
        this.assertChildElementDeclarationIs(true, result);
        this.assertIsWrappedElement(false, result);
        DslElementDeclaration innerElement = this.getGenericTypeDsl(valueType, result);
        this.assertElementName(NameUtils.hyphenize((String)NameUtils.singularize((String)"myCamelCaseName")), innerElement);
        this.assertChildElementDeclarationIs(false, innerElement);
        this.assertIsWrappedElement(false, innerElement);
    }

    @Test
    public void testCollectionOfSimpleTypeParameter() {
        DefaultStringType itemType = TYPE_BUILDER.stringType().id(String.class.getName()).build();
        Mockito.when((Object)this.parameterModel.getType()).thenReturn((Object)TYPE_BUILDER.arrayType().id(List.class.getName()).of((MetadataType)itemType).build());
        DslElementDeclaration result = new DslElementResolver(this.extension).resolve(this.parameterModel);
        this.assertAttributeName("myCamelCaseName", result);
        this.assertElementName(NameUtils.hyphenize((String)"myCamelCaseName"), result);
        this.assertElementNamespace("mockns", result);
        this.assertChildElementDeclarationIs(true, result);
        this.assertIsWrappedElement(false, result);
        DslElementDeclaration innerElement = this.getGenericTypeDsl((MetadataType)itemType, result);
        this.assertElementName(NameUtils.hyphenize((String)NameUtils.singularize((String)"myCamelCaseName")), innerElement);
        this.assertChildElementDeclarationIs(false, innerElement);
        this.assertIsWrappedElement(false, innerElement);
    }

    @Test
    public void testCollectionOfComplexTypeParameter() {
        MetadataType itemType = this.TYPE_LOADER.load(SimpleFieldsType.class);
        Mockito.when((Object)this.parameterModel.getType()).thenReturn((Object)TYPE_BUILDER.arrayType().id(List.class.getName()).of(itemType).build());
        DslElementDeclaration result = new DslElementResolver(this.extension).resolve(this.parameterModel);
        this.assertAttributeName("myCamelCaseName", result);
        this.assertElementName(NameUtils.hyphenize((String)"myCamelCaseName"), result);
        this.assertElementNamespace("mockns", result);
        this.assertChildElementDeclarationIs(true, result);
        this.assertIsWrappedElement(false, result);
        DslElementDeclaration innerElement = this.getGenericTypeDsl(itemType, result);
        this.assertElementName(NameUtils.getTopLevelTypeName((MetadataType)itemType), innerElement);
        this.assertElementNamespace("mockns", innerElement);
        this.assertChildElementDeclarationIs(true, innerElement);
        this.assertIsWrappedElement(false, innerElement);
    }

    @Test
    public void testCollectionOfWrappedTypeParameter() {
        MetadataType itemType = this.TYPE_LOADER.load(ExtensibleType.class);
        Mockito.when((Object)this.parameterModel.getType()).thenReturn((Object)TYPE_BUILDER.arrayType().id(List.class.getName()).of(itemType).build());
        DslElementDeclaration result = new DslElementResolver(this.extension).resolve(this.parameterModel);
        this.assertAttributeName("myCamelCaseName", result);
        this.assertElementName(NameUtils.hyphenize((String)"myCamelCaseName"), result);
        this.assertElementNamespace("mockns", result);
        this.assertChildElementDeclarationIs(true, result);
        this.assertIsWrappedElement(false, result);
        DslElementDeclaration innerElement = this.getGenericTypeDsl(itemType, result);
        this.assertElementName(NameUtils.getTopLevelTypeName((MetadataType)itemType), innerElement);
        this.assertElementNamespace("mockns", innerElement);
        this.assertChildElementDeclarationIs(true, innerElement);
        this.assertIsWrappedElement(false, innerElement);
    }

    @Test
    public void testCollectionOfNonInstantiableTypeParameter() {
        MetadataType itemType = this.TYPE_LOADER.load(InterfaceDeclaration.class);
        Mockito.when((Object)this.parameterModel.getType()).thenReturn((Object)TYPE_BUILDER.arrayType().id(List.class.getName()).of(itemType).build());
        DslElementDeclaration result = new DslElementResolver(this.extension).resolve(this.parameterModel);
        this.assertAttributeName("myCamelCaseName", result);
        this.assertElementName(NameUtils.hyphenize((String)"myCamelCaseName"), result);
        this.assertElementNamespace("mockns", result);
        this.assertChildElementDeclarationIs(false, result);
        this.assertIsWrappedElement(false, result);
        Assert.assertThat((Object)result.getGeneric(itemType).isPresent(), (Matcher)CoreMatchers.is((Object)false));
    }

    @Test
    public void testMapOfListOfComplexTypeParameter() {
        MetadataType itemType = this.TYPE_LOADER.load(ExtensibleType.class);
        ArrayType valueType = TYPE_BUILDER.arrayType().id(List.class.getName()).of(itemType).build();
        DefaultStringType keyType = TYPE_BUILDER.stringType().id(String.class.getName()).build();
        Mockito.when((Object)this.parameterModel.getType()).thenReturn((Object)TYPE_BUILDER.dictionaryType().id(Map.class.getName()).ofKey((MetadataType)keyType).ofValue((MetadataType)valueType).build());
        DslElementDeclaration mapDsl = new DslElementResolver(this.extension).resolve(this.parameterModel);
        this.assertAttributeName("myCamelCaseName", mapDsl);
        this.assertElementName(NameUtils.hyphenize((String)NameUtils.pluralize((String)"myCamelCaseName")), mapDsl);
        this.assertElementNamespace("mockns", mapDsl);
        this.assertChildElementDeclarationIs(true, mapDsl);
        this.assertIsWrappedElement(false, mapDsl);
        DslElementDeclaration listDsl = this.getGenericTypeDsl((MetadataType)valueType, mapDsl);
        this.assertElementName(NameUtils.hyphenize((String)NameUtils.singularize((String)"myCamelCaseName")), listDsl);
        this.assertChildElementDeclarationIs(true, listDsl);
        this.assertIsWrappedElement(false, listDsl);
        DslElementDeclaration itemDsl = this.getGenericTypeDsl(itemType, listDsl);
        this.assertElementName(NameUtils.getTopLevelTypeName((MetadataType)itemType), itemDsl);
        this.assertChildElementDeclarationIs(true, itemDsl);
        this.assertIsWrappedElement(false, itemDsl);
    }

    @Test
    public void testMapOfListOfSimpleTypeParameter() {
        MetadataType itemType = this.TYPE_LOADER.load(String.class);
        ArrayType valueType = TYPE_BUILDER.arrayType().id(List.class.getName()).of(itemType).build();
        DefaultStringType keyType = TYPE_BUILDER.stringType().id(String.class.getName()).build();
        Mockito.when((Object)this.parameterModel.getType()).thenReturn((Object)TYPE_BUILDER.dictionaryType().id(Map.class.getName()).ofKey((MetadataType)keyType).ofValue((MetadataType)valueType).build());
        DslElementDeclaration mapDsl = new DslElementResolver(this.extension).resolve(this.parameterModel);
        this.assertAttributeName("myCamelCaseName", mapDsl);
        this.assertElementName(NameUtils.hyphenize((String)NameUtils.pluralize((String)"myCamelCaseName")), mapDsl);
        this.assertElementNamespace("mockns", mapDsl);
        this.assertChildElementDeclarationIs(true, mapDsl);
        this.assertIsWrappedElement(false, mapDsl);
        DslElementDeclaration listDsl = this.getGenericTypeDsl((MetadataType)valueType, mapDsl);
        this.assertElementName(NameUtils.hyphenize((String)NameUtils.singularize((String)"myCamelCaseName")), listDsl);
        this.assertChildElementDeclarationIs(true, listDsl);
        this.assertIsWrappedElement(false, listDsl);
        DslElementDeclaration itemDsl = this.getGenericTypeDsl(itemType, listDsl);
        this.assertElementName(NameUtils.itemize((String)NameUtils.singularize((String)"myCamelCaseName")), itemDsl);
        this.assertChildElementDeclarationIs(false, itemDsl);
        this.assertIsWrappedElement(false, itemDsl);
    }

    @Test
    public void testComplexRecursiveType() {
        MetadataType type = this.TYPE_LOADER.load(ComplexFieldsType.class);
        DslElementDeclaration topDsl = new DslElementResolver(this.extension).resolve(type);
        this.assertElementName(NameUtils.getTopLevelTypeName((MetadataType)type), topDsl);
        this.assertElementNamespace("mockns", topDsl);
        this.assertChildElementDeclarationIs(true, topDsl);
        this.assertIsWrappedElement(false, topDsl);
        String extensibleTypeListName = "extensibleTypeList";
        DslElementDeclaration listDsl = this.getChildFieldDsl("extensibleTypeList", topDsl);
        this.assertAttributeName(extensibleTypeListName, listDsl);
        this.assertElementName(NameUtils.hyphenize((String)extensibleTypeListName), listDsl);
        this.assertElementNamespace("mockns", listDsl);
        this.assertChildElementDeclarationIs(true, listDsl);
        this.assertIsWrappedElement(false, listDsl);
        MetadataType listItemType = this.TYPE_LOADER.load(ExtensibleType.class);
        DslElementDeclaration innerElement = this.getGenericTypeDsl(listItemType, listDsl);
        this.assertElementName(NameUtils.getTopLevelTypeName((MetadataType)listItemType), innerElement);
        this.assertChildElementDeclarationIs(true, innerElement);
        this.assertIsWrappedElement(false, innerElement);
        String recursiveChildName = "recursiveChild";
        DslElementDeclaration recursiveChildDsl = this.getChildFieldDsl(recursiveChildName, topDsl);
        this.assertAttributeName(recursiveChildName, recursiveChildDsl);
        this.assertElementName(NameUtils.hyphenize((String)recursiveChildName), recursiveChildDsl);
        this.assertElementNamespace("mockns", recursiveChildDsl);
        this.assertChildElementDeclarationIs(true, recursiveChildDsl);
        this.assertIsWrappedElement(false, recursiveChildDsl);
        String simplePojoName = "simplePojo";
        DslElementDeclaration simplePojoDsl = this.getChildFieldDsl("simplePojo", topDsl);
        this.assertAttributeName(simplePojoName, simplePojoDsl);
        this.assertElementName(NameUtils.hyphenize((String)simplePojoName), simplePojoDsl);
        this.assertElementNamespace("mockns", simplePojoDsl);
        this.assertChildElementDeclarationIs(true, simplePojoDsl);
        this.assertIsWrappedElement(false, simplePojoDsl);
    }

    private DslElementDeclaration getGenericTypeDsl(MetadataType itemType, DslElementDeclaration result) {
        Optional genericDsl = result.getGeneric(itemType);
        Assert.assertThat((String)("No generic element found for type [" + MetadataTypeUtils.getTypeId((MetadataType)itemType).orElse("") + "] for element [" + result.getElementName() + "]"), (Object)genericDsl.isPresent(), (Matcher)CoreMatchers.is((Object)true));
        return (DslElementDeclaration)genericDsl.get();
    }

    private DslElementDeclaration getChildFieldDsl(String name, DslElementDeclaration parent) {
        Optional childDsl = parent.getChild(name);
        Assert.assertThat((String)("No child element found with name [" + name + "] for element [" + parent.getElementName() + "]"), (Object)childDsl.isPresent(), (Matcher)CoreMatchers.is((Object)true));
        return (DslElementDeclaration)childDsl.get();
    }

    @Extension(name="importExtension")
    private static final class ExtensionForImportsNoXml {
        private ExtensionForImportsNoXml() {
        }
    }

    @Xml(namespace="importns", namespaceLocation="http://www.mulesoft.org/schema/mule/importns")
    @Extension(name="importExtension")
    private static final class ExtensionForImportsDeclaresXml {
        private ExtensionForImportsDeclaresXml() {
        }
    }
}

