/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.extension.xml.dsl.api;

import java.util.function.Supplier;
import org.apache.commons.lang3.StringUtils;
import org.mule.runtime.extension.api.annotation.capability.Xml;
import org.mule.runtime.extension.api.util.NameUtils;
import org.mule.runtime.extension.xml.dsl.api.property.XmlModelProperty;

public final class XmlModelUtils {
    private static final String XSD_EXTENSION = ".xsd";
    private static final String CURRENT_VERSION = "current";
    private static final String DEFAULT_SCHEMA_LOCATION_MASK = "http://www.mulesoft.org/schema/mule/%s";

    public static XmlModelProperty createXmlModelProperty(Xml xml, String extensionName, String extensionVersion) {
        String namespace = XmlModelUtils.calculateValue(xml, () -> xml.namespace(), () -> NameUtils.defaultNamespace((String)extensionName));
        String namespaceLocation = XmlModelUtils.calculateValue(xml, () -> xml.namespaceLocation(), () -> XmlModelUtils.buildDefaultLocation(namespace));
        String xsdFileName = XmlModelUtils.buildDefaultXsdFileName(namespace);
        String schemaLocation = XmlModelUtils.buildDefaultSchemaLocation(namespaceLocation, xsdFileName);
        return new XmlModelProperty(extensionVersion, namespace, namespaceLocation, xsdFileName, schemaLocation);
    }

    private static String calculateValue(Xml xml, Supplier<String> value, Supplier<String> fallback) {
        String result;
        if (xml != null && StringUtils.isNotBlank((CharSequence)(result = value.get()))) {
            return result;
        }
        return fallback.get();
    }

    private static String buildDefaultLocation(String namespace) {
        return String.format(DEFAULT_SCHEMA_LOCATION_MASK, namespace);
    }

    private static String buildDefaultXsdFileName(String namespace) {
        return String.format("mule-%s%s", namespace, XSD_EXTENSION);
    }

    private static String buildDefaultSchemaLocation(String namespaceLocation, String xsdFileName) {
        return String.format("%s/%s/%s", namespaceLocation, CURRENT_VERSION, xsdFileName);
    }
}

