/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.extension.xml.dsl.api.resolver;

import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import org.mule.metadata.api.model.ArrayType;
import org.mule.metadata.api.model.DictionaryType;
import org.mule.metadata.api.model.MetadataType;
import org.mule.metadata.api.model.ObjectFieldType;
import org.mule.metadata.api.model.ObjectType;
import org.mule.metadata.api.visitor.MetadataTypeVisitor;
import org.mule.metadata.java.api.annotation.ClassInformationAnnotation;
import org.mule.metadata.java.api.utils.JavaTypeUtils;
import org.mule.metadata.utils.MetadataTypeUtils;
import org.mule.runtime.extension.api.annotation.Extension;
import org.mule.runtime.extension.api.annotation.capability.Xml;
import org.mule.runtime.extension.api.introspection.ExtensionModel;
import org.mule.runtime.extension.api.introspection.Named;
import org.mule.runtime.extension.api.introspection.declaration.type.annotation.ExtensibleTypeAnnotation;
import org.mule.runtime.extension.api.introspection.parameter.ExpressionSupport;
import org.mule.runtime.extension.api.introspection.parameter.ParameterModel;
import org.mule.runtime.extension.api.introspection.property.ImportedTypesModelProperty;
import org.mule.runtime.extension.api.introspection.property.SubTypesModelProperty;
import org.mule.runtime.extension.api.util.NameUtils;
import org.mule.runtime.extension.api.util.SubTypesMappingContainer;
import org.mule.runtime.extension.xml.dsl.api.DslElementDeclaration;
import org.mule.runtime.extension.xml.dsl.api.XmlModelUtils;
import org.mule.runtime.extension.xml.dsl.api.property.XmlModelProperty;
import org.mule.runtime.extension.xml.dsl.internal.DslElementDeclarationBuilder;

public class DslElementResolver {
    private Map<MetadataType, XmlModelProperty> importedTypes;
    private final SubTypesMappingContainer subTypesMapping;
    private final XmlModelProperty extensionXml;

    public DslElementResolver(ExtensionModel model) {
        this.extensionXml = this.loadXmlProperties(model);
        this.subTypesMapping = this.loadSubTypes(model);
        this.importedTypes = this.loadImportedTypes(model);
    }

    public DslElementDeclaration resolve(Named component) {
        return DslElementDeclarationBuilder.create().withElementName(NameUtils.hyphenize((String)component.getName())).withNamespace(this.extensionXml.getNamespace()).build();
    }

    public DslElementDeclaration resolve(final ParameterModel parameter) {
        final ExpressionSupport expressionSupport = parameter.getExpressionSupport();
        final DslElementDeclarationBuilder builder = DslElementDeclarationBuilder.create();
        final String namespace = this.getNamespace(parameter.getType());
        parameter.getType().accept(new MetadataTypeVisitor(){

            protected void defaultVisit(MetadataType metadataType) {
                builder.withAttributeName(parameter.getName()).withNamespace(namespace).withElementName(NameUtils.hyphenize((String)parameter.getName()));
            }

            public void visitArrayType(ArrayType arrayType) {
                this.defaultVisit((MetadataType)arrayType);
                MetadataType genericType = arrayType.getType();
                if (DslElementResolver.this.shouldGenerateChildElements(genericType, expressionSupport)) {
                    builder.supportsChildDeclaration(true);
                    genericType.accept(DslElementResolver.this.getArrayItemTypeVisitor(builder, parameter.getName(), namespace, false));
                }
            }

            public void visitObject(ObjectType objectType) {
                builder.withAttributeName(parameter.getName()).withNamespace(namespace).withElementName(NameUtils.hyphenize((String)parameter.getName()));
                if (DslElementResolver.this.shouldGenerateChildElements((MetadataType)objectType, expressionSupport)) {
                    builder.supportsChildDeclaration(true);
                    if (DslElementResolver.this.typeRequiresWrapperElement((MetadataType)objectType)) {
                        builder.asWrappedElement(true).withNamespace(namespace);
                    } else {
                        builder.withNamespace(DslElementResolver.this.extensionXml.getNamespace());
                    }
                }
            }

            public void visitDictionary(DictionaryType dictionaryType) {
                builder.withAttributeName(parameter.getName()).withNamespace(namespace).withElementName(NameUtils.hyphenize((String)NameUtils.pluralize((String)parameter.getName()))).supportsChildDeclaration(DslElementResolver.this.shouldGenerateChildElements(dictionaryType.getKeyType(), expressionSupport));
                dictionaryType.getValueType().accept(DslElementResolver.this.getDictionaryValueTypeVisitor(builder, parameter.getName(), namespace));
            }
        });
        return builder.build();
    }

    public DslElementDeclaration resolve(MetadataType type) {
        DslElementDeclarationBuilder typeBuilder = DslElementDeclarationBuilder.create();
        this.resolve(type, typeBuilder);
        return typeBuilder.build();
    }

    private MetadataTypeVisitor getArrayItemTypeVisitor(final DslElementDeclarationBuilder listBuilder, final String parameterName, final String namespace, final boolean asItem) {
        return new MetadataTypeVisitor(){

            public void visitObject(ObjectType objectType) {
                listBuilder.withGeneric((MetadataType)objectType, DslElementResolver.this.resolve((MetadataType)objectType));
            }

            public void visitArrayType(ArrayType arrayType) {
                DslElementDeclarationBuilder genericBuilder = DslElementDeclarationBuilder.create().withNamespace(namespace).withElementName(this.getItemName());
                MetadataType genericType = arrayType.getType();
                if (DslElementResolver.this.shouldGenerateChildElements(genericType, ExpressionSupport.SUPPORTED)) {
                    genericBuilder.supportsChildDeclaration(true);
                    genericType.accept(DslElementResolver.this.getArrayItemTypeVisitor(genericBuilder, parameterName, namespace, true));
                }
                listBuilder.withGeneric((MetadataType)arrayType, genericBuilder.build());
            }

            protected void defaultVisit(MetadataType metadataType) {
                listBuilder.withGeneric(metadataType, DslElementDeclarationBuilder.create().withNamespace(namespace).withElementName(this.getItemName()).build());
            }

            private String getItemName() {
                return asItem ? NameUtils.itemize((String)NameUtils.singularize((String)parameterName)) : NameUtils.hyphenize((String)NameUtils.singularize((String)parameterName));
            }
        };
    }

    private MetadataTypeVisitor getDictionaryValueTypeVisitor(final DslElementDeclarationBuilder mapBuilder, final String parameterName, final String namespace) {
        return new MetadataTypeVisitor(){

            public void visitObject(ObjectType objectType) {
                mapBuilder.withGeneric((MetadataType)objectType, DslElementDeclarationBuilder.create().withNamespace(namespace).withElementName(NameUtils.hyphenize((String)NameUtils.singularize((String)parameterName))).supportsChildDeclaration(DslElementResolver.this.shouldGenerateChildElements((MetadataType)objectType, ExpressionSupport.SUPPORTED)).build());
            }

            public void visitArrayType(ArrayType arrayType) {
                DslElementDeclarationBuilder listBuilder = DslElementDeclarationBuilder.create().withNamespace(namespace).withElementName(NameUtils.hyphenize((String)NameUtils.singularize((String)parameterName)));
                MetadataType genericType = arrayType.getType();
                if (DslElementResolver.this.shouldGenerateChildElements(genericType, ExpressionSupport.SUPPORTED)) {
                    listBuilder.supportsChildDeclaration(true);
                    genericType.accept(DslElementResolver.this.getArrayItemTypeVisitor(listBuilder, parameterName, namespace, true));
                }
                mapBuilder.withGeneric((MetadataType)arrayType, listBuilder.build());
            }

            protected void defaultVisit(MetadataType metadataType) {
                mapBuilder.withGeneric(metadataType, DslElementDeclarationBuilder.create().withNamespace(namespace).withElementName(NameUtils.hyphenize((String)NameUtils.singularize((String)parameterName))).build());
            }
        };
    }

    private DslElementDeclaration resolve(MetadataType type, final DslElementDeclarationBuilder builder) {
        final String namespace = this.getNamespace(type);
        type.accept(new MetadataTypeVisitor(){

            public void visitObject(ObjectType objectType) {
                builder.withNamespace(namespace).withElementName(NameUtils.getTopLevelTypeName((MetadataType)objectType)).supportsChildDeclaration(DslElementResolver.this.shouldGenerateChildElements((MetadataType)objectType, ExpressionSupport.SUPPORTED));
                DslElementResolver.this.declareFieldsAsChilds(builder, objectType.getFields(), namespace);
            }
        });
        return builder.build();
    }

    private MetadataTypeVisitor getObjectFieldVisitor(final DslElementDeclarationBuilder objectFieldBuilder, final String fieldName, final String ownerNamespace) {
        return new MetadataTypeVisitor(){

            public void visitObject(ObjectType objectType) {
                objectFieldBuilder.withAttributeName(fieldName).withElementName(NameUtils.hyphenize((String)fieldName)).withNamespace(DslElementResolver.this.getNamespace((MetadataType)objectType, ownerNamespace)).supportsChildDeclaration(DslElementResolver.this.shouldGenerateChildElements((MetadataType)objectType, ExpressionSupport.SUPPORTED));
                List fields = objectType.getFields().stream().filter(f -> !f.getValue().equals(objectType)).collect(Collectors.toList());
                DslElementResolver.this.declareFieldsAsChilds(objectFieldBuilder, fields, ownerNamespace);
            }

            public void visitArrayType(ArrayType arrayType) {
                objectFieldBuilder.withAttributeName(fieldName).withElementName(NameUtils.hyphenize((String)fieldName)).withNamespace(ownerNamespace);
                MetadataType genericType = arrayType.getType();
                if (DslElementResolver.this.shouldGenerateChildElements(genericType, ExpressionSupport.SUPPORTED)) {
                    objectFieldBuilder.supportsChildDeclaration(true);
                    genericType.accept(DslElementResolver.this.getArrayItemTypeVisitor(objectFieldBuilder, fieldName, ownerNamespace, false));
                }
            }

            public void visitDictionary(DictionaryType dictionaryType) {
                objectFieldBuilder.withAttributeName(fieldName).withElementName(NameUtils.hyphenize((String)NameUtils.pluralize((String)fieldName))).withNamespace(ownerNamespace);
                MetadataType keyType = dictionaryType.getKeyType();
                objectFieldBuilder.supportsChildDeclaration(DslElementResolver.this.shouldGenerateChildElements(keyType, ExpressionSupport.SUPPORTED));
                dictionaryType.getValueType().accept(DslElementResolver.this.getDictionaryValueTypeVisitor(objectFieldBuilder, fieldName, ownerNamespace));
            }
        };
    }

    private void declareFieldsAsChilds(DslElementDeclarationBuilder objectBuilder, Collection<ObjectFieldType> fields, String namespace) {
        fields.forEach(field -> {
            DslElementDeclarationBuilder fieldBuilder = DslElementDeclarationBuilder.create();
            String childName = field.getKey().getName().getLocalPart();
            field.getValue().accept(this.getObjectFieldVisitor(fieldBuilder, childName, namespace));
            objectBuilder.withChild(childName, fieldBuilder.build());
        });
    }

    private boolean shouldGenerateChildElements(MetadataType metadataType, ExpressionSupport expressionSupport) {
        boolean isExpressionRequired = ExpressionSupport.REQUIRED == expressionSupport;
        boolean isPojo = metadataType instanceof ObjectType;
        Optional classInformation = MetadataTypeUtils.getSingleAnnotation((MetadataType)metadataType, ClassInformationAnnotation.class);
        boolean isInstantiable = !isPojo || classInformation.map(ClassInformationAnnotation::isInstantiable).orElse(false) != false;
        boolean isExtensible = MetadataTypeUtils.getSingleAnnotation((MetadataType)metadataType, ExtensibleTypeAnnotation.class).isPresent();
        return !isExpressionRequired && (this.subTypesMapping.containsBaseType(metadataType) || isExtensible || isInstantiable && (!isPojo || !((ObjectType)metadataType).getFields().isEmpty()));
    }

    private boolean typeRequiresWrapperElement(MetadataType metadataType) {
        boolean isPojo = metadataType instanceof ObjectType;
        boolean isExtensible = MetadataTypeUtils.getSingleAnnotation((MetadataType)metadataType, ExtensibleTypeAnnotation.class).isPresent();
        boolean hasSubtypes = this.subTypesMapping.containsBaseType(metadataType);
        return isPojo && (isExtensible || hasSubtypes);
    }

    private Map<MetadataType, XmlModelProperty> loadImportedTypes(ExtensionModel extension) {
        HashMap<MetadataType, XmlModelProperty> xmlByType = new HashMap<MetadataType, XmlModelProperty>();
        extension.getModelProperty(ImportedTypesModelProperty.class).map(ImportedTypesModelProperty::getImportedTypes).ifPresent(imports -> imports.forEach((type, ownerExtension) -> {
            Class ownerClass = JavaTypeUtils.getType((MetadataType)ownerExtension);
            xmlByType.put((MetadataType)type, XmlModelUtils.createXmlModelProperty(ownerClass.getAnnotation(Xml.class), ownerClass.getAnnotation(Extension.class).name(), ""));
        }));
        return xmlByType;
    }

    private SubTypesMappingContainer loadSubTypes(ExtensionModel extension) {
        return new SubTypesMappingContainer(extension.getModelProperty(SubTypesModelProperty.class).map(SubTypesModelProperty::getSubTypesMapping).orElse(Collections.emptyMap()));
    }

    private XmlModelProperty loadXmlProperties(ExtensionModel extension) {
        return (XmlModelProperty)extension.getModelProperty(XmlModelProperty.class).orElseThrow(() -> new IllegalArgumentException(String.format("The extension [%s] does not have the [%s], required for its Xml Dsl Resolution", extension.getName(), XmlModelProperty.class.getSimpleName())));
    }

    private String getNamespace(MetadataType type) {
        return this.getNamespace(type, this.extensionXml.getNamespace());
    }

    private String getNamespace(MetadataType type, String defaultNamespace) {
        XmlModelProperty xml = this.importedTypes.get(type);
        return xml != null ? xml.getNamespace() : defaultNamespace;
    }
}

