/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.extension.xml.dsl.internal;

import java.util.HashMap;
import java.util.Map;
import org.mule.metadata.api.model.MetadataType;
import org.mule.runtime.extension.xml.dsl.api.DslElementDeclaration;

public final class DslElementDeclarationBuilder {
    private String attributeName = "";
    private String elementName = "";
    private String elementNameSpace = "";
    private boolean isWrapped = false;
    private boolean supportsChildDeclaration = false;
    private Map<MetadataType, DslElementDeclaration> genericChilds = new HashMap<MetadataType, DslElementDeclaration>();
    private Map<String, DslElementDeclaration> namedChilds = new HashMap<String, DslElementDeclaration>();

    private DslElementDeclarationBuilder() {
    }

    public static DslElementDeclarationBuilder create() {
        return new DslElementDeclarationBuilder();
    }

    public DslElementDeclarationBuilder withAttributeName(String attributeName) {
        this.attributeName = attributeName;
        return this;
    }

    public DslElementDeclarationBuilder withElementName(String elementName) {
        this.elementName = elementName;
        return this;
    }

    public DslElementDeclarationBuilder withNamespace(String namespace) {
        this.elementNameSpace = namespace;
        return this;
    }

    public DslElementDeclarationBuilder asWrappedElement(boolean isWrapped) {
        this.isWrapped = isWrapped;
        return this;
    }

    public DslElementDeclarationBuilder supportsChildDeclaration(boolean supportsChild) {
        this.supportsChildDeclaration = supportsChild;
        return this;
    }

    public DslElementDeclarationBuilder withGeneric(MetadataType type, DslElementDeclaration child) {
        if (child == null) {
            throw new IllegalArgumentException("Invalid child declaration, child element should not be null");
        }
        this.genericChilds.put(type, child);
        return this;
    }

    public DslElementDeclarationBuilder withChild(String name, DslElementDeclaration child) {
        if (child == null) {
            throw new IllegalArgumentException("Invalid child declaration, child element should not be null");
        }
        this.namedChilds.put(name, child);
        return this;
    }

    public DslElementDeclaration build() {
        return new DslElementDeclaration(this.attributeName, this.elementName, this.elementNameSpace, this.isWrapped, this.supportsChildDeclaration, this.genericChilds, this.namedChilds);
    }
}

