/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.extension.xml.dsl.test;

import java.util.Arrays;
import java.util.Collections;
import java.util.Optional;
import java.util.stream.Stream;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.junit.Assert;
import org.junit.Before;
import org.junit.runner.RunWith;
import org.mockito.Matchers;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.runners.MockitoJUnitRunner;
import org.mule.metadata.api.ClassTypeLoader;
import org.mule.metadata.api.builder.BaseTypeBuilder;
import org.mule.metadata.api.model.MetadataFormat;
import org.mule.runtime.extension.api.introspection.EnrichableModel;
import org.mule.runtime.extension.api.introspection.ExtensionModel;
import org.mule.runtime.extension.api.introspection.config.ConfigurationModel;
import org.mule.runtime.extension.api.introspection.connection.ConnectionProviderModel;
import org.mule.runtime.extension.api.introspection.declaration.type.ExtensionsTypeLoaderFactory;
import org.mule.runtime.extension.api.introspection.operation.OperationModel;
import org.mule.runtime.extension.api.introspection.parameter.ExpressionSupport;
import org.mule.runtime.extension.api.introspection.parameter.ParameterModel;
import org.mule.runtime.extension.api.introspection.property.ConfigTypeModelProperty;
import org.mule.runtime.extension.api.introspection.property.ConnectivityModelProperty;
import org.mule.runtime.extension.api.introspection.property.ImportedTypesModelProperty;
import org.mule.runtime.extension.api.introspection.property.PagedOperationModelProperty;
import org.mule.runtime.extension.api.introspection.property.SubTypesModelProperty;
import org.mule.runtime.extension.api.introspection.source.SourceModel;
import org.mule.runtime.extension.xml.dsl.api.DslElementSyntax;
import org.mule.runtime.extension.xml.dsl.api.property.XmlModelProperty;
import org.mule.runtime.extension.xml.dsl.api.resolver.DslResolvingContext;
import org.mule.runtime.extension.xml.dsl.api.resolver.DslSyntaxResolver;
import org.mule.runtime.extension.xml.dsl.test.model.SubType;
import org.mule.runtime.extension.xml.dsl.test.model.SuperType;

@RunWith(value=MockitoJUnitRunner.class)
public abstract class BaseXmlDeclarationTestCase {
    static final String NAMESPACE = "mockns";
    static final String NAMESPACE_URI = "http://www.mulesoft.org/schema/mule/mockns";
    static final String SCHEMA_LOCATION = "http://www.mulesoft.org/schema/mule/mockns/current/mule-mockns.xsd";
    static final String PARAMETER_NAME = "myCamelCaseName";
    static final String SINGULARIZABLE_PARAMETER_NAME = "singularizableNames";
    static final String EXTENSION_NAME = "extension";
    static final String OPERATION_NAME = "mockOperation";
    static final String SOURCE_NAME = "source";
    static final String CONFIGURATION_NAME = "configuration";
    static final String CONNECTION_PROVIDER_NAME = "connection";
    static final BaseTypeBuilder<?> TYPE_BUILDER = BaseTypeBuilder.create((MetadataFormat)MetadataFormat.JAVA);
    @Mock
    protected ExtensionModel extension;
    @Mock
    protected ConfigurationModel configuration;
    @Mock
    protected OperationModel operation;
    @Mock
    protected ConnectionProviderModel connectionProvider;
    @Mock
    protected ParameterModel parameterModel;
    @Mock
    protected SourceModel source;
    @Mock
    protected DslResolvingContext dslContext;
    protected ClassTypeLoader TYPE_LOADER = ExtensionsTypeLoaderFactory.getDefault().createTypeLoader();
    SubTypesModelProperty subTypesModelProperty = new SubTypesModelProperty(Collections.singletonMap(this.TYPE_LOADER.load(SuperType.class), Collections.singletonList(this.TYPE_LOADER.load(SubType.class))));

    @Before
    public void before() {
        Mockito.when((Object)this.extension.getName()).thenReturn((Object)EXTENSION_NAME);
        Mockito.when((Object)this.extension.getConfigurationModels()).thenReturn(Arrays.asList(this.configuration));
        Mockito.when((Object)this.extension.getConfigurationModels()).thenReturn(Arrays.asList(this.configuration));
        Mockito.when((Object)this.extension.getOperationModels()).thenReturn(Arrays.asList(this.operation));
        Mockito.when((Object)this.extension.getSourceModels()).thenReturn(Arrays.asList(this.source));
        Mockito.when((Object)this.extension.getConnectionProviders()).thenReturn(Arrays.asList(this.connectionProvider));
        Mockito.when((Object)this.extension.getModelProperty(SubTypesModelProperty.class)).thenReturn(Optional.of(this.subTypesModelProperty));
        Mockito.when((Object)this.extension.getModelProperty(ImportedTypesModelProperty.class)).thenReturn(Optional.empty());
        Mockito.when((Object)this.extension.getModelProperty(XmlModelProperty.class)).thenReturn(Optional.of(new XmlModelProperty("", NAMESPACE, NAMESPACE_URI, "", SCHEMA_LOCATION)));
        Mockito.when((Object)this.configuration.getOperationModels()).thenReturn(Arrays.asList(this.operation));
        Mockito.when((Object)this.configuration.getSourceModels()).thenReturn(Arrays.asList(this.source));
        Mockito.when((Object)this.configuration.getConnectionProviders()).thenReturn(Arrays.asList(this.connectionProvider));
        Mockito.when((Object)this.parameterModel.getName()).thenReturn((Object)PARAMETER_NAME);
        Mockito.when((Object)this.parameterModel.getExpressionSupport()).thenReturn((Object)ExpressionSupport.SUPPORTED);
        Mockito.when((Object)this.parameterModel.getModelProperty((Class)Matchers.any())).thenReturn(Optional.empty());
        Mockito.when((Object)this.source.getName()).thenReturn((Object)SOURCE_NAME);
        Mockito.when((Object)this.operation.getName()).thenReturn((Object)OPERATION_NAME);
        Mockito.when((Object)this.configuration.getName()).thenReturn((Object)CONFIGURATION_NAME);
        Mockito.when((Object)this.connectionProvider.getName()).thenReturn((Object)CONNECTION_PROVIDER_NAME);
        this.noConfigOn(new EnrichableModel[]{this.connectionProvider, this.operation, this.source, this.configuration});
        this.noConnectionOn(new EnrichableModel[]{this.connectionProvider, this.operation, this.source, this.configuration});
        Mockito.when((Object)this.dslContext.getExtension((String)Matchers.any())).thenReturn(Optional.empty());
        Stream.of(this.configuration, this.operation, this.connectionProvider, this.source).forEach(model -> Mockito.when((Object)model.getParameterModels()).thenReturn(Arrays.asList(this.parameterModel)));
    }

    private void noConfigOn(EnrichableModel ... models) {
        for (EnrichableModel model : models) {
            Mockito.when((Object)model.getModelProperty(ConfigTypeModelProperty.class)).thenReturn(Optional.empty());
        }
    }

    private void noConnectionOn(EnrichableModel ... models) {
        for (EnrichableModel model : models) {
            Mockito.when((Object)model.getModelProperty(ConnectivityModelProperty.class)).thenReturn(Optional.empty());
            Mockito.when((Object)model.getModelProperty(PagedOperationModelProperty.class)).thenReturn(Optional.empty());
        }
    }

    void assertChildElementDeclarationIs(boolean expected, DslElementSyntax result) {
        Assert.assertThat((String)"Expected attribute only declaration", (Object)result.supportsChildDeclaration(), (Matcher)CoreMatchers.is((Object)expected));
    }

    void assertTopLevelDeclarationSupportIs(boolean expected, DslElementSyntax result) {
        Assert.assertThat((String)"Wrong TopLevel declaration support", (Object)result.supportsTopLevelDeclaration(), (Matcher)CoreMatchers.is((Object)expected));
    }

    void assertIsWrappedElement(boolean expected, DslElementSyntax result) {
        Assert.assertThat((String)"Expected no wrapping but element is wrapped", (Object)result.isWrapped(), (Matcher)CoreMatchers.is((Object)expected));
    }

    void assertAttributeName(String expected, DslElementSyntax result) {
        Assert.assertThat((Object)result.getAttributeName(), (Matcher)CoreMatchers.equalTo((Object)expected));
    }

    void assertElementName(String expected, DslElementSyntax result) {
        Assert.assertThat((Object)result.getElementName(), (Matcher)CoreMatchers.equalTo((Object)expected));
    }

    void assertElementNamespace(String expected, DslElementSyntax result) {
        Assert.assertThat((Object)result.getNamespace(), (Matcher)CoreMatchers.equalTo((Object)expected));
    }

    void assertTopElementDeclarationIs(boolean expected, DslElementSyntax result) {
        Assert.assertThat((String)"Expected the element to support Top Level definitions", (Object)result.supportsTopLevelDeclaration(), (Matcher)CoreMatchers.is((Object)expected));
    }

    DslSyntaxResolver getSyntaxResolver() {
        return new DslSyntaxResolver(this.extension, this.dslContext);
    }
}

