/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.extension.xml.dsl.test;

import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import javax.xml.namespace.QName;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.collection.IsCollectionWithSize;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.Mockito;
import org.mockito.runners.MockitoJUnitRunner;
import org.mule.metadata.api.annotation.TypeAnnotation;
import org.mule.metadata.api.model.ArrayType;
import org.mule.metadata.api.model.MetadataType;
import org.mule.metadata.api.model.impl.DefaultStringType;
import org.mule.metadata.utils.MetadataTypeUtils;
import org.mule.runtime.extension.api.annotation.Extension;
import org.mule.runtime.extension.api.annotation.dsl.xml.Xml;
import org.mule.runtime.extension.api.introspection.ExtensionModel;
import org.mule.runtime.extension.api.introspection.declaration.type.annotation.XmlHintsAnnotation;
import org.mule.runtime.extension.api.introspection.parameter.ParameterModel;
import org.mule.runtime.extension.api.introspection.property.ImportedTypesModelProperty;
import org.mule.runtime.extension.api.introspection.property.SubTypesModelProperty;
import org.mule.runtime.extension.api.util.NameUtils;
import org.mule.runtime.extension.xml.dsl.api.DslElementSyntax;
import org.mule.runtime.extension.xml.dsl.api.property.XmlHintsModelProperty;
import org.mule.runtime.extension.xml.dsl.api.property.XmlModelProperty;
import org.mule.runtime.extension.xml.dsl.test.BaseXmlDeclarationTestCase;
import org.mule.runtime.extension.xml.dsl.test.model.AbstractType;
import org.mule.runtime.extension.xml.dsl.test.model.ChildOfAbstractType;
import org.mule.runtime.extension.xml.dsl.test.model.ComplexFieldsType;
import org.mule.runtime.extension.xml.dsl.test.model.EmptyType;
import org.mule.runtime.extension.xml.dsl.test.model.ExtensibleType;
import org.mule.runtime.extension.xml.dsl.test.model.GlobalType;
import org.mule.runtime.extension.xml.dsl.test.model.InterfaceDeclaration;
import org.mule.runtime.extension.xml.dsl.test.model.InterfaceDeclarationWithMapping;
import org.mule.runtime.extension.xml.dsl.test.model.InterfaceImplementation;
import org.mule.runtime.extension.xml.dsl.test.model.NonDefaultConstructor;
import org.mule.runtime.extension.xml.dsl.test.model.SimpleFieldsType;
import org.mule.runtime.extension.xml.dsl.test.model.SubType;

@RunWith(value=MockitoJUnitRunner.class)
public class ParameterXmlDeclarationTestCase
extends BaseXmlDeclarationTestCase {
    private static final String IMPORT_NAMESPACE = "importns";
    private static final String IMPORT_NAMESPACE_URI = "http://www.mulesoft.org/schema/mule/importns";
    private static final String IMPORT_SCHEMA_LOCATION = "http://www.mulesoft.org/schema/mule/importns/current/mule-importns.xsd";
    private static final String IMPORT_WITH_XML_SCHEMA_LOCATION = "http://www.mulesoft.org/schema/mule/importns/current/mule-import-extension-with-xml.xsd";
    private static final String IMPORT_EXTENSION_NAME = "importExtension";
    private static final String IMPORT_EXTENSION_NAME_WITH_XML = "importExtensionWithXml";

    @Test
    public void testSimpleTypeParameter() {
        Mockito.when((Object)this.parameterModel.getType()).thenReturn((Object)this.TYPE_LOADER.load(String.class));
        DslElementSyntax result = this.getSyntaxResolver().resolve(this.parameterModel);
        this.assertAttributeName("myCamelCaseName", result);
        this.assertElementName(NameUtils.hyphenize((String)"myCamelCaseName"), result);
        this.assertElementNamespace("mockns", result);
        this.assertChildElementDeclarationIs(false, result);
        this.assertIsWrappedElement(false, result);
    }

    @Test
    public void testSimplePojoParameter() {
        Mockito.when((Object)this.parameterModel.getType()).thenReturn((Object)this.TYPE_LOADER.load(SimpleFieldsType.class));
        DslElementSyntax result = this.getSyntaxResolver().resolve(this.parameterModel);
        String fieldName = "sampleString";
        DslElementSyntax childDsl = this.getChildFieldDsl(fieldName, result);
        this.assertAttributeName(fieldName, childDsl);
        this.assertChildElementDeclarationIs(true, result);
        this.assertIsWrappedElement(false, result);
    }

    @Test
    public void testComplexPojoParameter() {
        Mockito.when((Object)this.parameterModel.getType()).thenReturn((Object)this.TYPE_LOADER.load(ComplexFieldsType.class));
        DslElementSyntax result = this.getSyntaxResolver().resolve(this.parameterModel);
        this.assertAttributeName("myCamelCaseName", result);
        this.assertElementName(NameUtils.hyphenize((String)"myCamelCaseName"), result);
        this.assertElementNamespace("mockns", result);
        this.assertChildElementDeclarationIs(true, result);
        this.assertIsWrappedElement(false, result);
        this.assertComplexTypeDslFields(result);
    }

    @Test
    public void xmlStyleAtParameterLevel() {
        XmlHintsModelProperty styleModelProperty = new XmlHintsModelProperty(false, false, false);
        Mockito.when((Object)this.parameterModel.getType()).thenReturn((Object)this.TYPE_LOADER.load(String.class));
        Mockito.when((Object)this.parameterModel.getModelProperty(XmlHintsModelProperty.class)).thenReturn(Optional.of(styleModelProperty));
        DslElementSyntax result = this.getSyntaxResolver().resolve(this.parameterModel);
        this.assertChildElementDeclarationIs(false, result);
    }

    @Test
    public void xmlStyleAtTypeLevel() {
        XmlHintsModelProperty styleModelProperty = new XmlHintsModelProperty(false, false, false);
        Mockito.when((Object)this.parameterModel.getType()).thenReturn((Object)TYPE_BUILDER.stringType().with((TypeAnnotation)new XmlHintsAnnotation(false, false, false)).build());
        Mockito.when((Object)this.parameterModel.getModelProperty(XmlHintsModelProperty.class)).thenReturn(Optional.of(styleModelProperty));
        DslElementSyntax result = this.getSyntaxResolver().resolve(this.parameterModel);
        this.assertChildElementDeclarationIs(false, result);
    }

    @Test
    public void testEmptyTypeParameter() {
        Mockito.when((Object)this.parameterModel.getType()).thenReturn((Object)this.TYPE_LOADER.load(EmptyType.class));
        DslElementSyntax result = this.getSyntaxResolver().resolve(this.parameterModel);
        this.assertChildElementDeclarationIs(false, result);
        this.assertIsWrappedElement(false, result);
    }

    @Test
    public void topLevelType() {
        Mockito.when((Object)this.parameterModel.getType()).thenReturn((Object)this.TYPE_LOADER.load(GlobalType.class));
        DslElementSyntax result = this.getSyntaxResolver().resolve(this.parameterModel);
        this.assertChildElementDeclarationIs(true, result);
        this.assertIsWrappedElement(false, result);
        this.assertTopElementDeclarationIs(true, result);
    }

    @Test
    public void testExtensibleTypeParameter() {
        Mockito.when((Object)this.parameterModel.getType()).thenReturn((Object)this.TYPE_LOADER.load(ExtensibleType.class));
        DslElementSyntax result = this.getSyntaxResolver().resolve(this.parameterModel);
        this.assertChildElementDeclarationIs(true, result);
        this.assertIsWrappedElement(true, result);
    }

    @Test
    public void testInterfaceTypeParameter() {
        Mockito.when((Object)this.parameterModel.getType()).thenReturn((Object)this.TYPE_LOADER.load(InterfaceDeclaration.class));
        DslElementSyntax result = this.getSyntaxResolver().resolve(this.parameterModel);
        this.assertChildElementDeclarationIs(false, result);
        this.assertIsWrappedElement(false, result);
    }

    @Test
    public void testAbstractClassParameter() {
        Mockito.when((Object)this.parameterModel.getType()).thenReturn((Object)this.TYPE_LOADER.load(AbstractType.class));
        DslElementSyntax result = this.getSyntaxResolver().resolve(this.parameterModel);
        this.assertChildElementDeclarationIs(false, result);
        this.assertIsWrappedElement(false, result);
    }

    @Test
    public void testNonDefaultConstructorParameter() {
        Mockito.when((Object)this.parameterModel.getType()).thenReturn((Object)this.TYPE_LOADER.load(NonDefaultConstructor.class));
        DslElementSyntax result = this.getSyntaxResolver().resolve(this.parameterModel);
        this.assertChildElementDeclarationIs(false, result);
        this.assertIsWrappedElement(false, result);
    }

    @Test
    public void testInterfaceWithMappingParameter() {
        HashMap<MetadataType, List<MetadataType>> mapping = new HashMap<MetadataType, List<MetadataType>>();
        mapping.put(this.TYPE_LOADER.load(InterfaceDeclarationWithMapping.class), Collections.singletonList(this.TYPE_LOADER.load(InterfaceImplementation.class)));
        Mockito.when((Object)this.extension.getModelProperty(SubTypesModelProperty.class)).thenReturn(Optional.of(new SubTypesModelProperty(mapping)));
        Mockito.when((Object)this.parameterModel.getType()).thenReturn((Object)this.TYPE_LOADER.load(InterfaceDeclarationWithMapping.class));
        DslElementSyntax result = this.getSyntaxResolver().resolve(this.parameterModel);
        this.assertChildElementDeclarationIs(true, result);
        this.assertIsWrappedElement(true, result);
    }

    @Test
    public void testAbstractWithMappingParameter() {
        HashMap<MetadataType, List<MetadataType>> mapping = new HashMap<MetadataType, List<MetadataType>>();
        mapping.put(this.TYPE_LOADER.load(AbstractType.class), Collections.singletonList(this.TYPE_LOADER.load(ChildOfAbstractType.class)));
        Mockito.when((Object)this.extension.getModelProperty(SubTypesModelProperty.class)).thenReturn(Optional.of(new SubTypesModelProperty(mapping)));
        Mockito.when((Object)this.parameterModel.getType()).thenReturn((Object)this.TYPE_LOADER.load(AbstractType.class));
        DslElementSyntax result = this.getSyntaxResolver().resolve(this.parameterModel);
        this.assertChildElementDeclarationIs(true, result);
        this.assertIsWrappedElement(true, result);
    }

    @Test
    public void testImportedFinalTypeWithXmlParameter() {
        HashMap<MetadataType, String> imports = new HashMap<MetadataType, String>();
        imports.put(this.TYPE_LOADER.load(SimpleFieldsType.class), IMPORT_EXTENSION_NAME_WITH_XML);
        ExtensionModel importOriginMock = (ExtensionModel)Mockito.mock(ExtensionModel.class);
        Mockito.when((Object)importOriginMock.getModelProperty(XmlModelProperty.class)).thenReturn(Optional.of(new XmlModelProperty("", IMPORT_NAMESPACE, IMPORT_NAMESPACE_URI, "", IMPORT_SCHEMA_LOCATION)));
        Mockito.when((Object)this.dslContext.getExtension(IMPORT_EXTENSION_NAME_WITH_XML)).thenReturn(Optional.of(importOriginMock));
        Mockito.when((Object)this.extension.getModelProperty(ImportedTypesModelProperty.class)).thenReturn(Optional.of(new ImportedTypesModelProperty(imports)));
        Mockito.when((Object)this.parameterModel.getType()).thenReturn((Object)this.TYPE_LOADER.load(SimpleFieldsType.class));
        DslElementSyntax result = this.getSyntaxResolver().resolve(this.parameterModel);
        this.assertElementNamespace("mockns", result);
        this.assertChildElementDeclarationIs(true, result);
        this.assertIsWrappedElement(false, result);
    }

    @Test
    public void testImportedFinalTypeWithoutXmlParameter() {
        HashMap<MetadataType, String> imports = new HashMap<MetadataType, String>();
        imports.put(this.TYPE_LOADER.load(SimpleFieldsType.class), IMPORT_EXTENSION_NAME);
        ExtensionModel importOriginMock = (ExtensionModel)Mockito.mock(ExtensionModel.class);
        Mockito.when((Object)importOriginMock.getModelProperty(XmlModelProperty.class)).thenReturn(Optional.of(new XmlModelProperty("", IMPORT_NAMESPACE, IMPORT_NAMESPACE_URI, "", IMPORT_SCHEMA_LOCATION)));
        Mockito.when((Object)this.dslContext.getExtension(IMPORT_EXTENSION_NAME)).thenReturn(Optional.of(importOriginMock));
        Mockito.when((Object)this.extension.getModelProperty(ImportedTypesModelProperty.class)).thenReturn(Optional.of(new ImportedTypesModelProperty(imports)));
        Mockito.when((Object)this.parameterModel.getType()).thenReturn((Object)this.TYPE_LOADER.load(SimpleFieldsType.class));
        DslElementSyntax result = this.getSyntaxResolver().resolve(this.parameterModel);
        this.assertElementNamespace("mockns", result);
        this.assertChildElementDeclarationIs(true, result);
        this.assertIsWrappedElement(false, result);
    }

    @Test
    public void testExtensibleImportParameter() {
        HashMap<MetadataType, String> imports = new HashMap<MetadataType, String>();
        imports.put(this.TYPE_LOADER.load(ExtensibleType.class), IMPORT_EXTENSION_NAME_WITH_XML);
        ExtensionModel importOriginMock = (ExtensionModel)Mockito.mock(ExtensionModel.class);
        Mockito.when((Object)importOriginMock.getModelProperty(XmlModelProperty.class)).thenReturn(Optional.of(new XmlModelProperty("", NameUtils.defaultNamespace((String)IMPORT_EXTENSION_NAME_WITH_XML), IMPORT_NAMESPACE_URI, "", IMPORT_WITH_XML_SCHEMA_LOCATION)));
        Mockito.when((Object)this.dslContext.getExtension(IMPORT_EXTENSION_NAME_WITH_XML)).thenReturn(Optional.of(importOriginMock));
        Mockito.when((Object)this.extension.getModelProperty(ImportedTypesModelProperty.class)).thenReturn(Optional.of(new ImportedTypesModelProperty(imports)));
        Mockito.when((Object)this.parameterModel.getType()).thenReturn((Object)this.TYPE_LOADER.load(ExtensibleType.class));
        DslElementSyntax result = this.getSyntaxResolver().resolve(this.parameterModel);
        this.assertElementNamespace(NameUtils.defaultNamespace((String)IMPORT_EXTENSION_NAME_WITH_XML), result);
        this.assertChildElementDeclarationIs(true, result);
        this.assertIsWrappedElement(true, result);
    }

    @Test
    public void testExtensibleImportedTypeWithoutXmlParameter() {
        HashMap<MetadataType, String> imports = new HashMap<MetadataType, String>();
        imports.put(this.TYPE_LOADER.load(ExtensibleType.class), IMPORT_EXTENSION_NAME);
        ExtensionModel importOriginMock = (ExtensionModel)Mockito.mock(ExtensionModel.class);
        Mockito.when((Object)importOriginMock.getModelProperty(XmlModelProperty.class)).thenReturn(Optional.of(new XmlModelProperty("", IMPORT_NAMESPACE, IMPORT_NAMESPACE_URI, "", IMPORT_SCHEMA_LOCATION)));
        Mockito.when((Object)this.dslContext.getExtension(IMPORT_EXTENSION_NAME)).thenReturn(Optional.of(importOriginMock));
        Mockito.when((Object)this.extension.getModelProperty(ImportedTypesModelProperty.class)).thenReturn(Optional.of(new ImportedTypesModelProperty(imports)));
        Mockito.when((Object)this.parameterModel.getType()).thenReturn((Object)this.TYPE_LOADER.load(ExtensibleType.class));
        DslElementSyntax result = this.getSyntaxResolver().resolve(this.parameterModel);
        this.assertElementNamespace(IMPORT_NAMESPACE, result);
        this.assertChildElementDeclarationIs(true, result);
        this.assertIsWrappedElement(true, result);
    }

    @Test
    public void testMapOfSimpleTypeParameter() {
        DefaultStringType keyType = TYPE_BUILDER.stringType().id(String.class.getName()).build();
        DefaultStringType valueType = TYPE_BUILDER.stringType().id(String.class.getName()).build();
        Mockito.when((Object)this.parameterModel.getType()).thenReturn((Object)TYPE_BUILDER.dictionaryType().id(Map.class.getName()).ofKey((MetadataType)keyType).ofValue((MetadataType)valueType).build());
        this.assertCollectionDslElementSyntax((MetadataType)valueType, this.parameterModel, "myCamelCaseName", NameUtils.hyphenize((String)NameUtils.pluralize((String)"myCamelCaseName")), NameUtils.hyphenize((String)NameUtils.singularize((String)"myCamelCaseName")));
    }

    @Test
    public void testMapOfComplexTypeParameter() {
        DefaultStringType keyType = TYPE_BUILDER.stringType().id(String.class.getName()).build();
        MetadataType valueType = this.TYPE_LOADER.load(SimpleFieldsType.class);
        Mockito.when((Object)this.parameterModel.getType()).thenReturn((Object)TYPE_BUILDER.dictionaryType().id(Map.class.getName()).ofKey((MetadataType)keyType).ofValue(valueType).build());
        DslElementSyntax result = this.getSyntaxResolver().resolve(this.parameterModel);
        this.assertAttributeName("myCamelCaseName", result);
        this.assertElementName(NameUtils.hyphenize((String)NameUtils.pluralize((String)"myCamelCaseName")), result);
        this.assertElementNamespace("mockns", result);
        this.assertChildElementDeclarationIs(true, result);
        this.assertIsWrappedElement(false, result);
        DslElementSyntax innerElement = this.getGenericTypeDsl(valueType, result);
        this.assertElementName(NameUtils.hyphenize((String)NameUtils.singularize((String)"myCamelCaseName")), innerElement);
        this.assertChildElementDeclarationIs(true, innerElement);
        this.assertIsWrappedElement(false, innerElement);
    }

    @Test
    public void testMapOfWrappedTypeParameter() {
        DefaultStringType keyType = TYPE_BUILDER.stringType().id(String.class.getName()).build();
        MetadataType valueType = this.TYPE_LOADER.load(ExtensibleType.class);
        Mockito.when((Object)this.parameterModel.getType()).thenReturn((Object)TYPE_BUILDER.dictionaryType().id(Map.class.getName()).ofKey((MetadataType)keyType).ofValue(valueType).build());
        DslElementSyntax result = this.getSyntaxResolver().resolve(this.parameterModel);
        this.assertAttributeName("myCamelCaseName", result);
        this.assertElementName(NameUtils.hyphenize((String)NameUtils.pluralize((String)"myCamelCaseName")), result);
        this.assertElementNamespace("mockns", result);
        this.assertChildElementDeclarationIs(true, result);
        this.assertIsWrappedElement(false, result);
        DslElementSyntax innerElement = this.getGenericTypeDsl(valueType, result);
        this.assertElementName(NameUtils.hyphenize((String)NameUtils.singularize((String)"myCamelCaseName")), innerElement);
        this.assertChildElementDeclarationIs(true, innerElement);
        this.assertIsWrappedElement(false, innerElement);
    }

    @Test
    public void testMapOfNonInstantiableValueTypeParameter() {
        DefaultStringType keyType = TYPE_BUILDER.stringType().id(String.class.getName()).build();
        MetadataType valueType = this.TYPE_LOADER.load(InterfaceDeclaration.class);
        Mockito.when((Object)this.parameterModel.getType()).thenReturn((Object)TYPE_BUILDER.dictionaryType().id(Map.class.getName()).ofKey((MetadataType)keyType).ofValue(valueType).build());
        this.assertCollectionDslElementSyntax(valueType, this.parameterModel, "myCamelCaseName", NameUtils.hyphenize((String)NameUtils.pluralize((String)"myCamelCaseName")), NameUtils.hyphenize((String)"myCamelCaseName"));
    }

    @Test
    public void testMapOfNonInstantiableValueTypeWithMappedSubtypesParameter() {
        DefaultStringType keyType = TYPE_BUILDER.stringType().id(String.class.getName()).build();
        MetadataType valueType = this.TYPE_LOADER.load(InterfaceDeclarationWithMapping.class);
        HashMap<MetadataType, List<MetadataType>> mapping = new HashMap<MetadataType, List<MetadataType>>();
        mapping.put(this.TYPE_LOADER.load(InterfaceDeclarationWithMapping.class), Collections.singletonList(this.TYPE_LOADER.load(InterfaceImplementation.class)));
        Mockito.when((Object)this.extension.getModelProperty(SubTypesModelProperty.class)).thenReturn(Optional.of(new SubTypesModelProperty(mapping)));
        Mockito.when((Object)this.parameterModel.getType()).thenReturn((Object)TYPE_BUILDER.dictionaryType().id(Map.class.getName()).ofKey((MetadataType)keyType).ofValue(valueType).build());
        DslElementSyntax result = this.getSyntaxResolver().resolve(this.parameterModel);
        this.assertAttributeName("myCamelCaseName", result);
        this.assertElementName(NameUtils.hyphenize((String)NameUtils.pluralize((String)"myCamelCaseName")), result);
        this.assertElementNamespace("mockns", result);
        this.assertChildElementDeclarationIs(true, result);
        this.assertIsWrappedElement(false, result);
        DslElementSyntax innerElement = this.getGenericTypeDsl(valueType, result);
        this.assertElementName(NameUtils.hyphenize((String)NameUtils.singularize((String)"myCamelCaseName")), innerElement);
        this.assertChildElementDeclarationIs(true, innerElement);
        this.assertIsWrappedElement(false, innerElement);
    }

    @Test
    public void testCollectionOfSimpleTypeParameter() {
        DefaultStringType itemType = TYPE_BUILDER.stringType().id(String.class.getName()).build();
        Mockito.when((Object)this.parameterModel.getName()).thenReturn((Object)"singularizableNames");
        Mockito.when((Object)this.parameterModel.getType()).thenReturn((Object)TYPE_BUILDER.arrayType().id(List.class.getName()).of((MetadataType)itemType).build());
        this.assertCollectionDslElementSyntax((MetadataType)itemType, this.parameterModel, "singularizableNames", NameUtils.hyphenize((String)"singularizableNames"), NameUtils.hyphenize((String)NameUtils.singularize((String)"singularizableNames")));
    }

    @Test
    public void testCollectionWithSameSingularizedChildName() {
        DefaultStringType itemType = TYPE_BUILDER.stringType().id(String.class.getName()).build();
        Mockito.when((Object)this.parameterModel.getName()).thenReturn((Object)"myCamelCaseName");
        Mockito.when((Object)this.parameterModel.getType()).thenReturn((Object)TYPE_BUILDER.arrayType().id(List.class.getName()).of((MetadataType)itemType).build());
        this.assertCollectionDslElementSyntax((MetadataType)itemType, this.parameterModel, "myCamelCaseName", NameUtils.hyphenize((String)"myCamelCaseName"), NameUtils.itemize((String)"myCamelCaseName"));
    }

    private void assertCollectionDslElementSyntax(MetadataType itemType, ParameterModel parameterModel, String parameterName, String elementName, String childElementName) {
        DslElementSyntax result = this.getSyntaxResolver().resolve(parameterModel);
        this.assertAttributeName(parameterName, result);
        this.assertElementName(elementName, result);
        this.assertElementNamespace("mockns", result);
        this.assertChildElementDeclarationIs(true, result);
        this.assertIsWrappedElement(false, result);
        DslElementSyntax innerElement = this.getGenericTypeDsl(itemType, result);
        this.assertElementName(childElementName, innerElement);
        this.assertChildElementDeclarationIs(false, innerElement);
        this.assertIsWrappedElement(false, innerElement);
    }

    @Test
    public void testCollectionOfComplexTypeParameter() {
        MetadataType itemType = this.TYPE_LOADER.load(SimpleFieldsType.class);
        Mockito.when((Object)this.parameterModel.getType()).thenReturn((Object)TYPE_BUILDER.arrayType().id(List.class.getName()).of(itemType).build());
        DslElementSyntax result = this.getSyntaxResolver().resolve(this.parameterModel);
        this.assertAttributeName("myCamelCaseName", result);
        this.assertElementName(NameUtils.hyphenize((String)"myCamelCaseName"), result);
        this.assertElementNamespace("mockns", result);
        this.assertChildElementDeclarationIs(true, result);
        this.assertIsWrappedElement(false, result);
        DslElementSyntax innerElement = this.getGenericTypeDsl(itemType, result);
        this.assertElementName(NameUtils.getTopLevelTypeName((MetadataType)itemType), innerElement);
        this.assertElementNamespace("mockns", innerElement);
        this.assertChildElementDeclarationIs(true, innerElement);
        this.assertIsWrappedElement(false, innerElement);
    }

    @Test
    public void testCollectionOfWrappedTypeParameter() {
        MetadataType itemType = this.TYPE_LOADER.load(ExtensibleType.class);
        Mockito.when((Object)this.parameterModel.getType()).thenReturn((Object)TYPE_BUILDER.arrayType().id(List.class.getName()).of(itemType).build());
        DslElementSyntax result = this.getSyntaxResolver().resolve(this.parameterModel);
        this.assertAttributeName("myCamelCaseName", result);
        this.assertElementName(NameUtils.hyphenize((String)"myCamelCaseName"), result);
        this.assertElementNamespace("mockns", result);
        this.assertChildElementDeclarationIs(true, result);
        this.assertIsWrappedElement(false, result);
        DslElementSyntax listItemDsl = this.getGenericTypeDsl(itemType, result);
        this.assertElementName(NameUtils.getTopLevelTypeName((MetadataType)itemType), listItemDsl);
        this.assertElementNamespace("mockns", listItemDsl);
        this.assertChildElementDeclarationIs(true, listItemDsl);
        this.assertTopElementDeclarationIs(false, listItemDsl);
        this.assertIsWrappedElement(true, listItemDsl);
    }

    @Test
    public void testCollectionOfNonInstantiableTypeParameter() {
        MetadataType itemType = this.TYPE_LOADER.load(InterfaceDeclaration.class);
        Mockito.when((Object)this.parameterModel.getType()).thenReturn((Object)TYPE_BUILDER.arrayType().id(List.class.getName()).of(itemType).build());
        DslElementSyntax result = this.getSyntaxResolver().resolve(this.parameterModel);
        this.assertAttributeName("myCamelCaseName", result);
        this.assertElementName(NameUtils.hyphenize((String)"myCamelCaseName"), result);
        this.assertElementNamespace("mockns", result);
        this.assertChildElementDeclarationIs(false, result);
        this.assertIsWrappedElement(false, result);
        Assert.assertThat((Object)result.getGeneric(itemType).isPresent(), (Matcher)CoreMatchers.is((Object)false));
    }

    @Test
    public void testMapOfListOfComplexTypeParameter() {
        MetadataType itemType = this.TYPE_LOADER.load(ExtensibleType.class);
        ArrayType valueType = TYPE_BUILDER.arrayType().id(List.class.getName()).of(itemType).build();
        DefaultStringType keyType = TYPE_BUILDER.stringType().id(String.class.getName()).build();
        Mockito.when((Object)this.parameterModel.getType()).thenReturn((Object)TYPE_BUILDER.dictionaryType().id(Map.class.getName()).ofKey((MetadataType)keyType).ofValue((MetadataType)valueType).build());
        DslElementSyntax mapDsl = this.getSyntaxResolver().resolve(this.parameterModel);
        this.assertAttributeName("myCamelCaseName", mapDsl);
        this.assertElementName(NameUtils.hyphenize((String)NameUtils.pluralize((String)"myCamelCaseName")), mapDsl);
        this.assertElementNamespace("mockns", mapDsl);
        this.assertChildElementDeclarationIs(true, mapDsl);
        this.assertIsWrappedElement(false, mapDsl);
        DslElementSyntax listDsl = this.getGenericTypeDsl((MetadataType)valueType, mapDsl);
        this.assertElementName(NameUtils.hyphenize((String)NameUtils.singularize((String)"myCamelCaseName")), listDsl);
        this.assertChildElementDeclarationIs(true, listDsl);
        this.assertIsWrappedElement(false, listDsl);
        DslElementSyntax listItemDsl = this.getGenericTypeDsl(itemType, listDsl);
        this.assertElementName(NameUtils.getTopLevelTypeName((MetadataType)itemType), listItemDsl);
        this.assertElementNamespace("mockns", listItemDsl);
        this.assertChildElementDeclarationIs(true, listItemDsl);
        this.assertTopElementDeclarationIs(false, listItemDsl);
        this.assertIsWrappedElement(true, listItemDsl);
    }

    @Test
    public void testMapOfListOfSimpleTypeParameter() {
        MetadataType itemType = this.TYPE_LOADER.load(String.class);
        ArrayType valueType = TYPE_BUILDER.arrayType().id(List.class.getName()).of(itemType).build();
        DefaultStringType keyType = TYPE_BUILDER.stringType().id(String.class.getName()).build();
        Mockito.when((Object)this.parameterModel.getType()).thenReturn((Object)TYPE_BUILDER.dictionaryType().id(Map.class.getName()).ofKey((MetadataType)keyType).ofValue((MetadataType)valueType).build());
        DslElementSyntax mapDsl = this.getSyntaxResolver().resolve(this.parameterModel);
        this.assertAttributeName("myCamelCaseName", mapDsl);
        this.assertElementName(NameUtils.hyphenize((String)NameUtils.pluralize((String)"myCamelCaseName")), mapDsl);
        this.assertElementNamespace("mockns", mapDsl);
        this.assertChildElementDeclarationIs(true, mapDsl);
        this.assertIsWrappedElement(false, mapDsl);
        DslElementSyntax listDsl = this.getGenericTypeDsl((MetadataType)valueType, mapDsl);
        this.assertElementName(NameUtils.hyphenize((String)NameUtils.singularize((String)"myCamelCaseName")), listDsl);
        this.assertChildElementDeclarationIs(true, listDsl);
        this.assertIsWrappedElement(false, listDsl);
        DslElementSyntax itemDsl = this.getGenericTypeDsl(itemType, listDsl);
        this.assertElementName(NameUtils.itemize((String)"myCamelCaseName"), itemDsl);
        this.assertChildElementDeclarationIs(false, itemDsl);
        this.assertIsWrappedElement(false, itemDsl);
    }

    @Test
    public void testComplexRecursiveType() {
        MetadataType type = this.TYPE_LOADER.load(ComplexFieldsType.class);
        DslElementSyntax topDsl = this.getSyntaxResolver().resolve(type);
        this.assertElementName(NameUtils.getTopLevelTypeName((MetadataType)type), topDsl);
        this.assertElementNamespace("mockns", topDsl);
        this.assertChildElementDeclarationIs(true, topDsl);
        this.assertIsWrappedElement(false, topDsl);
        this.assertComplexTypeDslFields(topDsl);
    }

    @Test
    public void testSubstitutionGroupsFromType() {
        MetadataType subType = this.TYPE_LOADER.load(SubType.class);
        DslElementSyntax subTypeElement = this.getSyntaxResolver().resolve(subType);
        List substitutionGroups = subTypeElement.getSubstitutionGroups();
        Assert.assertThat((Object)substitutionGroups, (Matcher)IsCollectionWithSize.hasSize((int)2));
        Assert.assertThat((Object)substitutionGroups, (Matcher)CoreMatchers.hasItem((Object)new QName("http://www.mulesoft.org/schema/mule/mockns", "abstract-sub-type", "mockns")));
        Assert.assertThat((Object)substitutionGroups, (Matcher)CoreMatchers.hasItem((Object)new QName("http://www.mulesoft.org/schema/mule/mockns", "abstract-super-type", "mockns")));
    }

    private void assertComplexTypeDslFields(DslElementSyntax topDsl) {
        String extensibleTypeListName = "extensibleTypeList";
        DslElementSyntax listDsl = this.getChildFieldDsl(extensibleTypeListName, topDsl);
        this.assertAttributeName(extensibleTypeListName, listDsl);
        this.assertElementName(NameUtils.hyphenize((String)extensibleTypeListName), listDsl);
        this.assertElementNamespace("mockns", listDsl);
        this.assertChildElementDeclarationIs(true, listDsl);
        this.assertIsWrappedElement(false, listDsl);
        MetadataType listItemType = this.TYPE_LOADER.load(ExtensibleType.class);
        DslElementSyntax listItemDsl = this.getGenericTypeDsl(listItemType, listDsl);
        this.assertElementName(NameUtils.getTopLevelTypeName((MetadataType)listItemType), listItemDsl);
        this.assertElementNamespace("mockns", listItemDsl);
        this.assertChildElementDeclarationIs(true, listItemDsl);
        this.assertTopElementDeclarationIs(false, listItemDsl);
        this.assertIsWrappedElement(true, listItemDsl);
        String recursiveChildName = "recursiveChild";
        DslElementSyntax recursiveChildDsl = this.getChildFieldDsl(recursiveChildName, topDsl);
        this.assertAttributeName(recursiveChildName, recursiveChildDsl);
        this.assertElementName(NameUtils.hyphenize((String)recursiveChildName), recursiveChildDsl);
        this.assertElementNamespace("mockns", recursiveChildDsl);
        this.assertChildElementDeclarationIs(true, recursiveChildDsl);
        this.assertTopLevelDeclarationSupportIs(false, recursiveChildDsl);
        this.assertIsWrappedElement(false, recursiveChildDsl);
        String simplePojoName = "simplePojo";
        DslElementSyntax simplePojoDsl = this.getChildFieldDsl(simplePojoName, topDsl);
        this.assertAttributeName(simplePojoName, simplePojoDsl);
        this.assertElementName(NameUtils.hyphenize((String)simplePojoName), simplePojoDsl);
        this.assertElementNamespace("mockns", simplePojoDsl);
        this.assertChildElementDeclarationIs(true, simplePojoDsl);
        this.assertIsWrappedElement(false, simplePojoDsl);
        this.assertTopElementDeclarationIs(false, simplePojoDsl);
        String notGlobalName = "notGlobalType";
        DslElementSyntax notGlobalDsl = this.getChildFieldDsl(notGlobalName, topDsl);
        this.assertAttributeName(notGlobalName, notGlobalDsl);
        this.assertElementName(NameUtils.hyphenize((String)notGlobalName), notGlobalDsl);
        this.assertElementNamespace("mockns", notGlobalDsl);
        this.assertChildElementDeclarationIs(true, notGlobalDsl);
        this.assertIsWrappedElement(false, notGlobalDsl);
        String groupedField = "groupedField";
        DslElementSyntax groupedFieldDsl = this.getChildFieldDsl(groupedField, topDsl);
        this.assertAttributeName(groupedField, groupedFieldDsl);
        this.assertElementName("", groupedFieldDsl);
        this.assertElementNamespace("", groupedFieldDsl);
        this.assertChildElementDeclarationIs(false, groupedFieldDsl);
        this.assertIsWrappedElement(false, groupedFieldDsl);
        String anotherGroupedField = "anotherGroupedField";
        DslElementSyntax anotherGroupedFieldDsl = this.getChildFieldDsl(anotherGroupedField, topDsl);
        this.assertAttributeName(anotherGroupedField, anotherGroupedFieldDsl);
        this.assertElementName("", anotherGroupedFieldDsl);
        this.assertElementNamespace("", anotherGroupedFieldDsl);
        this.assertChildElementDeclarationIs(false, anotherGroupedFieldDsl);
        this.assertIsWrappedElement(false, anotherGroupedFieldDsl);
        String parameterGroupType = "parameterGroupType";
        Assert.assertThat((Object)topDsl.getChild(parameterGroupType).isPresent(), (Matcher)CoreMatchers.is((Object)false));
    }

    private DslElementSyntax getGenericTypeDsl(MetadataType itemType, DslElementSyntax result) {
        Optional genericDsl = result.getGeneric(itemType);
        Assert.assertThat((String)("No generic element found for type [" + MetadataTypeUtils.getTypeId((MetadataType)itemType).orElse("") + "] for element [" + result.getElementName() + "]"), (Object)genericDsl.isPresent(), (Matcher)CoreMatchers.is((Object)true));
        return (DslElementSyntax)genericDsl.get();
    }

    private DslElementSyntax getChildFieldDsl(String name, DslElementSyntax parent) {
        Optional childDsl = parent.getChild(name);
        Assert.assertThat((String)("No child element found with name [" + name + "] for element [" + parent.getElementName() + "]"), (Object)childDsl.isPresent(), (Matcher)CoreMatchers.is((Object)true));
        return (DslElementSyntax)childDsl.get();
    }

    @Extension(name="importExtension")
    private static final class ExtensionForImportsNoXml {
        private ExtensionForImportsNoXml() {
        }
    }

    @Xml(namespace="importns", namespaceLocation="http://www.mulesoft.org/schema/mule/importns")
    @Extension(name="importExtensionWithXml")
    private static final class ExtensionForImportsDeclaresXml {
        private ExtensionForImportsDeclaresXml() {
        }
    }
}

