/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.extension.xml.dsl.internal;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.xml.namespace.QName;
import org.mule.metadata.api.model.MetadataType;
import org.mule.runtime.extension.xml.dsl.api.DslElementSyntax;

public final class DslElementSyntaxBuilder {
    private String attributeName = "";
    private String elementName = "";
    private String elementNameSpace = "";
    private String nameSpaceUri;
    private boolean isWrapped = false;
    private boolean supportsChildDeclaration = false;
    private boolean supportsTopLevelDeclaration = false;
    private boolean requiresConfig = false;
    private Map<MetadataType, DslElementSyntax> genericChilds = new HashMap<MetadataType, DslElementSyntax>();
    private Map<String, DslElementSyntax> namedChilds = new HashMap<String, DslElementSyntax>();
    private List<QName> substitutionGroups = new ArrayList<QName>();
    private String abstractElementName;

    private DslElementSyntaxBuilder() {
    }

    public static DslElementSyntaxBuilder create() {
        return new DslElementSyntaxBuilder();
    }

    public DslElementSyntaxBuilder withAttributeName(String attributeName) {
        this.attributeName = attributeName;
        return this;
    }

    public DslElementSyntaxBuilder withElementName(String elementName) {
        this.elementName = elementName;
        return this;
    }

    public DslElementSyntaxBuilder withNamespace(String nameSpace, String nameSpaceUri) {
        this.elementNameSpace = nameSpace;
        this.nameSpaceUri = nameSpaceUri;
        return this;
    }

    public DslElementSyntaxBuilder asWrappedElement(boolean isWrapped) {
        this.isWrapped = isWrapped;
        return this;
    }

    public DslElementSyntaxBuilder supportsChildDeclaration(boolean supportsChild) {
        this.supportsChildDeclaration = supportsChild;
        return this;
    }

    public DslElementSyntaxBuilder supportsTopLevelDeclaration(boolean supportsTop) {
        this.supportsTopLevelDeclaration = supportsTop;
        return this;
    }

    public DslElementSyntaxBuilder requiresConfig(boolean requiresConfig) {
        this.requiresConfig = requiresConfig;
        return this;
    }

    public DslElementSyntaxBuilder withGeneric(MetadataType type, DslElementSyntax child) {
        if (child == null) {
            throw new IllegalArgumentException("Invalid child declaration, child element should not be null");
        }
        this.genericChilds.put(type, child);
        return this;
    }

    public DslElementSyntaxBuilder ofSubstitutionGroup(QName substitutionGroupName) {
        if (substitutionGroupName != null) {
            this.substitutionGroups.add(substitutionGroupName);
        }
        return this;
    }

    public DslElementSyntaxBuilder withChild(String name, DslElementSyntax child) {
        if (child == null) {
            throw new IllegalArgumentException("Invalid child declaration, child element should not be null");
        }
        this.namedChilds.put(name, child);
        return this;
    }

    public DslElementSyntaxBuilder withAbstractElementName(String name) {
        this.abstractElementName = name;
        return this;
    }

    public DslElementSyntax build() {
        return new DslElementSyntax(this.attributeName, this.elementName, this.abstractElementName, this.elementNameSpace, this.nameSpaceUri, this.isWrapped, this.supportsChildDeclaration, this.supportsTopLevelDeclaration, this.requiresConfig, this.genericChilds, this.namedChilds, this.substitutionGroups);
    }
}

