/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.extension.xml.dsl.api.resolver;

import java.util.ArrayDeque;
import java.util.Collection;
import java.util.Collections;
import java.util.Deque;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import org.mule.metadata.api.model.ArrayType;
import org.mule.metadata.api.model.DictionaryType;
import org.mule.metadata.api.model.MetadataType;
import org.mule.metadata.api.model.ObjectFieldType;
import org.mule.metadata.api.model.ObjectType;
import org.mule.metadata.api.model.StringType;
import org.mule.metadata.api.model.UnionType;
import org.mule.metadata.api.visitor.MetadataTypeVisitor;
import org.mule.runtime.api.meta.ExpressionSupport;
import org.mule.runtime.api.meta.NamedObject;
import org.mule.runtime.api.meta.model.ElementDslModel;
import org.mule.runtime.api.meta.model.ExtensionModel;
import org.mule.runtime.api.meta.model.XmlDslModel;
import org.mule.runtime.api.meta.model.parameter.ParameterModel;
import org.mule.runtime.extension.api.declaration.type.TypeUtils;
import org.mule.runtime.extension.api.util.ExtensionModelUtils;
import org.mule.runtime.extension.api.util.NameUtils;
import org.mule.runtime.extension.api.util.SubTypesMappingContainer;
import org.mule.runtime.extension.xml.dsl.api.DslElementSyntax;
import org.mule.runtime.extension.xml.dsl.api.resolver.DefaultImportTypesStrategy;
import org.mule.runtime.extension.xml.dsl.api.resolver.DslResolvingContext;
import org.mule.runtime.extension.xml.dsl.api.resolver.DslSyntaxUtils;
import org.mule.runtime.extension.xml.dsl.api.resolver.ImportTypesStrategy;
import org.mule.runtime.extension.xml.dsl.internal.DslElementSyntaxBuilder;

public class DslSyntaxResolver {
    private static final String VALUE_ATTRIBUTE = "value";
    private static final String KEY_ATTRIBUTE = "key";
    private final SubTypesMappingContainer subTypesMap;
    private final XmlDslModel languageModel;
    private final Map<String, DslElementSyntax> resolvedTypes = new HashMap<String, DslElementSyntax>();
    private final Map<MetadataType, XmlDslModel> importedTypes;
    private final Deque<String> typeResolvingStack = new ArrayDeque<String>();

    public DslSyntaxResolver(ExtensionModel model, DslResolvingContext context) {
        this(model, new DefaultImportTypesStrategy(model, context));
    }

    public DslSyntaxResolver(ExtensionModel model, ImportTypesStrategy importTypesStrategy) {
        this.languageModel = model.getXmlDslModel();
        this.subTypesMap = DslSyntaxUtils.loadSubTypes(model);
        this.importedTypes = importTypesStrategy.getImportedTypes();
    }

    public DslElementSyntax resolve(NamedObject component) {
        return DslElementSyntaxBuilder.create().withElementName(NameUtils.hyphenize((String)component.getName())).withNamespace(this.languageModel.getNamespace(), this.languageModel.getNamespaceUri()).requiresConfig(ExtensionModelUtils.requiresConfig((NamedObject)component)).build();
    }

    public DslElementSyntax resolve(final ParameterModel parameter) {
        final ExpressionSupport expressionSupport = parameter.getExpressionSupport();
        final DslElementSyntaxBuilder builder = DslElementSyntaxBuilder.create();
        final ElementDslModel dslModel = parameter.getDslModel();
        final boolean isContent = ExtensionModelUtils.isContent((ParameterModel)parameter);
        parameter.getType().accept(new MetadataTypeVisitor(){

            public void visitUnion(UnionType unionType) {
                unionType.getTypes().forEach(type -> type.accept((MetadataTypeVisitor)this));
            }

            protected void defaultVisit(MetadataType metadataType) {
                builder.withNamespace(DslSyntaxResolver.this.languageModel.getNamespace(), DslSyntaxResolver.this.languageModel.getNamespaceUri()).withElementName(NameUtils.hyphenize((String)parameter.getName()));
                DslSyntaxResolver.this.addAttributeName(builder, parameter, isContent, dslModel);
            }

            public void visitString(StringType stringType) {
                this.defaultVisit((MetadataType)stringType);
                boolean isTextString = DslSyntaxUtils.isText(parameter);
                builder.supportsChildDeclaration(isTextString).supportsAttributeDeclaration(!isTextString);
            }

            public void visitArrayType(ArrayType arrayType) {
                this.defaultVisit((MetadataType)arrayType);
                MetadataType genericType = arrayType.getType();
                boolean supportsInline = DslSyntaxUtils.supportsInlineDeclaration((MetadataType)arrayType, expressionSupport, dslModel, isContent);
                boolean requiresWrapper = DslSyntaxResolver.this.typeRequiresWrapperElement(genericType);
                if (supportsInline || requiresWrapper) {
                    builder.supportsChildDeclaration(true);
                    if (!isContent) {
                        genericType.accept(DslSyntaxResolver.this.getArrayItemTypeVisitor(builder, parameter.getName(), DslSyntaxResolver.this.languageModel.getNamespace(), DslSyntaxResolver.this.languageModel.getNamespaceUri(), false));
                    }
                }
            }

            public void visitObject(ObjectType objectType) {
                DslSyntaxResolver.this.addAttributeName(builder, parameter, isContent, dslModel);
                builder.withNamespace(DslSyntaxResolver.this.languageModel.getNamespace(), DslSyntaxResolver.this.languageModel.getNamespaceUri()).withElementName(NameUtils.hyphenize((String)parameter.getName())).supportsTopLevelDeclaration(DslSyntaxUtils.supportTopLevelElement((MetadataType)objectType, dslModel));
                boolean shouldGenerateChild = DslSyntaxUtils.supportsInlineDeclaration((MetadataType)objectType, expressionSupport, dslModel, isContent);
                boolean requiresWrapper = DslSyntaxResolver.this.typeRequiresWrapperElement((MetadataType)objectType);
                if (shouldGenerateChild || requiresWrapper) {
                    builder.supportsChildDeclaration(true);
                    if (requiresWrapper) {
                        builder.asWrappedElement(true);
                    } else if (!isContent) {
                        DslSyntaxResolver.this.declareFieldsAsChilds(builder, objectType.getFields(), DslSyntaxResolver.this.languageModel.getNamespace(), DslSyntaxResolver.this.languageModel.getNamespaceUri());
                    }
                }
            }

            public void visitDictionary(DictionaryType dictionaryType) {
                DslSyntaxResolver.this.addAttributeName(builder, parameter, isContent, dslModel);
                String parameterName = isContent ? parameter.getName() : NameUtils.pluralize((String)parameter.getName());
                builder.withNamespace(DslSyntaxResolver.this.languageModel.getNamespace(), DslSyntaxResolver.this.languageModel.getNamespaceUri()).withElementName(NameUtils.hyphenize((String)parameterName)).supportsChildDeclaration(DslSyntaxUtils.supportsInlineDeclaration((MetadataType)dictionaryType, expressionSupport, isContent));
                if (!isContent) {
                    builder.withGeneric(dictionaryType.getKeyType(), DslElementSyntaxBuilder.create().withAttributeName(DslSyntaxResolver.KEY_ATTRIBUTE).build());
                    dictionaryType.getValueType().accept(DslSyntaxResolver.this.getDictionaryValueTypeVisitor(builder, parameter.getName(), DslSyntaxResolver.this.languageModel.getNamespace(), DslSyntaxResolver.this.languageModel.getNamespaceUri(), dslModel));
                }
            }
        });
        return builder.build();
    }

    private void addAttributeName(DslElementSyntaxBuilder builder, ParameterModel parameter, boolean isContent, ElementDslModel dslModel) {
        if (this.supportsAttributeDeclaration(parameter, isContent, dslModel)) {
            builder.withAttributeName(parameter.getName());
        } else {
            builder.supportsAttributeDeclaration(false);
        }
    }

    private boolean supportsAttributeDeclaration(ParameterModel parameter, boolean isContent, ElementDslModel dslModel) {
        return !isContent && (dslModel.allowsReferences() || !ExpressionSupport.NOT_SUPPORTED.equals((Object)parameter.getExpressionSupport()));
    }

    public Optional<DslElementSyntax> resolve(MetadataType type) {
        return type instanceof ObjectType ? this.resolvePojoDsl(type) : Optional.empty();
    }

    private Optional<DslElementSyntax> resolvePojoDsl(MetadataType type) {
        String namespaceUri;
        boolean requiresWrapper = this.typeRequiresWrapperElement(type);
        boolean supportsInlineDeclaration = DslSyntaxUtils.supportsInlineDeclaration(type, ExpressionSupport.NOT_SUPPORTED);
        boolean supportTopLevelElement = DslSyntaxUtils.supportTopLevelElement(type, ElementDslModel.getDefaultInstance());
        if (!supportsInlineDeclaration && !supportTopLevelElement && !requiresWrapper && this.subTypesMap.getSuperTypes(type).isEmpty()) {
            return Optional.empty();
        }
        String namespace = this.getNamespace(type);
        String key = DslSyntaxUtils.getTypeKey(type, namespace, namespaceUri = this.getNamespaceUri(type));
        if (this.resolvedTypes.containsKey(key)) {
            return Optional.of(this.resolvedTypes.get(key));
        }
        DslElementSyntaxBuilder builder = DslElementSyntaxBuilder.create();
        builder.withNamespace(namespace, namespaceUri).withElementName(NameUtils.getTopLevelTypeName((MetadataType)type)).supportsTopLevelDeclaration(supportTopLevelElement).supportsChildDeclaration(supportsInlineDeclaration).asWrappedElement(requiresWrapper);
        String typeId = DslSyntaxUtils.getId(type);
        if (!this.typeResolvingStack.contains(typeId)) {
            if (supportTopLevelElement || supportsInlineDeclaration) {
                this.typeResolvingStack.push(typeId);
                this.declareFieldsAsChilds(builder, ((ObjectType)type).getFields(), namespace, namespaceUri);
                this.typeResolvingStack.pop();
            }
            DslElementSyntax dsl = builder.build();
            this.resolvedTypes.put(key, dsl);
            return Optional.of(dsl);
        }
        return Optional.of(builder.build());
    }

    private MetadataTypeVisitor getArrayItemTypeVisitor(final DslElementSyntaxBuilder listBuilder, final String parameterName, final String namespace, final String namespaceUri, final boolean asItem) {
        return new MetadataTypeVisitor(){

            public void visitObject(ObjectType objectType) {
                if (DslSyntaxResolver.this.typeRequiresWrapperElement((MetadataType)objectType)) {
                    listBuilder.withGeneric((MetadataType)objectType, DslElementSyntaxBuilder.create().withNamespace(DslSyntaxResolver.this.getNamespace((MetadataType)objectType), DslSyntaxResolver.this.getNamespaceUri((MetadataType)objectType)).withElementName(NameUtils.getTopLevelTypeName((MetadataType)objectType)).supportsChildDeclaration(DslSyntaxUtils.supportsInlineDeclaration((MetadataType)objectType, ExpressionSupport.NOT_SUPPORTED)).asWrappedElement(true).supportsTopLevelDeclaration(DslSyntaxUtils.supportTopLevelElement((MetadataType)objectType, ElementDslModel.getDefaultInstance())).build());
                } else if (DslSyntaxUtils.isValidBean(objectType)) {
                    listBuilder.withGeneric((MetadataType)objectType, DslSyntaxResolver.this.resolve((MetadataType)objectType).get());
                }
            }

            public void visitArrayType(ArrayType arrayType) {
                DslElementSyntaxBuilder genericBuilder = DslElementSyntaxBuilder.create().withNamespace(namespace, namespaceUri).withElementName(DslSyntaxResolver.this.resolveItemName(parameterName, asItem));
                MetadataType genericType = arrayType.getType();
                boolean supportsInline = DslSyntaxUtils.supportsInlineDeclaration(genericType, ExpressionSupport.SUPPORTED);
                boolean requiresWrapper = DslSyntaxResolver.this.typeRequiresWrapperElement(genericType);
                if (supportsInline || requiresWrapper) {
                    genericBuilder.supportsChildDeclaration(true);
                    genericType.accept(DslSyntaxResolver.this.getArrayItemTypeVisitor(genericBuilder, parameterName, namespace, namespaceUri, true));
                }
                listBuilder.withGeneric((MetadataType)arrayType, genericBuilder.build());
            }

            protected void defaultVisit(MetadataType metadataType) {
                listBuilder.withGeneric(metadataType, DslElementSyntaxBuilder.create().withNamespace(namespace, namespaceUri).withElementName(DslSyntaxResolver.this.resolveItemName(parameterName, asItem)).build());
            }
        };
    }

    private MetadataTypeVisitor getDictionaryValueTypeVisitor(final DslElementSyntaxBuilder mapBuilder, final String parameterName, final String namespace, final String namespaceUri, final ElementDslModel dslModel) {
        return new MetadataTypeVisitor(){

            public void visitObject(ObjectType objectType) {
                boolean supportsInlineDeclaration = DslSyntaxUtils.supportsInlineDeclaration((MetadataType)objectType, ExpressionSupport.SUPPORTED, dslModel, false);
                boolean requiresWrapperElement = DslSyntaxResolver.this.typeRequiresWrapperElement((MetadataType)objectType);
                if (supportsInlineDeclaration || requiresWrapperElement) {
                    DslElementSyntaxBuilder builder = this.createBaseValueDefinition();
                    if (!DslSyntaxResolver.this.typeResolvingStack.contains(DslSyntaxUtils.getId((MetadataType)objectType))) {
                        DslSyntaxResolver.this.typeResolvingStack.push(DslSyntaxUtils.getId((MetadataType)objectType));
                        DslSyntaxResolver.this.addBeanDeclarationSupport(objectType, objectType.getFields(), builder, namespace, namespaceUri, true);
                        DslSyntaxResolver.this.typeResolvingStack.pop();
                    } else {
                        DslSyntaxResolver.this.addBeanDeclarationSupport(objectType, Collections.emptyList(), builder, namespace, namespaceUri, false);
                    }
                    builder.supportsChildDeclaration(true);
                    builder.asWrappedElement(requiresWrapperElement);
                    mapBuilder.withGeneric((MetadataType)objectType, builder.build());
                } else {
                    this.defaultVisit((MetadataType)objectType);
                }
            }

            public void visitArrayType(ArrayType arrayType) {
                DslElementSyntaxBuilder listBuilder = this.createBaseValueDefinition();
                MetadataType genericType = arrayType.getType();
                boolean supportsInline = DslSyntaxUtils.supportsInlineDeclaration(genericType, ExpressionSupport.SUPPORTED, dslModel, false);
                boolean requiresWrapper = DslSyntaxResolver.this.typeRequiresWrapperElement(genericType);
                if (supportsInline || requiresWrapper) {
                    listBuilder.supportsChildDeclaration(true);
                    genericType.accept(DslSyntaxResolver.this.getArrayItemTypeVisitor(listBuilder, parameterName, namespace, namespaceUri, true));
                }
                mapBuilder.withGeneric((MetadataType)arrayType, listBuilder.build());
            }

            protected void defaultVisit(MetadataType metadataType) {
                mapBuilder.withGeneric(metadataType, this.createBaseValueDefinition().build());
            }

            private DslElementSyntaxBuilder createBaseValueDefinition() {
                return DslElementSyntaxBuilder.create().withAttributeName(DslSyntaxResolver.VALUE_ATTRIBUTE).withNamespace(namespace, namespaceUri).withElementName(NameUtils.hyphenize((String)NameUtils.singularize((String)parameterName)));
            }
        };
    }

    private void addBeanDeclarationSupport(ObjectType objectType, Collection<ObjectFieldType> childFields, DslElementSyntaxBuilder builder, String namespace, String namespaceUri, boolean introspectObjectFields) {
        boolean supportsChildDeclaration = DslSyntaxUtils.supportsInlineDeclaration((MetadataType)objectType, ExpressionSupport.SUPPORTED);
        boolean supportsTopDeclaration = DslSyntaxUtils.supportTopLevelElement((MetadataType)objectType);
        builder.supportsChildDeclaration(supportsChildDeclaration).supportsTopLevelDeclaration(supportsTopDeclaration).asWrappedElement(this.typeRequiresWrapperElement((MetadataType)objectType));
        if (introspectObjectFields && (supportsChildDeclaration || supportsTopDeclaration)) {
            this.declareFieldsAsChilds(builder, childFields, namespace, namespaceUri);
        }
    }

    private MetadataTypeVisitor getObjectFieldVisitor(final DslElementSyntaxBuilder objectFieldBuilder, final ObjectFieldType field, final String fieldName, final String ownerNamespace, final String ownerNamespaceUri) {
        return new MetadataTypeVisitor(){

            protected void defaultVisit(MetadataType metadataType) {
                objectFieldBuilder.withAttributeName(fieldName);
            }

            public void visitString(StringType stringType) {
                if (DslSyntaxUtils.isText((MetadataType)field)) {
                    objectFieldBuilder.supportsChildDeclaration(true);
                    objectFieldBuilder.withElementName(NameUtils.hyphenize((String)fieldName));
                } else {
                    this.defaultVisit((MetadataType)stringType);
                }
            }

            public void visitObject(ObjectType objectType) {
                objectFieldBuilder.withAttributeName(fieldName).withElementName(NameUtils.hyphenize((String)fieldName)).withNamespace(DslSyntaxResolver.this.getNamespace((MetadataType)objectType, ownerNamespace), DslSyntaxResolver.this.getNamespaceUri((MetadataType)objectType, ownerNamespaceUri));
                if (!DslSyntaxResolver.this.typeResolvingStack.contains(DslSyntaxUtils.getId((MetadataType)objectType))) {
                    DslSyntaxResolver.this.typeResolvingStack.push(DslSyntaxUtils.getId((MetadataType)objectType));
                    List fields = objectType.getFields().stream().filter(f -> !DslSyntaxResolver.this.typeResolvingStack.contains(DslSyntaxUtils.getId(f.getValue()))).collect(Collectors.toList());
                    DslSyntaxResolver.this.addBeanDeclarationSupport(objectType, fields, objectFieldBuilder, ownerNamespace, ownerNamespaceUri, true);
                    DslSyntaxResolver.this.typeResolvingStack.pop();
                } else {
                    DslSyntaxResolver.this.addBeanDeclarationSupport(objectType, Collections.emptyList(), objectFieldBuilder, ownerNamespace, ownerNamespaceUri, false);
                }
            }

            public void visitArrayType(ArrayType arrayType) {
                objectFieldBuilder.withAttributeName(fieldName).withElementName(NameUtils.hyphenize((String)fieldName)).withNamespace(ownerNamespace, ownerNamespaceUri);
                MetadataType genericType = arrayType.getType();
                if (DslSyntaxUtils.supportsInlineDeclaration(genericType, ExpressionSupport.SUPPORTED)) {
                    objectFieldBuilder.supportsChildDeclaration(true);
                    genericType.accept(DslSyntaxResolver.this.getArrayItemTypeVisitor(objectFieldBuilder, fieldName, ownerNamespace, ownerNamespaceUri, false));
                }
            }

            public void visitDictionary(DictionaryType dictionaryType) {
                objectFieldBuilder.withAttributeName(fieldName).withElementName(NameUtils.hyphenize((String)NameUtils.pluralize((String)fieldName))).withNamespace(ownerNamespace, ownerNamespaceUri);
                MetadataType keyType = dictionaryType.getKeyType();
                if (DslSyntaxUtils.supportsInlineDeclaration(keyType, ExpressionSupport.SUPPORTED)) {
                    objectFieldBuilder.supportsChildDeclaration(true);
                    objectFieldBuilder.withGeneric(dictionaryType.getKeyType(), DslElementSyntaxBuilder.create().withAttributeName(DslSyntaxResolver.KEY_ATTRIBUTE).build());
                    dictionaryType.getValueType().accept(DslSyntaxResolver.this.getDictionaryValueTypeVisitor(objectFieldBuilder, fieldName, ownerNamespace, ownerNamespaceUri, ElementDslModel.getDefaultInstance()));
                }
            }
        };
    }

    private void declareFieldsAsChilds(DslElementSyntaxBuilder objectBuilder, Collection<ObjectFieldType> fields, String namespace, String namespaceUri) {
        fields.forEach(field -> {
            DslElementSyntaxBuilder fieldBuilder = DslElementSyntaxBuilder.create();
            String childName = field.getKey().getName().getLocalPart();
            MetadataType fieldValue = field.getValue();
            if (DslSyntaxUtils.isFlattened(field, fieldValue)) {
                this.declareFieldsAsChilds(objectBuilder, ((ObjectType)fieldValue).getFields(), namespace, namespaceUri);
            } else {
                if (TypeUtils.isContent((MetadataType)field)) {
                    fieldBuilder.supportsChildDeclaration(true);
                    fieldBuilder.withElementName(NameUtils.hyphenize((String)childName));
                } else {
                    fieldValue.accept(this.getObjectFieldVisitor(fieldBuilder, (ObjectFieldType)field, childName, namespace, namespaceUri));
                }
                objectBuilder.withChild(childName, fieldBuilder.build());
            }
        });
    }

    private boolean typeRequiresWrapperElement(MetadataType metadataType) {
        boolean isPojo = metadataType instanceof ObjectType;
        boolean hasSubtypes = this.subTypesMap.containsBaseType(metadataType);
        return isPojo && (DslSyntaxUtils.isExtensible(metadataType) || hasSubtypes);
    }

    private String getNamespace(MetadataType type) {
        return this.getNamespace(type, this.languageModel.getNamespace());
    }

    private String getNamespace(MetadataType type, String defaultNamespace) {
        XmlDslModel originXml = this.importedTypes.get(type);
        return originXml != null ? originXml.getNamespace() : defaultNamespace;
    }

    private String getNamespaceUri(MetadataType type) {
        return this.getNamespaceUri(type, this.languageModel.getNamespaceUri());
    }

    private String getNamespaceUri(MetadataType type, String defaultUri) {
        XmlDslModel originXml = this.importedTypes.get(type);
        return originXml != null ? originXml.getNamespaceUri() : defaultUri;
    }

    private String resolveItemName(String parameterName, boolean forceItemize) {
        String singularizedName = NameUtils.singularize((String)parameterName);
        return forceItemize || parameterName.equals(singularizedName) ? NameUtils.itemize((String)singularizedName) : NameUtils.hyphenize((String)singularizedName);
    }
}

