/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.extension.xml.dsl.api.resolver;

import java.util.Collection;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicBoolean;
import org.mule.metadata.api.model.AnyType;
import org.mule.metadata.api.model.ArrayType;
import org.mule.metadata.api.model.DictionaryType;
import org.mule.metadata.api.model.MetadataType;
import org.mule.metadata.api.model.NumberType;
import org.mule.metadata.api.model.ObjectFieldType;
import org.mule.metadata.api.model.ObjectType;
import org.mule.metadata.api.model.StringType;
import org.mule.metadata.api.model.UnionType;
import org.mule.metadata.api.visitor.MetadataTypeVisitor;
import org.mule.metadata.internal.utils.MetadataTypeUtils;
import org.mule.metadata.java.api.annotation.ClassInformationAnnotation;
import org.mule.runtime.api.meta.ExpressionSupport;
import org.mule.runtime.api.meta.model.ElementDslModel;
import org.mule.runtime.api.meta.model.ExtensionModel;
import org.mule.runtime.api.meta.model.display.LayoutModel;
import org.mule.runtime.api.meta.model.parameter.ParameterModel;
import org.mule.runtime.extension.api.declaration.type.annotation.ExtensibleTypeAnnotation;
import org.mule.runtime.extension.api.declaration.type.annotation.FlattenedTypeAnnotation;
import org.mule.runtime.extension.api.declaration.type.annotation.LayoutTypeAnnotation;
import org.mule.runtime.extension.api.declaration.type.annotation.XmlHintsAnnotation;
import org.mule.runtime.extension.api.util.SubTypesMappingContainer;
import org.mule.runtime.extension.xml.dsl.api.XmlModelUtils;

class DslSyntaxUtils {
    DslSyntaxUtils() {
    }

    static boolean isValidBean(ObjectType objectType) {
        return DslSyntaxUtils.isInstantiable((MetadataType)objectType) && !objectType.getFields().isEmpty();
    }

    static boolean isFlattened(ObjectFieldType field, MetadataType fieldValue) {
        return fieldValue instanceof ObjectType && field.getAnnotation(FlattenedTypeAnnotation.class).isPresent();
    }

    static String getTypeKey(MetadataType type, String namespace, String namespaceUri) {
        return DslSyntaxUtils.getId(type) + namespace + namespaceUri;
    }

    static String getId(MetadataType type) {
        return MetadataTypeUtils.getTypeId((MetadataType)type).orElseGet(() -> type.getAnnotation(ClassInformationAnnotation.class).map(ClassInformationAnnotation::getName).orElse(""));
    }

    static boolean isText(ParameterModel parameter) {
        return parameter.getLayoutModel().map(LayoutModel::isText).orElse(false);
    }

    static boolean isText(MetadataType type) {
        return type.getAnnotation(LayoutTypeAnnotation.class).map(layoutTypeAnnotation -> layoutTypeAnnotation.isText()).orElse(false);
    }

    static boolean isInstantiable(MetadataType metadataType) {
        Optional classInformation = metadataType.getAnnotation(ClassInformationAnnotation.class);
        return classInformation.map(ClassInformationAnnotation::isInstantiable).orElse(false);
    }

    static boolean isExtensible(MetadataType metadataType) {
        return metadataType.getAnnotation(ExtensibleTypeAnnotation.class).isPresent();
    }

    static SubTypesMappingContainer loadSubTypes(ExtensionModel extension) {
        return new SubTypesMappingContainer((Collection)extension.getSubTypes());
    }

    static boolean supportTopLevelElement(MetadataType metadataType) {
        return DslSyntaxUtils.supportTopLevelElement(metadataType, metadataType.getAnnotation(XmlHintsAnnotation.class).map(XmlHintsAnnotation::allowsReferences).orElse(true));
    }

    static boolean supportTopLevelElement(MetadataType metadataType, ElementDslModel elementDslModel) {
        return DslSyntaxUtils.supportTopLevelElement(metadataType, elementDslModel.allowsReferences());
    }

    static boolean supportTopLevelElement(MetadataType metadataType, boolean allowsReferences) {
        if (!allowsReferences) {
            return false;
        }
        final AtomicBoolean supporstGlobalDeclaration = new AtomicBoolean(false);
        metadataType.accept(new MetadataTypeVisitor(){

            public void visitObject(ObjectType objectType) {
                supporstGlobalDeclaration.set(XmlModelUtils.supportsTopLevelDeclaration((MetadataType)objectType) && DslSyntaxUtils.isValidBean(objectType));
            }
        });
        return supporstGlobalDeclaration.get();
    }

    static boolean supportsInlineDeclaration(MetadataType metadataType, ExpressionSupport expressionSupport) {
        return DslSyntaxUtils.supportsInlineDeclaration(metadataType, expressionSupport, ElementDslModel.getDefaultInstance(), false);
    }

    static boolean supportsInlineDeclaration(MetadataType metadataType, ExpressionSupport expressionSupport, boolean isContent) {
        return DslSyntaxUtils.supportsInlineDeclaration(metadataType, expressionSupport, ElementDslModel.getDefaultInstance(), isContent);
    }

    static boolean supportsInlineDeclaration(MetadataType metadataType, ExpressionSupport expressionSupport, final ElementDslModel dslModel, boolean isContent) {
        final AtomicBoolean supportsChildDeclaration = new AtomicBoolean(false);
        if (isContent) {
            return true;
        }
        if (ExpressionSupport.REQUIRED == expressionSupport) {
            return false;
        }
        metadataType.accept(new MetadataTypeVisitor(){

            protected void defaultVisit(MetadataType metadataType) {
                supportsChildDeclaration.set(true);
            }

            public void visitAnyType(AnyType anyType) {
                supportsChildDeclaration.set(false);
            }

            public void visitArrayType(ArrayType arrayType) {
                final 2 currentVisitor = this;
                arrayType.getType().accept(new MetadataTypeVisitor(){

                    public void visitDictionary(DictionaryType dictionaryType) {
                        supportsChildDeclaration.set(false);
                    }

                    protected void defaultVisit(MetadataType metadataType) {
                        metadataType.accept(currentVisitor);
                    }
                });
            }

            public void visitObject(ObjectType objectType) {
                if (!dslModel.allowsInlineDefinition()) {
                    supportsChildDeclaration.set(false);
                } else {
                    supportsChildDeclaration.set(DslSyntaxUtils.isValidBean(objectType));
                }
            }

            public void visitUnion(UnionType unionType) {
                supportsChildDeclaration.set(false);
            }

            public void visitDictionary(DictionaryType dictionaryType) {
                dictionaryType.getKeyType().accept(new MetadataTypeVisitor(){

                    public void visitString(StringType stringType) {
                        supportsChildDeclaration.set(true);
                    }

                    public void visitNumber(NumberType numberType) {
                        supportsChildDeclaration.set(true);
                    }

                    protected void defaultVisit(MetadataType metadataType) {
                        supportsChildDeclaration.set(false);
                    }
                });
            }
        });
        return supportsChildDeclaration.get();
    }
}

