/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.extension.api.introspection;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import org.mule.runtime.extension.api.introspection.AbstractNamedImmutableModel;
import org.mule.runtime.extension.api.introspection.Described;
import org.mule.runtime.extension.api.introspection.EnrichableModel;
import org.mule.runtime.extension.api.introspection.ModelProperty;
import org.mule.runtime.extension.api.introspection.Named;
import org.mule.runtime.extension.api.introspection.connection.ConnectionProviderModel;
import org.mule.runtime.extension.api.introspection.connection.HasConnectionProviderModels;
import org.mule.runtime.extension.api.introspection.operation.HasOperationModels;
import org.mule.runtime.extension.api.introspection.operation.OperationModel;
import org.mule.runtime.extension.api.introspection.source.HasSourceModels;
import org.mule.runtime.extension.api.introspection.source.SourceModel;

public abstract class AbstractComplexModel
extends AbstractNamedImmutableModel
implements HasConnectionProviderModels,
HasSourceModels,
HasOperationModels {
    private final Map<String, OperationModel> operations;
    private final Map<String, ConnectionProviderModel> connectionProviders;
    private final Map<String, SourceModel> messageSources;

    public AbstractComplexModel(String name, String description, List<OperationModel> operationModels, List<ConnectionProviderModel> connectionProviders, List<SourceModel> sourceModels, Set<ModelProperty> modelProperties) {
        super(name, description, modelProperties);
        this.operations = this.toMap(operationModels);
        this.connectionProviders = this.toMap(connectionProviders);
        this.messageSources = this.toMap(sourceModels);
    }

    @Override
    public List<OperationModel> getOperationModels() {
        return this.toList(this.operations.values());
    }

    @Override
    public List<SourceModel> getSourceModels() {
        return this.toList(this.messageSources.values());
    }

    @Override
    public Optional<SourceModel> getSourceModel(String name) {
        return this.findModel(this.messageSources, name);
    }

    @Override
    public Optional<ConnectionProviderModel> getConnectionProviderModel(String name) {
        return this.findModel(this.connectionProviders, name);
    }

    @Override
    public Optional<OperationModel> getOperationModel(String name) {
        return this.findModel(this.operations, name);
    }

    @Override
    public List<ConnectionProviderModel> getConnectionProviders() {
        return this.toList(this.connectionProviders.values());
    }

    protected <T extends EnrichableModel> Optional<T> findModel(Map<String, T> map, String name) {
        return Optional.ofNullable(map.get(name));
    }

    protected <T extends Described> List<T> toList(Collection<T> collection) {
        if (collection == null || collection.isEmpty()) {
            return Collections.emptyList();
        }
        return Collections.unmodifiableList(new ArrayList<T>(collection));
    }

    protected <T extends Named> Map<String, T> toMap(List<T> objects) {
        if (objects == null || objects.isEmpty()) {
            return Collections.emptyMap();
        }
        LinkedHashMap<String, Named> map = new LinkedHashMap<String, Named>(objects.size());
        for (Named object : objects) {
            if (map.containsKey(object.getName())) {
                throw new IllegalArgumentException(String.format("Multiple entries with the same key[%s]", object.getName()));
            }
            map.put(object.getName(), object);
        }
        return Collections.unmodifiableMap(map);
    }
}

