/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.extension.api.introspection;

import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.mule.runtime.extension.api.introspection.Described;
import org.mule.runtime.extension.api.introspection.EnrichableModel;
import org.mule.runtime.extension.api.introspection.ModelProperty;

public abstract class AbstractImmutableModel
implements Described,
EnrichableModel {
    private final String description;
    private final Map<Class<? extends ModelProperty>, ModelProperty> modelProperties;

    protected AbstractImmutableModel(String description, Set<ModelProperty> modelProperties) {
        this.description = description != null ? description : "";
        this.modelProperties = this.toModelPropertiesMap(modelProperties);
    }

    protected static void checkArgument(boolean condition, String message) {
        if (!condition) {
            throw new IllegalArgumentException(message);
        }
    }

    @Override
    public final String getDescription() {
        return this.description;
    }

    @Override
    public <T extends ModelProperty> Optional<T> getModelProperty(Class<T> propertyType) {
        AbstractImmutableModel.checkArgument(propertyType != null, "Cannot get model properties of a null type");
        return Optional.ofNullable(this.modelProperties.get(propertyType));
    }

    @Override
    public Set<ModelProperty> getModelProperties() {
        return Collections.unmodifiableSet(new HashSet<ModelProperty>(this.modelProperties.values()));
    }

    public String toString() {
        return ToStringBuilder.reflectionToString((Object)this);
    }

    private Map<Class<? extends ModelProperty>, ModelProperty> toModelPropertiesMap(Collection<ModelProperty> properties) {
        if (properties == null || properties.isEmpty()) {
            return Collections.emptyMap();
        }
        return Collections.unmodifiableMap(properties.stream().collect(Collectors.toMap(p -> p.getClass(), p -> p)));
    }
}

