/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.extension.api.introspection;

import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import org.mule.api.MuleVersion;
import org.mule.runtime.extension.api.Category;
import org.mule.runtime.extension.api.exception.IllegalModelDefinitionException;
import org.mule.runtime.extension.api.introspection.AbstractComplexModel;
import org.mule.runtime.extension.api.introspection.ExtensionModel;
import org.mule.runtime.extension.api.introspection.ModelProperty;
import org.mule.runtime.extension.api.introspection.config.ConfigurationModel;
import org.mule.runtime.extension.api.introspection.connection.ConnectionProviderModel;
import org.mule.runtime.extension.api.introspection.operation.OperationModel;
import org.mule.runtime.extension.api.introspection.source.SourceModel;

public class ImmutableExtensionModel
extends AbstractComplexModel
implements ExtensionModel {
    private final String vendor;
    private final String version;
    private final MuleVersion minMuleVersion;
    private final Category category;
    private final Map<String, ConfigurationModel> configurations;

    public ImmutableExtensionModel(String name, String description, String version, String vendor, Category category, MuleVersion minMuleVersion, List<ConfigurationModel> configurationModels, List<OperationModel> operationModels, List<ConnectionProviderModel> connectionProviders, List<SourceModel> sourceModels, Set<ModelProperty> modelProperties) {
        super(name, description, operationModels, connectionProviders, sourceModels, modelProperties);
        this.configurations = this.toMap(configurationModels);
        this.checkModelArgument(version != null && version.length() > 0, "Version cannot be blank");
        this.checkModelArgument(minMuleVersion != null, "Extension Minimum Mule Version cannot be null");
        this.checkModelArgument(category != null, "Extension Category cannot be null");
        this.checkModelArgument(vendor != null, "Extension Vendor cannot be null");
        this.minMuleVersion = minMuleVersion;
        this.category = category;
        this.version = version;
        this.vendor = vendor;
    }

    @Override
    public List<ConfigurationModel> getConfigurationModels() {
        return this.toList(this.configurations.values());
    }

    @Override
    public Optional<ConfigurationModel> getConfigurationModel(String name) {
        return this.findModel(this.configurations, name);
    }

    @Override
    public String getVersion() {
        return this.version;
    }

    @Override
    public String getVendor() {
        return this.vendor;
    }

    @Override
    public Category getCategory() {
        return this.category;
    }

    @Override
    public MuleVersion getMinMuleVersion() {
        return this.minMuleVersion;
    }

    private void checkModelArgument(boolean condition, String errorMessage) {
        if (!condition) {
            throw new IllegalModelDefinitionException(errorMessage);
        }
    }
}

