/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.extension.api.introspection.config;

import java.beans.Transient;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.function.Supplier;
import org.mule.runtime.extension.api.introspection.ModelProperty;
import org.mule.runtime.extension.api.introspection.RuntimeExtensionModel;
import org.mule.runtime.extension.api.introspection.config.ConfigurationFactory;
import org.mule.runtime.extension.api.introspection.config.ImmutableConfigurationModel;
import org.mule.runtime.extension.api.introspection.config.RuntimeConfigurationModel;
import org.mule.runtime.extension.api.introspection.connection.ConnectionProviderModel;
import org.mule.runtime.extension.api.introspection.operation.OperationModel;
import org.mule.runtime.extension.api.introspection.parameter.ParameterModel;
import org.mule.runtime.extension.api.introspection.source.SourceModel;
import org.mule.runtime.extension.api.runtime.InterceptorFactory;

public final class ImmutableRuntimeConfigurationModel
extends ImmutableConfigurationModel
implements RuntimeConfigurationModel {
    private final transient Supplier<RuntimeExtensionModel> extensionModelSupplier;
    private final transient ConfigurationFactory configurationFactory;
    private final transient List<InterceptorFactory> interceptorFactories;

    public ImmutableRuntimeConfigurationModel(String name, String description, Supplier<RuntimeExtensionModel> extensionModelSupplier, ConfigurationFactory configurationFactory, List<ParameterModel> parameterModels, List<OperationModel> operationModels, List<ConnectionProviderModel> connectionProviders, List<SourceModel> sourceModels, Set<ModelProperty> modelProperties, List<InterceptorFactory> interceptorFactories) {
        super(name, description, parameterModels, operationModels, connectionProviders, sourceModels, modelProperties);
        ImmutableRuntimeConfigurationModel.checkArgument(configurationFactory != null, "Configuration factory cannot be null");
        this.extensionModelSupplier = extensionModelSupplier;
        this.configurationFactory = configurationFactory;
        this.interceptorFactories = interceptorFactories != null ? Collections.unmodifiableList(interceptorFactories) : Collections.emptyList();
    }

    @Override
    @Transient
    public ConfigurationFactory getConfigurationFactory() {
        return this.configurationFactory;
    }

    @Override
    @Transient
    public RuntimeExtensionModel getExtensionModel() {
        return this.extensionModelSupplier.get();
    }

    @Override
    @Transient
    public List<InterceptorFactory> getInterceptorFactories() {
        return this.interceptorFactories;
    }
}

