/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.extension.api.introspection.declaration.fluent.util;

import org.mule.runtime.extension.api.introspection.declaration.fluent.ConfigurationDeclaration;
import org.mule.runtime.extension.api.introspection.declaration.fluent.ConnectedDeclaration;
import org.mule.runtime.extension.api.introspection.declaration.fluent.ConnectionProviderDeclaration;
import org.mule.runtime.extension.api.introspection.declaration.fluent.ExtensionDeclaration;
import org.mule.runtime.extension.api.introspection.declaration.fluent.OperationDeclaration;
import org.mule.runtime.extension.api.introspection.declaration.fluent.ParameterDeclaration;
import org.mule.runtime.extension.api.introspection.declaration.fluent.ParameterizedInterceptableDeclaration;
import org.mule.runtime.extension.api.introspection.declaration.fluent.SourceDeclaration;
import org.mule.runtime.extension.api.introspection.declaration.fluent.WithOperationsDeclaration;
import org.mule.runtime.extension.api.introspection.declaration.fluent.WithSourcesDeclaration;

public abstract class DeclarationWalker {
    public final void walk(ExtensionDeclaration extensionDeclaration) {
        if (extensionDeclaration == null) {
            throw new IllegalArgumentException("Cannot walk a null declaration");
        }
        extensionDeclaration.getConfigurations().forEach(configuration -> {
            this.onConfiguration((ConfigurationDeclaration)configuration);
            this.walkConnectionProviders((ConnectedDeclaration)configuration);
            this.walkParameters((ParameterizedInterceptableDeclaration)configuration);
            this.walkSources((WithSourcesDeclaration)configuration);
            this.walkOperations((WithOperationsDeclaration)configuration);
        });
        this.walkConnectionProviders(extensionDeclaration);
        this.walkSources(extensionDeclaration);
        this.walkOperations(extensionDeclaration);
    }

    public void onConfiguration(ConfigurationDeclaration declaration) {
    }

    public void onOperation(WithOperationsDeclaration owner, OperationDeclaration declaration) {
    }

    public void onConnectionProvider(ConnectedDeclaration owner, ConnectionProviderDeclaration declaration) {
    }

    public void onSource(WithSourcesDeclaration owner, SourceDeclaration declaration) {
    }

    public void onParameter(ParameterizedInterceptableDeclaration owner, ParameterDeclaration declaration) {
    }

    private void walkSources(WithSourcesDeclaration declaration) {
        declaration.getMessageSources().forEach(source -> {
            SourceDeclaration sourceDeclaration = (SourceDeclaration)source;
            this.onSource(declaration, sourceDeclaration);
            this.walkParameters(sourceDeclaration);
        });
    }

    private void walkParameters(ParameterizedInterceptableDeclaration declaration) {
        declaration.getParameters().forEach(parameter -> this.onParameter(declaration, (ParameterDeclaration)parameter));
    }

    private void walkConnectionProviders(ConnectedDeclaration declaration) {
        declaration.getConnectionProviders().stream().forEach(provider -> {
            ConnectionProviderDeclaration providerDeclaration = (ConnectionProviderDeclaration)provider;
            this.onConnectionProvider(declaration, providerDeclaration);
            this.walkParameters(providerDeclaration);
        });
    }

    private void walkOperations(WithOperationsDeclaration model) {
        model.getOperations().stream().forEach(operation -> {
            OperationDeclaration operationDeclaration = (OperationDeclaration)operation;
            this.onOperation(model, operationDeclaration);
            this.walkParameters(operationDeclaration);
        });
    }
}

