/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.extension.api.introspection.declaration.type;

import java.lang.reflect.Field;
import java.lang.reflect.Type;
import java.util.Collection;
import java.util.Optional;
import org.mule.metadata.api.annotation.DefaultValueAnnotation;
import org.mule.metadata.api.annotation.TypeAnnotation;
import org.mule.metadata.api.builder.ObjectFieldTypeBuilder;
import org.mule.metadata.api.builder.ObjectTypeBuilder;
import org.mule.metadata.api.builder.TypeBuilder;
import org.mule.metadata.java.api.handler.DefaultObjectFieldHandler;
import org.mule.metadata.java.api.handler.ObjectFieldHandler;
import org.mule.metadata.java.api.handler.TypeHandlerManager;
import org.mule.metadata.java.api.utils.ParsingContext;
import org.mule.runtime.extension.api.annotation.Expression;
import org.mule.runtime.extension.api.annotation.param.NoRef;
import org.mule.runtime.extension.api.introspection.declaration.type.ExpressionSupportAnnotation;
import org.mule.runtime.extension.api.introspection.declaration.type.TypeUtils;
import org.mule.runtime.extension.api.introspection.declaration.type.annotation.NoReferenceAnnotation;
import org.mule.runtime.extension.api.introspection.parameter.ExpressionSupport;

final class ExtensionsFieldHandler
implements ObjectFieldHandler {
    ExtensionsFieldHandler() {
    }

    public void handleFields(Class<?> clazz, TypeHandlerManager typeHandlerManager, ParsingContext context, ObjectTypeBuilder builder) {
        if (clazz.getName().equals("org.mule.runtime.core.api.NestedProcessor")) {
            return;
        }
        Collection<Field> fields = TypeUtils.getParameterFields(clazz);
        if (fields.isEmpty()) {
            this.fallbackToBeanProperties(clazz, typeHandlerManager, context, builder);
            return;
        }
        for (Field field : fields) {
            ObjectFieldTypeBuilder fieldBuilder = builder.addField();
            fieldBuilder.key(TypeUtils.getAlias(field));
            this.setOptionalAndDefault(field, fieldBuilder);
            this.setExpressionSupport(field, fieldBuilder);
            this.setReferenceSupport(field, fieldBuilder);
            this.setFieldType(typeHandlerManager, context, field, fieldBuilder);
        }
    }

    private void setFieldType(TypeHandlerManager typeHandlerManager, ParsingContext context, Field field, ObjectFieldTypeBuilder<?> fieldBuilder) {
        Type fieldType = field.getGenericType();
        Optional typeBuilder = context.getTypeBuilder(fieldType);
        if (typeBuilder.isPresent()) {
            fieldBuilder.value((TypeBuilder)typeBuilder.get());
        } else {
            typeHandlerManager.handle(fieldType, context, fieldBuilder.value());
        }
    }

    private void setExpressionSupport(Field field, ObjectFieldTypeBuilder<?> fieldBuilder) {
        Expression expression = field.getAnnotation(Expression.class);
        fieldBuilder.with((TypeAnnotation)new ExpressionSupportAnnotation(expression != null ? expression.value() : ExpressionSupport.SUPPORTED));
    }

    private void setReferenceSupport(Field field, ObjectFieldTypeBuilder<?> fieldBuilder) {
        if (field.getAnnotation(NoRef.class) != null) {
            fieldBuilder.with((TypeAnnotation)new NoReferenceAnnotation());
        }
    }

    private void setOptionalAndDefault(Field field, ObjectFieldTypeBuilder<?> fieldBuilder) {
        org.mule.runtime.extension.api.annotation.param.Optional optionalAnnotation = field.getAnnotation(org.mule.runtime.extension.api.annotation.param.Optional.class);
        if (optionalAnnotation != null) {
            fieldBuilder.required(false);
            if (!optionalAnnotation.defaultValue().equals("THIS IS A SPECIAL NULL VALUE - DO NOT USE")) {
                fieldBuilder.with((TypeAnnotation)new DefaultValueAnnotation(optionalAnnotation.defaultValue()));
            }
        } else {
            fieldBuilder.required(true);
        }
    }

    private void fallbackToBeanProperties(Class<?> clazz, TypeHandlerManager typeHandlerManager, ParsingContext context, ObjectTypeBuilder builder) {
        if (!clazz.isInterface()) {
            new DefaultObjectFieldHandler().handleFields(clazz, typeHandlerManager, context, builder);
        }
    }
}

