/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.extension.api.introspection.declaration.type;

import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import java.lang.reflect.Field;
import java.util.Collection;
import org.mule.metadata.api.model.MetadataType;
import org.mule.metadata.utils.MetadataTypeUtils;
import org.mule.runtime.extension.api.annotation.Alias;
import org.mule.runtime.extension.api.annotation.Parameter;
import org.mule.runtime.extension.api.annotation.param.Ignore;
import org.mule.runtime.extension.api.introspection.declaration.type.ExpressionSupportAnnotation;
import org.mule.runtime.extension.api.introspection.declaration.type.annotation.NoReferenceAnnotation;
import org.mule.runtime.extension.api.introspection.parameter.ExpressionSupport;
import org.reflections.ReflectionUtils;

public final class TypeUtils {
    private TypeUtils() {
    }

    public static Collection<Field> getParameterFields(Class<?> extensionType) {
        return ReflectionUtils.getAllFields(extensionType, (Predicate[])new Predicate[]{ReflectionUtils.withAnnotation(Parameter.class), Predicates.not((Predicate)ReflectionUtils.withAnnotation(Ignore.class))});
    }

    public static String getAlias(Field field) {
        Alias alias = field.getAnnotation(Alias.class);
        String name = alias != null ? alias.value() : null;
        return name == null || name.length() == 0 ? field.getName() : name;
    }

    public static ExpressionSupport getExpressionSupport(MetadataType metadataType) {
        return MetadataTypeUtils.getSingleAnnotation((MetadataType)metadataType, ExpressionSupportAnnotation.class).map(ExpressionSupportAnnotation::getExpressionSupport).orElse(ExpressionSupport.SUPPORTED);
    }

    public static boolean acceptsReferences(MetadataType metadataType) {
        return !MetadataTypeUtils.getSingleAnnotation((MetadataType)metadataType, NoReferenceAnnotation.class).isPresent();
    }
}

