/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.extension.api.introspection.property;

import org.mule.runtime.extension.api.introspection.property.DisplayModelProperty;

public class DisplayModelPropertyBuilder {
    private String displayName;
    private boolean isPassword;
    private boolean isText;
    private int order;
    private String groupName;
    private String tabName;

    public static DisplayModelPropertyBuilder create() {
        return new DisplayModelPropertyBuilder();
    }

    public static DisplayModelPropertyBuilder create(DisplayModelProperty modelProperty) {
        return new DisplayModelPropertyBuilder(modelProperty.getDisplayName(), modelProperty.isPassword(), modelProperty.isText(), modelProperty.getOrder(), modelProperty.getTabName(), modelProperty.getGroupName());
    }

    private DisplayModelPropertyBuilder() {
        this.isPassword = false;
        this.isText = false;
        this.order = 1;
        this.displayName = "";
        this.groupName = "";
        this.tabName = "";
    }

    public DisplayModelPropertyBuilder(String displayName, boolean isPassword, boolean isText, int order, String tabName, String groupName) {
        this.displayName = displayName;
        this.isPassword = isPassword;
        this.isText = isText;
        this.order = order;
        this.tabName = tabName;
        this.groupName = groupName;
    }

    public DisplayModelPropertyBuilder withPassword(boolean isPassword) {
        this.isPassword = isPassword;
        return this;
    }

    public DisplayModelPropertyBuilder withText(boolean isText) {
        this.isText = isText;
        return this;
    }

    public DisplayModelPropertyBuilder tabName(String tabName) {
        this.tabName = tabName;
        return this;
    }

    public DisplayModelPropertyBuilder groupName(String groupName) {
        this.groupName = groupName;
        return this;
    }

    public DisplayModelPropertyBuilder displayName(String displayName) {
        this.displayName = displayName;
        return this;
    }

    public DisplayModelPropertyBuilder order(int order) {
        this.order = order;
        return this;
    }

    public DisplayModelProperty build() {
        return new DisplayModelProperty(this.displayName, this.isPassword, this.isText, this.order, this.groupName, this.tabName);
    }
}

