/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.extension.api.manifest;

import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.mule.api.MuleVersion;
import org.mule.runtime.extension.api.manifest.DescriberManifest;
import org.mule.runtime.extension.api.manifest.ExtensionManifest;
import org.mule.runtime.extension.internal.manifest.ImmutableDescriberManifest;
import org.mule.runtime.extension.internal.manifest.ImmutableExtensionManifest;

public final class ExtensionManifestBuilder {
    private String name;
    private String description;
    private String version;
    private MuleVersion minMuleVersion;
    private List<String> exportedPackages = new LinkedList<String>();
    private List<String> exportedResources = new LinkedList<String>();
    private final DescriberManifestBuilder describerManifestBuilder = new DescriberManifestBuilder();

    public ExtensionManifestBuilder setName(String name) {
        this.name = name;
        return this;
    }

    public ExtensionManifestBuilder setDescription(String description) {
        this.description = description;
        return this;
    }

    public ExtensionManifestBuilder addExportedPackages(Collection<String> packages) {
        this.exportedPackages.addAll(packages);
        return this;
    }

    public ExtensionManifestBuilder addExportedResources(Collection<String> resources) {
        this.exportedResources.addAll(resources);
        return this;
    }

    public ExtensionManifestBuilder setVersion(String version) {
        this.version = version;
        return this;
    }

    public ExtensionManifestBuilder setMinMuleVersion(MuleVersion muleVersion) {
        this.minMuleVersion = muleVersion;
        return this;
    }

    public DescriberManifestBuilder withDescriber() {
        return this.describerManifestBuilder;
    }

    public ExtensionManifest build() {
        return new ImmutableExtensionManifest(this.name, this.description, this.version, this.minMuleVersion, this.exportedPackages, this.exportedResources, this.describerManifestBuilder.build());
    }

    public static final class DescriberManifestBuilder {
        private String id;
        private final Map<String, String> properties = new HashMap<String, String>();

        private DescriberManifestBuilder() {
        }

        public DescriberManifestBuilder setId(String id) {
            this.id = id;
            return this;
        }

        public DescriberManifestBuilder addProperty(String key, String value) {
            this.validatePropertyKey(key);
            this.properties.put(key, value);
            return this;
        }

        public DescriberManifestBuilder addProperties(Map<String, String> properties) {
            properties.keySet().forEach(this::validatePropertyKey);
            this.properties.putAll(properties);
            return this;
        }

        private void validatePropertyKey(String key) {
            if (StringUtils.isBlank((CharSequence)key)) {
                throw new IllegalArgumentException("Cannot add a property with a blank key");
            }
        }

        private DescriberManifest build() {
            return new ImmutableDescriberManifest(this.id, this.properties);
        }
    }
}

