/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.extension.api.util;

import java.util.ArrayList;
import java.util.List;
import java.util.regex.Pattern;
import org.apache.commons.lang3.StringUtils;
import org.mule.metadata.api.model.MetadataType;
import org.mule.metadata.java.api.utils.JavaTypeUtils;
import org.mule.runtime.extension.api.annotation.Alias;

public class NameUtils {
    private static final List<Inflection> plural = new ArrayList<Inflection>();
    private static final List<Inflection> singular = new ArrayList<Inflection>();
    private static final List<String> uncountable = new ArrayList<String>();

    private NameUtils() {
    }

    private static void plural(String pattern, String replacement) {
        plural.add(0, new Inflection(pattern, replacement));
    }

    private static void singular(String pattern, String replacement) {
        singular.add(0, new Inflection(pattern, replacement));
    }

    private static void irregular(String s, String p) {
        NameUtils.plural("(" + s.substring(0, 1) + ")" + s.substring(1) + "$", "$1" + p.substring(1));
        NameUtils.singular("(" + p.substring(0, 1) + ")" + p.substring(1) + "$", "$1" + s.substring(1));
    }

    private static void uncountable(String word) {
        uncountable.add(word);
    }

    public static String hyphenize(String camelCaseName) {
        if (StringUtils.isBlank((CharSequence)camelCaseName)) {
            return camelCaseName;
        }
        String result = "";
        String[] parts = camelCaseName.split("(?<!^)(?=[A-Z])");
        for (int i = 0; i < parts.length; ++i) {
            result = result + parts[i].toLowerCase() + (i < parts.length - 1 ? "-" : "");
        }
        return result;
    }

    public static String pluralize(String word) {
        if (NameUtils.isUncountable(word)) {
            return word;
        }
        for (Inflection inflection : plural) {
            if (!inflection.match(word)) continue;
            return inflection.replace(word);
        }
        return word;
    }

    public static String singularize(String word) {
        if (NameUtils.isUncountable(word)) {
            return word;
        }
        for (Inflection inflection : singular) {
            if (!inflection.match(word)) continue;
            return inflection.replace(word);
        }
        return word;
    }

    public static String itemize(String word) {
        return StringUtils.isBlank((CharSequence)word) ? word : NameUtils.hyphenize(word).concat("-item");
    }

    public static boolean isUncountable(String word) {
        if (StringUtils.isBlank((CharSequence)word)) {
            for (String w : uncountable) {
                if (!w.equalsIgnoreCase(word)) continue;
                return true;
            }
        }
        return false;
    }

    public static String getTopLevelTypeName(MetadataType metadataType) {
        Class type = JavaTypeUtils.getType((MetadataType)metadataType);
        Alias alias = type.getAnnotation(Alias.class);
        String name = alias != null ? alias.value() : type.getSimpleName();
        return NameUtils.hyphenize(name);
    }

    public static String defaultNamespace(String extensionName) {
        if (StringUtils.isBlank((CharSequence)extensionName)) {
            throw new IllegalArgumentException("No Namespace can be created from an empty name");
        }
        String namespace = StringUtils.deleteWhitespace((String)extensionName);
        namespace = StringUtils.removeEndIgnoreCase((String)namespace, (String)"extension");
        namespace = StringUtils.removeEndIgnoreCase((String)namespace, (String)"connector");
        return NameUtils.hyphenize(StringUtils.isBlank((CharSequence)(namespace = StringUtils.removeEndIgnoreCase((String)namespace, (String)"module"))) ? extensionName : namespace);
    }

    public static String sanitizeName(String originalName) {
        return originalName.replaceAll("[^\\w|\\.\\-]", "");
    }

    static {
        NameUtils.plural("$", "s");
        NameUtils.plural("s$", "s");
        NameUtils.plural("(ax|test)is$", "$1es");
        NameUtils.plural("(octop|vir)us$", "$1i");
        NameUtils.plural("(alias|status)$", "$1es");
        NameUtils.plural("(bu)s$", "$1ses");
        NameUtils.plural("(buffal|tomat)o$", "$1oes");
        NameUtils.plural("([ti])um$", "$1a");
        NameUtils.plural("sis$", "ses");
        NameUtils.plural("(?:([^f])fe|([lr])f)$", "$1$2ves");
        NameUtils.plural("(hive)$", "$1s");
        NameUtils.plural("([^aeiouy]|qu)y$", "$1ies");
        NameUtils.plural("(x|ch|ss|sh)$", "$1es");
        NameUtils.plural("(matr|vert|ind)ix|ex$", "$1ices");
        NameUtils.plural("([m|l])ouse$", "$1ice");
        NameUtils.plural("^(ox)$", "$1en");
        NameUtils.plural("(quiz)$", "$1zes");
        NameUtils.singular("s$", "");
        NameUtils.singular("(n)ews$", "$1ews");
        NameUtils.singular("([ti])a$", "$1um");
        NameUtils.singular("((a)naly|(b)a|(d)iagno|(p)arenthe|(p)rogno|(s)ynop|(t)he)ses$", "$1$2sis");
        NameUtils.singular("(^analy)ses$", "$1sis");
        NameUtils.singular("([^f])ves$", "$1fe");
        NameUtils.singular("(hive)s$", "$1");
        NameUtils.singular("(tive)s$", "$1");
        NameUtils.singular("([lr])ves$", "$1f");
        NameUtils.singular("([^aeiouy]|qu)ies$", "$1y");
        NameUtils.singular("(s)eries$", "$1eries");
        NameUtils.singular("(m)ovies$", "$1ovie");
        NameUtils.singular("(x|ch|ss|sh)es$", "$1");
        NameUtils.singular("([m|l])ice$", "$1ouse");
        NameUtils.singular("(bus)es$", "$1");
        NameUtils.singular("(o)es$", "$1");
        NameUtils.singular("(shoe)s$", "$1");
        NameUtils.singular("(cris|ax|test)es$", "$1is");
        NameUtils.singular("(octop|vir)i$", "$1us");
        NameUtils.singular("(alias|status)es$", "$1");
        NameUtils.singular("^(ox)en", "$1");
        NameUtils.singular("(vert|ind)ices$", "$1ex");
        NameUtils.singular("(matr)ices$", "$1ix");
        NameUtils.singular("(quiz)zes$", "$1");
        NameUtils.irregular("person", "people");
        NameUtils.irregular("man", "men");
        NameUtils.irregular("child", "children");
        NameUtils.irregular("sex", "sexes");
        NameUtils.irregular("move", "moves");
        NameUtils.uncountable("equipment");
        NameUtils.uncountable("information");
        NameUtils.uncountable("rice");
        NameUtils.uncountable("money");
        NameUtils.uncountable("species");
        NameUtils.uncountable("series");
        NameUtils.uncountable("fish");
        NameUtils.uncountable("sheep");
    }

    private static class Inflection {
        private String pattern;
        private String replacement;
        private boolean ignoreCase;

        public Inflection(String pattern, String replacement) {
            this(pattern, replacement, true);
        }

        public Inflection(String pattern, String replacement, boolean ignoreCase) {
            this.pattern = pattern;
            this.replacement = replacement;
            this.ignoreCase = ignoreCase;
        }

        public boolean match(String word) {
            int flags = 0;
            if (this.ignoreCase) {
                flags |= 2;
            }
            return Pattern.compile(this.pattern, flags).matcher(word).find();
        }

        public String replace(String word) {
            int flags = 0;
            if (this.ignoreCase) {
                flags |= 2;
            }
            return Pattern.compile(this.pattern, flags).matcher(word).replaceAll(this.replacement);
        }
    }
}

