/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.extension.api.util;

import com.google.common.collect.ImmutableList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.mule.metadata.api.model.MetadataType;
import org.mule.metadata.utils.MetadataTypeUtils;

public class SubTypesMappingContainer {
    private final Map<MetadataType, List<MetadataType>> subTypesMapping;
    private final Map<String, List<MetadataType>> subTypesById;

    public SubTypesMappingContainer(Map<MetadataType, List<MetadataType>> subTypesMapping) {
        this.subTypesMapping = subTypesMapping;
        this.subTypesById = subTypesMapping.entrySet().stream().filter(e -> MetadataTypeUtils.getTypeId((MetadataType)((MetadataType)e.getKey())).isPresent()).collect(Collectors.toMap(e -> (String)MetadataTypeUtils.getTypeId((MetadataType)((MetadataType)e.getKey())).get(), Map.Entry::getValue));
    }

    public List<MetadataType> getSubTypes(MetadataType type) {
        List<MetadataType> subTypes = MetadataTypeUtils.getTypeId((MetadataType)type).map(this.subTypesById::get).orElse(this.subTypesMapping.get(type));
        return subTypes != null ? ImmutableList.copyOf(subTypes) : ImmutableList.of();
    }

    public boolean containsBaseType(MetadataType type) {
        return MetadataTypeUtils.getTypeId((MetadataType)type).map(this.subTypesById::get).orElse(this.subTypesMapping.get(type)) != null;
    }

    public Optional<MetadataType> getBaseType(MetadataType type) {
        Predicate<List> anyMatchTypeMatcher = MetadataTypeUtils.getTypeId((MetadataType)type).map(id -> subTypes -> subTypes.stream().map(MetadataTypeUtils::getTypeId).filter(Optional::isPresent).anyMatch(subTypeId -> ((String)subTypeId.get()).equals(id))).orElse(subtypes -> subtypes.stream().anyMatch(subType -> subType.equals(type)));
        for (Map.Entry<MetadataType, List<MetadataType>> subtypesByBase : this.subTypesMapping.entrySet()) {
            if (!anyMatchTypeMatcher.test(subtypesByBase.getValue())) continue;
            return Optional.of(subtypesByBase.getKey());
        }
        return Optional.empty();
    }
}

