/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.extension.internal.manifest;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.mule.api.MuleVersion;
import org.mule.runtime.extension.api.manifest.DescriberManifest;
import org.mule.runtime.extension.api.manifest.ExtensionManifest;

public final class ImmutableExtensionManifest
implements ExtensionManifest {
    private final String name;
    private final String description;
    private final String version;
    private final List<String> exportedPackages;
    private final List<String> exportedResources;
    private final DescriberManifest describerManifest;
    private final MuleVersion minMuleVersion;

    public ImmutableExtensionManifest(String name, String description, String version, MuleVersion minMuleVersion, List<String> exportedPackages, List<String> exportedResources, DescriberManifest describerManifest) {
        this.checkNotBlank(name, "name");
        this.checkNotBlank(version, "version");
        this.name = name;
        this.description = description;
        this.version = version;
        this.minMuleVersion = minMuleVersion;
        this.describerManifest = describerManifest;
        this.exportedPackages = this.immutable(exportedPackages);
        this.exportedResources = this.immutable(exportedResources);
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public String getDescription() {
        return this.description;
    }

    @Override
    public String getVersion() {
        return this.version;
    }

    @Override
    public MuleVersion getMinMuleVersion() {
        return this.minMuleVersion;
    }

    @Override
    public DescriberManifest getDescriberManifest() {
        return this.describerManifest;
    }

    @Override
    public List<String> getExportedPackages() {
        return this.exportedPackages;
    }

    @Override
    public List<String> getExportedResources() {
        return this.exportedResources;
    }

    private void checkNotBlank(String value, String attributeName) {
        if (StringUtils.isBlank((CharSequence)value)) {
            throw new IllegalStateException("Manifest cannot have a blank " + attributeName);
        }
    }

    private <T> List<T> immutable(Collection<T> collection) {
        return Collections.unmodifiableList(new ArrayList<T>(collection));
    }
}

