/*
 * Copyright (c) MuleSoft, Inc.  All rights reserved.  http://www.mulesoft.com
 * The software in this package is published under the terms of the CPAL v1.0
 * license, a copy of which has been included with this distribution in the
 * LICENSE.txt file.
 */
package org.mule.runtime.extension.api.introspection;

/**
 * A generic contract for a class that has a name.
 * Implementations might use {@link #getName()} as key, but they're not required to.
 * Notice that if the name is in fact used as a key, then it should be unique
 *
 * @since 1.0
 */
public interface Named {

  /**
   * Returns the component's name
   *
   * @return a non blank {@link String}
   */
  String getName();

}
