/*
 * Copyright (c) MuleSoft, Inc.  All rights reserved.  http://www.mulesoft.com
 * The software in this package is published under the terms of the CPAL v1.0
 * license, a copy of which has been included with this distribution in the
 * LICENSE.txt file.
 */
package org.mule.runtime.extension.api.introspection.property;

import org.mule.runtime.extension.api.introspection.ModelProperty;

/**
 * Represents an extension's capability to provide a custom UI description
 *
 * @since 1.0
 */
public final class StudioModelProperty implements ModelProperty {

  private final String editorFileName;
  private final boolean derived;

  public StudioModelProperty(String editorFileName, boolean derived) {
    this.editorFileName = editorFileName;
    this.derived = derived;
  }

  /**
   * @return The name of the file used to describe the UI.
   */
  public String getEditorFileName() {
    return editorFileName;
  }

  /**
   * @return Signals that an editor will be generated by Anypoint Studio
   */
  public boolean isDerived() {
    return derived;
  }

  /**
   * {@inheritDoc}
   * @return {@code Studio}
   */
  @Override
  public String getName() {
    return "Studio";
  }

  /**
   * {@inheritDoc}
   * @return {@code true}
   */
  @Override
  public boolean isExternalizable() {
    return true;
  }

  @Override
  public String toString() {
    return new StringBuilder().append("StudioModelProperty{")
        .append("editorFileName='").append(editorFileName).append('\'')
        .append(", derived=").append(derived)
        .append('}').toString();
  }
}
