/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.extension.api;

import java.util.Arrays;
import java.util.concurrent.atomic.AtomicInteger;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.runners.MockitoJUnitRunner;
import org.mule.runtime.extension.api.ExtensionWalker;
import org.mule.runtime.extension.api.introspection.ExtensionModel;
import org.mule.runtime.extension.api.introspection.config.ConfigurationModel;
import org.mule.runtime.extension.api.introspection.connection.ConnectionProviderModel;
import org.mule.runtime.extension.api.introspection.connection.HasConnectionProviderModels;
import org.mule.runtime.extension.api.introspection.operation.HasOperationModels;
import org.mule.runtime.extension.api.introspection.operation.OperationModel;
import org.mule.runtime.extension.api.introspection.parameter.ParameterModel;
import org.mule.runtime.extension.api.introspection.parameter.ParameterizedModel;
import org.mule.runtime.extension.api.introspection.source.HasSourceModels;
import org.mule.runtime.extension.api.introspection.source.SourceModel;

@RunWith(value=MockitoJUnitRunner.class)
public class ExtensionWalkerTestCase {
    @Mock
    private ExtensionModel extension;
    @Mock
    private ConfigurationModel configuration;
    @Mock
    private OperationModel operation;
    @Mock
    private ConnectionProviderModel connectionProvider;
    @Mock
    private ParameterModel parameterModel;
    @Mock
    private SourceModel source;

    @Before
    public void before() {
        Mockito.when((Object)this.extension.getConfigurationModels()).thenReturn(Arrays.asList(this.configuration));
        Mockito.when((Object)this.extension.getOperationModels()).thenReturn(Arrays.asList(this.operation));
        Mockito.when((Object)this.extension.getSourceModels()).thenReturn(Arrays.asList(this.source));
        Mockito.when((Object)this.extension.getConnectionProviders()).thenReturn(Arrays.asList(this.connectionProvider));
        Mockito.when((Object)this.configuration.getOperationModels()).thenReturn(Arrays.asList(this.operation));
        Mockito.when((Object)this.configuration.getSourceModels()).thenReturn(Arrays.asList(this.source));
        Mockito.when((Object)this.configuration.getConnectionProviders()).thenReturn(Arrays.asList(this.connectionProvider));
        this.addParameter(new ParameterizedModel[]{this.configuration, this.operation, this.connectionProvider, this.source});
    }

    private void addParameter(ParameterizedModel ... models) {
        for (ParameterizedModel model : models) {
            Mockito.when((Object)model.getParameterModels()).thenReturn(Arrays.asList(this.parameterModel));
        }
    }

    @Test
    public void walk() {
        final AtomicInteger configs = new AtomicInteger(0);
        final AtomicInteger operations = new AtomicInteger(0);
        final AtomicInteger sources = new AtomicInteger(0);
        final AtomicInteger parameters = new AtomicInteger(0);
        final AtomicInteger providers = new AtomicInteger(0);
        new ExtensionWalker(){

            public void onConfiguration(ConfigurationModel model) {
                configs.incrementAndGet();
            }

            public void onOperation(HasOperationModels owner, OperationModel model) {
                operations.incrementAndGet();
            }

            public void onConnectionProvider(HasConnectionProviderModels owner, ConnectionProviderModel model) {
                providers.incrementAndGet();
            }

            public void onSource(HasSourceModels owner, SourceModel model) {
                sources.incrementAndGet();
            }

            public void onParameter(ParameterizedModel owner, ParameterModel model) {
                parameters.incrementAndGet();
            }
        }.walk(this.extension);
        this.assertCount(configs, 1);
        this.assertCount(operations, 2);
        this.assertCount(sources, 2);
        this.assertCount(providers, 2);
        this.assertCount(parameters, 7);
    }

    private void assertCount(AtomicInteger actual, int expected) {
        Assert.assertThat((Object)actual.get(), (Matcher)CoreMatchers.is((Object)expected));
    }
}

