/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.extension.api;

import java.util.Optional;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mockito.Mockito;
import org.mockito.invocation.InvocationOnMock;
import org.mockito.stubbing.Answer;
import org.mule.metadata.api.annotation.TypeIdAnnotation;
import org.mule.metadata.api.model.MetadataFormat;
import org.mule.metadata.api.model.MetadataType;
import org.mule.metadata.api.model.ObjectType;
import org.mule.metadata.api.visitor.MetadataTypeVisitor;
import org.mule.runtime.extension.api.annotation.Alias;
import org.mule.runtime.extension.api.introspection.declaration.type.annotation.TypeAliasAnnotation;
import org.mule.runtime.extension.api.util.NameUtils;

public class NameUtilsTestCase {
    private static final String TYPE_ALIAS = "Batman";
    private ObjectType objectType;

    @Before
    public void setup() {
        this.objectType = (ObjectType)Mockito.mock(ObjectType.class);
        Mockito.when((Object)this.objectType.getAnnotation(TypeAliasAnnotation.class)).thenReturn(Optional.empty());
        ((ObjectType)Mockito.doAnswer((Answer)new Answer<Void>(){

            public Void answer(InvocationOnMock invocation) throws Throwable {
                MetadataTypeVisitor visitor = (MetadataTypeVisitor)invocation.getArguments()[0];
                visitor.visitObject(NameUtilsTestCase.this.objectType);
                return null;
            }
        }).when((Object)this.objectType)).accept((MetadataTypeVisitor)Mockito.any(MetadataTypeVisitor.class));
    }

    @Test
    public void getTopLevelTypeNameByTypeAlias() {
        Mockito.when((Object)this.objectType.getAnnotation(TypeAliasAnnotation.class)).thenReturn(Optional.of(new TypeAliasAnnotation(TYPE_ALIAS)));
        Assert.assertThat((Object)NameUtils.getTopLevelTypeName((MetadataType)this.objectType), (Matcher)CoreMatchers.is((Object)NameUtils.hyphenize((String)TYPE_ALIAS)));
    }

    @Test
    public void getTopLevelTypeNameByTypeId() {
        String typeId = this.getClass().getName();
        Mockito.when((Object)this.objectType.getMetadataFormat()).thenReturn((Object)MetadataFormat.JSON);
        Mockito.when((Object)this.objectType.getAnnotation(TypeIdAnnotation.class)).thenReturn(Optional.of(new TypeIdAnnotation(typeId)));
        Assert.assertThat((Object)NameUtils.getTopLevelTypeName((MetadataType)this.objectType), (Matcher)CoreMatchers.is((Object)NameUtils.hyphenize((String)typeId)));
    }

    @Test
    public void getTopLevelTypeNameByAliasAnnotation() {
        Mockito.when((Object)this.objectType.getMetadataFormat()).thenReturn((Object)MetadataFormat.JAVA);
        Mockito.when((Object)this.objectType.getAnnotation(TypeIdAnnotation.class)).thenReturn(Optional.of(new TypeIdAnnotation(AliasedClass.class.getName())));
        Assert.assertThat((Object)NameUtils.getTopLevelTypeName((MetadataType)this.objectType), (Matcher)CoreMatchers.is((Object)NameUtils.hyphenize((String)TYPE_ALIAS)));
    }

    @Alias(value="Batman")
    private static class AliasedClass {
        private AliasedClass() {
        }
    }
}

