/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.extension.api.introspection.declaration;

import java.io.InputStream;
import java.io.Serializable;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.runners.MockitoJUnitRunner;
import org.mule.metadata.api.builder.TypeBuilder;
import org.mule.metadata.api.model.BinaryType;
import org.mule.metadata.api.model.MetadataType;
import org.mule.metadata.api.model.NullType;
import org.mule.metadata.api.model.NumberType;
import org.mule.metadata.api.model.ObjectType;
import org.mule.metadata.api.model.StringType;
import org.mule.runtime.extension.api.Category;
import org.mule.runtime.extension.api.introspection.ModelProperty;
import org.mule.runtime.extension.api.introspection.declaration.BaseDeclarationTestCase;
import org.mule.runtime.extension.api.introspection.declaration.fluent.BaseDeclaration;
import org.mule.runtime.extension.api.introspection.declaration.fluent.ConfigurationDeclaration;
import org.mule.runtime.extension.api.introspection.declaration.fluent.ConnectionProviderDeclaration;
import org.mule.runtime.extension.api.introspection.declaration.fluent.ExtensionDeclaration;
import org.mule.runtime.extension.api.introspection.declaration.fluent.OperationDeclaration;
import org.mule.runtime.extension.api.introspection.declaration.fluent.ParameterDeclaration;
import org.mule.runtime.extension.api.introspection.declaration.fluent.SourceDeclaration;
import org.mule.runtime.extension.api.introspection.operation.OperationModel;
import org.mule.runtime.extension.api.introspection.parameter.ExpressionSupport;
import org.mule.runtime.extension.api.runtime.InterceptorFactory;
import org.mule.runtime.extension.tck.introspection.TestWebServiceConsumerDeclarer;

@RunWith(value=MockitoJUnitRunner.class)
public class FlatExtensionDeclarationTestCase
extends BaseDeclarationTestCase {
    private TestWebServiceConsumerDeclarer testDeclaration;
    private ExtensionDeclaration extensionDeclaration;

    @Before
    public void before() {
        this.testDeclaration = new TestWebServiceConsumerDeclarer();
        this.extensionDeclaration = (ExtensionDeclaration)this.testDeclaration.getExtensionDeclarer().getDeclaration();
    }

    @Test
    public void assertDeclaration() {
        Assert.assertThat((Object)this.extensionDeclaration.getName(), (Matcher)CoreMatchers.is((Object)"WSConsumer"));
        Assert.assertThat((Object)this.extensionDeclaration.getDescription(), (Matcher)CoreMatchers.is((Object)"Generic Consumer for SOAP Web Services"));
        Assert.assertThat((Object)this.extensionDeclaration.getVersion(), (Matcher)CoreMatchers.is((Object)"3.6.0"));
        Assert.assertThat((Object)this.extensionDeclaration.getConfigurations(), (Matcher)Matchers.hasSize((int)1));
        Assert.assertThat((Object)this.extensionDeclaration.getVendor(), (Matcher)CoreMatchers.is((Object)"MuleSoft"));
        Assert.assertThat((Object)this.extensionDeclaration.getMinMuleVersion(), (Matcher)CoreMatchers.is((Object)TestWebServiceConsumerDeclarer.MIN_MULE_VERSION));
        Assert.assertThat((Object)this.extensionDeclaration.getCategory(), (Matcher)CoreMatchers.is((Object)Category.SELECT));
        Assert.assertThat((Object)this.extensionDeclaration.getExceptionEnricherFactory().isPresent(), (Matcher)CoreMatchers.is((Object)true));
        Assert.assertThat(this.extensionDeclaration.getExceptionEnricherFactory().get(), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.sameInstance((Object)this.testDeclaration.getExceptionEnricherFactory().get())));
        this.assertModelProperties((BaseDeclaration<?>)this.extensionDeclaration, TestWebServiceConsumerDeclarer.EXTENSION_MODEL_PROPERTY);
    }

    @Test
    public void defaultConfiguration() throws Exception {
        Assert.assertThat((Object)this.extensionDeclaration.getConfigurations(), (Matcher)Matchers.hasSize((int)1));
        ConfigurationDeclaration configuration = (ConfigurationDeclaration)this.extensionDeclaration.getConfigurations().get(0);
        Assert.assertThat((Object)configuration, (Matcher)CoreMatchers.is((Matcher)Matchers.notNullValue()));
        Assert.assertThat((Object)configuration.getConfigurationFactory(), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.sameInstance((Object)this.testDeclaration.getConfigurationFactory())));
        Assert.assertThat((Object)configuration.getName(), (Matcher)CoreMatchers.is((Object)"config"));
        Assert.assertThat((Object)configuration.getDescription(), (Matcher)CoreMatchers.is((Object)"Default description"));
        this.assertModelProperties((BaseDeclaration<?>)configuration, TestWebServiceConsumerDeclarer.CONFIGURATION_MODEL_PROPERTY);
        List interceptorFactories = configuration.getInterceptorFactories();
        Assert.assertThat((Object)interceptorFactories, (Matcher)CoreMatchers.is((Matcher)Matchers.notNullValue()));
        Assert.assertThat((Object)interceptorFactories, (Matcher)Matchers.hasSize((int)2));
        Assert.assertThat((Object)((InterceptorFactory)interceptorFactories.get(0)).createInterceptor(), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.sameInstance((Object)this.testDeclaration.getConfigInterceptor1())));
        Assert.assertThat((Object)((InterceptorFactory)interceptorFactories.get(1)).createInterceptor(), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.sameInstance((Object)this.testDeclaration.getConfigInterceptor2())));
        List parameters = configuration.getParameters();
        Assert.assertThat((Object)parameters, (Matcher)Matchers.hasSize((int)4));
        this.assertParameter((ParameterDeclaration)parameters.get(0), "address", "Service address", ExpressionSupport.SUPPORTED, true, this.typeLoader.load(String.class), null);
        this.assertParameter((ParameterDeclaration)parameters.get(1), "port", "Service Port", ExpressionSupport.SUPPORTED, true, this.typeLoader.load(String.class), null);
        this.assertParameter((ParameterDeclaration)parameters.get(2), "service", "Service Name", ExpressionSupport.SUPPORTED, true, this.typeLoader.load(String.class), null);
        this.assertParameter((ParameterDeclaration)parameters.get(3), "wsdlLocation", "URI to find the WSDL", ExpressionSupport.NOT_SUPPORTED, true, this.typeLoader.load(String.class), null);
        this.assertModelProperties((BaseDeclaration)parameters.get(3), TestWebServiceConsumerDeclarer.PARAMETER_MODEL_PROPERTY);
    }

    @Test
    public void operations() throws Exception {
        List operations = this.extensionDeclaration.getOperations();
        Assert.assertThat((Object)operations, (Matcher)Matchers.hasSize((int)3));
        this.assertConsumeOperation(operations);
        this.assertBroadcastOperation(operations);
        this.assertArgLessOperation(operations);
    }

    @Test
    public void connectionProvider() throws Exception {
        List connectionProviders = this.extensionDeclaration.getConnectionProviders();
        Assert.assertThat((Object)connectionProviders, (Matcher)Matchers.hasSize((int)1));
        ConnectionProviderDeclaration connectionProvider = (ConnectionProviderDeclaration)connectionProviders.get(0);
        Assert.assertThat((Object)connectionProvider, (Matcher)CoreMatchers.is((Matcher)Matchers.notNullValue()));
        Assert.assertThat((Object)connectionProvider.getName(), (Matcher)CoreMatchers.is((Object)"connectionProvider"));
        Assert.assertThat((Object)connectionProvider.getDescription(), (Matcher)CoreMatchers.is((Object)"my connection provider"));
        Assert.assertThat((Object)connectionProvider.getFactory(), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.sameInstance((Object)this.testDeclaration.getConnectionProviderFactory())));
        Assert.assertThat((Object)connectionProvider.getConnectionType(), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.sameInstance(TestWebServiceConsumerDeclarer.CONNECTION_PROVIDER_CONNECTOR_TYPE)));
        List parameters = connectionProvider.getParameters();
        Assert.assertThat((Object)parameters, (Matcher)Matchers.hasSize((int)2));
        this.assertParameter((ParameterDeclaration)parameters.get(0), "username", "Authentication username", ExpressionSupport.SUPPORTED, true, this.typeLoader.load(String.class), null);
        this.assertParameter((ParameterDeclaration)parameters.get(1), "password", "Authentication password", ExpressionSupport.SUPPORTED, true, this.typeLoader.load(String.class), null);
    }

    @Test
    public void messageSource() throws Exception {
        List sources = this.extensionDeclaration.getMessageSources();
        Assert.assertThat((Object)sources, (Matcher)Matchers.hasSize((int)1));
        SourceDeclaration source = (SourceDeclaration)sources.get(0);
        Assert.assertThat((Object)source, (Matcher)CoreMatchers.is((Matcher)Matchers.notNullValue()));
        Assert.assertThat((Object)source.getName(), (Matcher)CoreMatchers.is((Object)"listener"));
        Assert.assertThat((Object)source.getDescription(), (Matcher)CoreMatchers.is((Object)"Listen requests"));
        Assert.assertThat((Object)source.getSourceFactory().createSource(), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.sameInstance((Object)this.testDeclaration.getSource())));
        this.assertDataType(source.getOutput().getType(), InputStream.class, BinaryType.class);
        this.assertDataType(source.getOutputAttributes().getType(), Serializable.class, ObjectType.class);
        List parameters = source.getParameters();
        Assert.assertThat((Object)parameters, (Matcher)Matchers.hasSize((int)2));
        this.assertParameter((ParameterDeclaration)parameters.get(0), "url", "Url to listen on", ExpressionSupport.SUPPORTED, true, this.typeLoader.load(String.class), null);
        this.assertParameter((ParameterDeclaration)parameters.get(1), "port", "Port to listen on", ExpressionSupport.SUPPORTED, false, this.typeLoader.load(Integer.class), 8080);
    }

    private void assertConsumeOperation(List<OperationDeclaration> operations) {
        OperationDeclaration operation = operations.get(0);
        Assert.assertThat((Object)operation.getName(), (Matcher)CoreMatchers.is((Object)"consumer"));
        Assert.assertThat((Object)operation.getDescription(), (Matcher)CoreMatchers.is((Object)"Go get them tiger"));
        Assert.assertThat((Object)operation.getExecutorFactory(), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.sameInstance((Object)this.testDeclaration.getConsumerExecutorFactory())));
        this.assertDataType(operation.getOutput().getType(), InputStream.class, BinaryType.class);
        this.assertDataType(operation.getOutputAttributes().getType(), String.class, StringType.class);
        this.assertModelProperties((BaseDeclaration<?>)operation, TestWebServiceConsumerDeclarer.OPERATION_MODEL_PROPERTY);
        List parameters = operation.getParameters();
        Assert.assertThat((Object)parameters, (Matcher)Matchers.hasSize((int)2));
        this.assertParameter((ParameterDeclaration)parameters.get(0), "operation", "The operation to use", ExpressionSupport.SUPPORTED, true, this.typeLoader.load(String.class), null);
        this.assertParameter((ParameterDeclaration)parameters.get(1), "mtomEnabled", "Whether or not use MTOM for attachments", ExpressionSupport.SUPPORTED, false, this.typeLoader.load(Boolean.class), true);
        Assert.assertThat((Object)operation.getInterceptorFactories(), (Matcher)CoreMatchers.is((Matcher)Matchers.empty()));
    }

    private void assertBroadcastOperation(List<OperationDeclaration> operations) {
        OperationDeclaration operation = operations.get(1);
        Assert.assertThat((Object)operation.getName(), (Matcher)CoreMatchers.is((Object)"broadcast"));
        Assert.assertThat((Object)operation.getDescription(), (Matcher)CoreMatchers.is((Object)"consumes many services"));
        Assert.assertThat((Object)operation.getExecutorFactory(), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.sameInstance((Object)this.testDeclaration.getBroadcastExecutorFactory())));
        this.assertDataType(operation.getOutput().getType(), Void.TYPE, NullType.class);
        Optional exceptionEnricherFactory = operation.getExceptionEnricherFactory();
        Assert.assertThat((Object)exceptionEnricherFactory.isPresent(), (Matcher)CoreMatchers.is((Object)true));
        Assert.assertThat(exceptionEnricherFactory.get(), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.sameInstance((Object)this.testDeclaration.getExceptionEnricherFactory().get())));
        List parameters = operation.getParameters();
        Assert.assertThat((Object)parameters, (Matcher)Matchers.hasSize((int)3));
        this.assertParameter((ParameterDeclaration)parameters.get(0), "operation", "The operation to use", ExpressionSupport.SUPPORTED, true, (MetadataType)this.typeBuilder.arrayType().id(List.class.getName()).of((TypeBuilder)this.typeBuilder.stringType().id(String.class.getName())).build(), null);
        this.assertParameter((ParameterDeclaration)parameters.get(1), "mtomEnabled", "Whether or not use MTOM for attachments", ExpressionSupport.SUPPORTED, false, this.typeLoader.load(Boolean.class), true);
        this.assertParameter((ParameterDeclaration)parameters.get(2), "callback", "async callback", ExpressionSupport.REQUIRED, true, this.typeLoader.load(OperationModel.class), null);
        List interceptorFactories = operation.getInterceptorFactories();
        Assert.assertThat((Object)operation.getInterceptorFactories(), (Matcher)Matchers.hasSize((int)2));
        Assert.assertThat((Object)((InterceptorFactory)interceptorFactories.get(0)).createInterceptor(), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.sameInstance((Object)this.testDeclaration.getOperationInterceptor1())));
        Assert.assertThat((Object)((InterceptorFactory)interceptorFactories.get(1)).createInterceptor(), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.sameInstance((Object)this.testDeclaration.getOperationInterceptor2())));
    }

    private void assertArgLessOperation(List<OperationDeclaration> operations) {
        OperationDeclaration operation = operations.get(2);
        Assert.assertThat((Object)operation.getName(), (Matcher)CoreMatchers.is((Object)"argLess"));
        Assert.assertThat((Object)operation.getDescription(), (Matcher)CoreMatchers.is((Object)"has no args"));
        Assert.assertThat((Object)operation.getExecutorFactory(), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.sameInstance((Object)this.testDeclaration.getArgLessExecutorFactory())));
        this.assertDataType(operation.getOutput().getType(), Integer.TYPE, NumberType.class);
        List parameters = operation.getParameters();
        Assert.assertThat((Object)parameters, (Matcher)CoreMatchers.is((Matcher)Matchers.notNullValue()));
        Assert.assertThat((Object)parameters.isEmpty(), (Matcher)CoreMatchers.is((Object)true));
        Assert.assertThat((Object)operation.getInterceptorFactories(), (Matcher)CoreMatchers.is((Matcher)Matchers.empty()));
    }

    private void assertModelProperties(BaseDeclaration<?> declaration, ModelProperty ... modelProperty) {
        List<ModelProperty> expected = Arrays.asList(modelProperty);
        Set properties = declaration.getModelProperties();
        Assert.assertThat((Object)properties, (Matcher)CoreMatchers.is((Matcher)CoreMatchers.not((Matcher)CoreMatchers.nullValue())));
        Assert.assertThat((Object)properties.size(), (Matcher)CoreMatchers.is((Object)expected.size()));
        expected.forEach(mp -> {
            Assert.assertThat((Object)properties.contains(mp), (Matcher)CoreMatchers.is((Object)true));
            Assert.assertThat(declaration.getModelProperty(mp.getClass()).get(), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.sameInstance((Object)mp)));
        });
    }
}

