/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.extension.api.introspection.declaration.fluent;

import com.mulesoft.mule.runtime.TestEeType;
import java.util.Set;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Test;
import org.mule.NonRuntimeTestType;
import org.mule.metadata.api.ClassTypeLoader;
import org.mule.metadata.api.model.MetadataType;
import org.mule.metadata.api.model.ObjectType;
import org.mule.metadata.java.api.utils.JavaTypeUtils;
import org.mule.runtime.extension.api.introspection.ExtensionModel;
import org.mule.runtime.extension.api.introspection.declaration.fluent.ExtensionDeclaration;
import org.mule.runtime.extension.api.introspection.declaration.fluent.ExtensionDeclarer;
import org.mule.runtime.extension.api.introspection.declaration.type.ExtensionsTypeLoaderFactory;

public class ExtensionDeclarerTestCase {
    private ExtensionDeclarer declarer = new ExtensionDeclarer();
    private ClassTypeLoader typeLoader = ExtensionsTypeLoaderFactory.getDefault().createTypeLoader();

    @Test
    public void withTypes() {
        this.declarer.withType((ObjectType)this.typeLoader.load(NonRuntimeTestType.class));
        Set types = ((ExtensionDeclaration)this.declarer.getDeclaration()).getTypes();
        Assert.assertThat((Object)types, (Matcher)Matchers.hasSize((int)1));
        ObjectType registeredType = (ObjectType)types.iterator().next();
        Assert.assertThat((Object)JavaTypeUtils.getType((MetadataType)registeredType), (Matcher)CoreMatchers.equalTo(NonRuntimeTestType.class));
    }

    @Test
    public void doNotDeclareObject() {
        this.assertNotDeclared(Object.class);
    }

    @Test
    public void doNotDeclareRuntimeClass() {
        this.assertNotDeclared(ExtensionModel.class);
    }

    @Test
    public void doNotDeclareEERuntimeClass() {
        this.assertNotDeclared(TestEeType.class);
    }

    private void assertNotDeclared(Class<?> type) {
        this.declarer.withType((ObjectType)this.typeLoader.load(type));
        Assert.assertThat((Object)((ExtensionDeclaration)this.declarer.getDeclaration()).getTypes(), (Matcher)Matchers.hasSize((int)0));
    }
}

