/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.extension.api.introspection.declaration.fluent.util;

import java.util.Arrays;
import java.util.concurrent.atomic.AtomicInteger;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.runners.MockitoJUnitRunner;
import org.mule.runtime.extension.api.introspection.declaration.fluent.ConfigurationDeclaration;
import org.mule.runtime.extension.api.introspection.declaration.fluent.ConnectedDeclaration;
import org.mule.runtime.extension.api.introspection.declaration.fluent.ConnectionProviderDeclaration;
import org.mule.runtime.extension.api.introspection.declaration.fluent.ExtensionDeclaration;
import org.mule.runtime.extension.api.introspection.declaration.fluent.OperationDeclaration;
import org.mule.runtime.extension.api.introspection.declaration.fluent.ParameterDeclaration;
import org.mule.runtime.extension.api.introspection.declaration.fluent.ParameterizedInterceptableDeclaration;
import org.mule.runtime.extension.api.introspection.declaration.fluent.SourceDeclaration;
import org.mule.runtime.extension.api.introspection.declaration.fluent.WithOperationsDeclaration;
import org.mule.runtime.extension.api.introspection.declaration.fluent.WithSourcesDeclaration;
import org.mule.runtime.extension.api.introspection.declaration.fluent.util.DeclarationWalker;

@RunWith(value=MockitoJUnitRunner.class)
public class DeclarationWalkerTestCase {
    @Mock
    private ExtensionDeclaration extension;
    @Mock
    private ConfigurationDeclaration configuration;
    @Mock
    private OperationDeclaration operation;
    @Mock
    private ConnectionProviderDeclaration connectionProvider;
    @Mock
    private ParameterDeclaration parameterModel;
    @Mock
    private SourceDeclaration source;

    @Before
    public void before() {
        Mockito.when((Object)this.extension.getConfigurations()).thenReturn(Arrays.asList(this.configuration));
        Mockito.when((Object)this.extension.getOperations()).thenReturn(Arrays.asList(this.operation));
        Mockito.when((Object)this.extension.getMessageSources()).thenReturn(Arrays.asList(this.source));
        Mockito.when((Object)this.extension.getConnectionProviders()).thenReturn(Arrays.asList(this.connectionProvider));
        Mockito.when((Object)this.configuration.getOperations()).thenReturn(Arrays.asList(this.operation));
        Mockito.when((Object)this.configuration.getMessageSources()).thenReturn(Arrays.asList(this.source));
        Mockito.when((Object)this.configuration.getConnectionProviders()).thenReturn(Arrays.asList(this.connectionProvider));
        this.addParameter(new ParameterizedInterceptableDeclaration[]{this.configuration, this.operation, this.connectionProvider, this.source});
    }

    private void addParameter(ParameterizedInterceptableDeclaration ... declarations) {
        for (ParameterizedInterceptableDeclaration declaration : declarations) {
            Mockito.when((Object)declaration.getParameters()).thenReturn(Arrays.asList(this.parameterModel));
        }
    }

    @Test
    public void walk() {
        final AtomicInteger configs = new AtomicInteger(0);
        final AtomicInteger operations = new AtomicInteger(0);
        final AtomicInteger sources = new AtomicInteger(0);
        final AtomicInteger parameters = new AtomicInteger(0);
        final AtomicInteger providers = new AtomicInteger(0);
        new DeclarationWalker(){

            public void onConfiguration(ConfigurationDeclaration declaration) {
                configs.incrementAndGet();
            }

            public void onOperation(WithOperationsDeclaration owner, OperationDeclaration declaration) {
                operations.incrementAndGet();
            }

            public void onConnectionProvider(ConnectedDeclaration owner, ConnectionProviderDeclaration declaration) {
                providers.incrementAndGet();
            }

            public void onSource(WithSourcesDeclaration owner, SourceDeclaration declaration) {
                sources.incrementAndGet();
            }

            public void onParameter(ParameterizedInterceptableDeclaration owner, ParameterDeclaration declaration) {
                parameters.incrementAndGet();
            }
        }.walk(this.extension);
        this.assertCount(configs, 1);
        this.assertCount(operations, 2);
        this.assertCount(sources, 2);
        this.assertCount(providers, 2);
        this.assertCount(parameters, 7);
    }

    private void assertCount(AtomicInteger actual, int expected) {
        Assert.assertThat((Object)actual.get(), (Matcher)CoreMatchers.is((Object)expected));
    }
}

