/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.extension.api.introspection.declaration.type;

import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Test;
import org.mule.metadata.api.ClassTypeLoader;
import org.mule.metadata.api.model.ObjectFieldType;
import org.mule.metadata.api.model.ObjectType;
import org.mule.metadata.api.model.StringType;
import org.mule.runtime.extension.api.annotation.Parameter;
import org.mule.runtime.extension.api.annotation.ParameterGroup;
import org.mule.runtime.extension.api.annotation.dsl.xml.XmlHints;
import org.mule.runtime.extension.api.annotation.param.display.Text;
import org.mule.runtime.extension.api.introspection.declaration.type.ExtensionsTypeLoaderFactory;
import org.mule.runtime.extension.api.introspection.declaration.type.annotation.FlattenedTypeAnnotation;
import org.mule.runtime.extension.api.introspection.declaration.type.annotation.TextTypeAnnotation;
import org.mule.runtime.extension.api.introspection.declaration.type.annotation.XmlHintsAnnotation;

public class ExtensionFieldHandlerTestCase {
    private ClassTypeLoader typeLoader = ExtensionsTypeLoaderFactory.getDefault().createTypeLoader();

    @Test
    public void interfaceWithGetter() {
        ObjectType type = (ObjectType)this.typeLoader.load(HasGetter.class);
        Assert.assertThat((Object)type.getFields(), (Matcher)Matchers.hasSize((int)0));
    }

    @Test
    public void xmlElementStyle() {
        ObjectType type = (ObjectType)this.typeLoader.load(NoRefType.class);
        Assert.assertThat((Object)type.getFields(), (Matcher)Matchers.hasSize((int)1));
        Assert.assertThat((Object)((ObjectFieldType)type.getFields().iterator().next()).getAnnotation(XmlHintsAnnotation.class).isPresent(), (Matcher)CoreMatchers.is((Object)true));
    }

    @Test
    public void flattenedField() {
        ObjectType type = (ObjectType)this.typeLoader.load(HasGroup.class);
        Assert.assertThat((Object)type.getFields().isEmpty(), (Matcher)CoreMatchers.is((Object)false));
        ObjectFieldType field = type.getFields().stream().filter(f -> f.getKey().getName().getLocalPart().equals("group")).findFirst().get();
        Assert.assertThat((Object)field.getAnnotation(FlattenedTypeAnnotation.class).isPresent(), (Matcher)CoreMatchers.is((Object)true));
        Assert.assertThat((Object)field.getValue(), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.instanceOf(ObjectType.class)));
    }

    @Test
    public void textField() {
        ObjectType type = (ObjectType)this.typeLoader.load(Group.class);
        Assert.assertThat((Object)type.getFields().isEmpty(), (Matcher)CoreMatchers.is((Object)false));
        ObjectFieldType field = type.getFields().stream().filter(f -> f.getKey().getName().getLocalPart().equals("text")).findFirst().get();
        Assert.assertThat((Object)field.getAnnotation(TextTypeAnnotation.class).isPresent(), (Matcher)CoreMatchers.is((Object)true));
        Assert.assertThat((Object)field.getValue(), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.instanceOf(StringType.class)));
    }

    public class Group {
        @Parameter
        @Text
        private String text;
    }

    public class HasGroup {
        @ParameterGroup
        private Group group;
    }

    public class NoRefType {
        @Parameter
        @XmlHints(allowReferences=false)
        private Object data;
    }

    static interface HasGetter {
        public String getSomeString();
    }
}

