/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.extension.api;

import org.mule.runtime.extension.api.introspection.ExtensionModel;
import org.mule.runtime.extension.api.introspection.config.ConfigurationModel;
import org.mule.runtime.extension.api.introspection.connection.ConnectionProviderModel;
import org.mule.runtime.extension.api.introspection.connection.HasConnectionProviderModels;
import org.mule.runtime.extension.api.introspection.operation.HasOperationModels;
import org.mule.runtime.extension.api.introspection.operation.OperationModel;
import org.mule.runtime.extension.api.introspection.parameter.ParameterModel;
import org.mule.runtime.extension.api.introspection.parameter.ParameterizedModel;
import org.mule.runtime.extension.api.introspection.source.HasSourceModels;
import org.mule.runtime.extension.api.introspection.source.SourceModel;

public abstract class ExtensionWalker {
    public final void walk(ExtensionModel extensionModel) {
        if (extensionModel == null) {
            throw new IllegalArgumentException("Cannot walk a null model");
        }
        extensionModel.getConfigurationModels().forEach(model -> {
            this.onConfiguration((ConfigurationModel)model);
            this.walkConnectionProviders((HasConnectionProviderModels)model);
            this.walkParameters((ParameterizedModel)model);
            this.walkSources((HasSourceModels)model);
            this.walkOperations((HasOperationModels)model);
        });
        this.walkConnectionProviders(extensionModel);
        this.walkSources(extensionModel);
        this.walkOperations(extensionModel);
    }

    public void onConfiguration(ConfigurationModel model) {
    }

    public void onOperation(HasOperationModels owner, OperationModel model) {
    }

    public void onConnectionProvider(HasConnectionProviderModels owner, ConnectionProviderModel model) {
    }

    public void onSource(HasSourceModels owner, SourceModel model) {
    }

    public void onParameter(ParameterizedModel owner, ParameterModel model) {
    }

    private void walkSources(HasSourceModels model) {
        model.getSourceModels().forEach(source -> {
            this.onSource(model, (SourceModel)source);
            this.walkParameters((ParameterizedModel)source);
        });
    }

    private void walkParameters(ParameterizedModel model) {
        model.getParameterModels().forEach(parameter -> this.onParameter(model, (ParameterModel)parameter));
    }

    private void walkConnectionProviders(HasConnectionProviderModels model) {
        model.getConnectionProviders().stream().forEach(provider -> {
            this.onConnectionProvider(model, (ConnectionProviderModel)provider);
            this.walkParameters((ParameterizedModel)provider);
        });
    }

    private void walkOperations(HasOperationModels model) {
        model.getOperationModels().stream().forEach(operation -> {
            this.onOperation(model, (OperationModel)operation);
            this.walkParameters((ParameterizedModel)operation);
        });
    }
}

