/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.extension.api;

import java.util.HashSet;
import java.util.Set;
import java.util.function.Consumer;
import org.mule.runtime.api.util.Reference;
import org.mule.runtime.extension.api.ExtensionWalker;
import org.mule.runtime.extension.api.introspection.connection.ConnectionProviderModel;
import org.mule.runtime.extension.api.introspection.connection.HasConnectionProviderModels;
import org.mule.runtime.extension.api.introspection.operation.HasOperationModels;
import org.mule.runtime.extension.api.introspection.operation.OperationModel;
import org.mule.runtime.extension.api.introspection.parameter.ParameterModel;
import org.mule.runtime.extension.api.introspection.parameter.ParameterizedModel;
import org.mule.runtime.extension.api.introspection.source.HasSourceModels;
import org.mule.runtime.extension.api.introspection.source.SourceModel;

public abstract class IdempotentExtensionWalker
extends ExtensionWalker {
    private Set<Reference<SourceModel>> sources = new HashSet<Reference<SourceModel>>();
    private Set<Reference<ParameterModel>> parameters = new HashSet<Reference<ParameterModel>>();
    private Set<Reference<OperationModel>> operations = new HashSet<Reference<OperationModel>>();
    private Set<Reference<ConnectionProviderModel>> connectionProviders = new HashSet<Reference<ConnectionProviderModel>>();

    private <T> boolean isFirstAppearance(Set<Reference<T>> accumulator, T item) {
        return accumulator.add(new Reference(item));
    }

    @Override
    public final void onSource(HasSourceModels owner, SourceModel model) {
        this.doOnce(this.sources, model, this::onSource);
    }

    @Override
    public final void onParameter(ParameterizedModel owner, ParameterModel model) {
        this.doOnce(this.parameters, model, this::onParameter);
    }

    @Override
    public final void onOperation(HasOperationModels owner, OperationModel model) {
        this.doOnce(this.operations, model, this::onOperation);
    }

    @Override
    public final void onConnectionProvider(HasConnectionProviderModels owner, ConnectionProviderModel model) {
        this.doOnce(this.connectionProviders, model, this::onConnectionProvider);
    }

    private <T> void doOnce(Set<Reference<T>> accumulator, T item, Consumer<T> delegate) {
        if (this.isFirstAppearance(accumulator, item)) {
            delegate.accept(item);
        }
    }

    protected void onConnectionProvider(ConnectionProviderModel model) {
    }

    protected void onSource(SourceModel model) {
    }

    protected void onParameter(ParameterModel model) {
    }

    protected void onOperation(OperationModel model) {
    }
}

