/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.extension.api.introspection;

import com.google.common.collect.HashMultiset;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Multiset;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import org.mule.runtime.extension.api.exception.IllegalModelDefinitionException;
import org.mule.runtime.extension.api.introspection.AbstractNamedImmutableModel;
import org.mule.runtime.extension.api.introspection.Described;
import org.mule.runtime.extension.api.introspection.ModelProperty;
import org.mule.runtime.extension.api.introspection.Named;
import org.mule.runtime.extension.api.introspection.connection.ConnectionProviderModel;
import org.mule.runtime.extension.api.introspection.connection.HasConnectionProviderModels;
import org.mule.runtime.extension.api.introspection.operation.HasOperationModels;
import org.mule.runtime.extension.api.introspection.operation.OperationModel;
import org.mule.runtime.extension.api.introspection.source.HasSourceModels;
import org.mule.runtime.extension.api.introspection.source.SourceModel;

public abstract class AbstractComplexModel
extends AbstractNamedImmutableModel
implements HasConnectionProviderModels,
HasSourceModels,
HasOperationModels {
    private final List<OperationModel> operations;
    private final List<ConnectionProviderModel> connectionProviders;
    private final List<SourceModel> messageSources;

    public AbstractComplexModel(String name, String description, List<OperationModel> operationModels, List<ConnectionProviderModel> connectionProviders, List<SourceModel> sourceModels, Set<ModelProperty> modelProperties) {
        super(name, description, modelProperties);
        this.operations = this.unique(operationModels, "Operations");
        this.connectionProviders = this.unique(connectionProviders, "Connection Providers");
        this.messageSources = this.unique(sourceModels, "Message Sources");
    }

    @Override
    public List<OperationModel> getOperationModels() {
        return this.operations;
    }

    @Override
    public List<SourceModel> getSourceModels() {
        return this.messageSources;
    }

    @Override
    public Optional<SourceModel> getSourceModel(String name) {
        return this.findModel(this.messageSources, name);
    }

    @Override
    public Optional<ConnectionProviderModel> getConnectionProviderModel(String name) {
        return this.findModel(this.connectionProviders, name);
    }

    @Override
    public Optional<OperationModel> getOperationModel(String name) {
        return this.findModel(this.operations, name);
    }

    @Override
    public List<ConnectionProviderModel> getConnectionProviders() {
        return this.connectionProviders;
    }

    protected <T extends Named> Optional<T> findModel(Collection<T> values, String name) {
        return values.stream().filter(v -> v.getName().equals(name)).findFirst();
    }

    protected <T extends Described> List<T> toList(Collection<T> collection) {
        if (collection == null || collection.isEmpty()) {
            return Collections.emptyList();
        }
        return Collections.unmodifiableList(new ArrayList<T>(collection));
    }

    protected <T extends Named> List<T> unique(Collection<T> values, String identifier) {
        HashMultiset names = HashMultiset.create();
        values.stream().map(Named::getName).forEach(arg_0 -> ((Multiset)names).add(arg_0));
        List invalid = names.entrySet().stream().filter(entry -> entry.getCount() > 1).map(Multiset.Entry::getElement).collect(Collectors.toList());
        if (!invalid.isEmpty()) {
            throw new IllegalModelDefinitionException(String.format("%s %s were defined multiple times", identifier, invalid));
        }
        return ImmutableList.copyOf(values);
    }
}

