/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.extension.api.introspection;

import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Optional;
import java.util.Set;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.mule.runtime.extension.api.introspection.Described;
import org.mule.runtime.extension.api.introspection.EnrichableModel;
import org.mule.runtime.extension.api.introspection.ModelProperty;
import org.mule.runtime.extension.internal.util.HierarchyClassMap;

public abstract class AbstractImmutableModel
implements Described,
EnrichableModel {
    private final String description;
    private final HierarchyClassMap<ModelProperty> modelProperties = new HierarchyClassMap();

    protected AbstractImmutableModel(String description, Set<ModelProperty> modelProperties) {
        this.description = description != null ? description : "";
        this.loadProperties(modelProperties);
    }

    protected static void checkArgument(boolean condition, String message) {
        if (!condition) {
            throw new IllegalArgumentException(message);
        }
    }

    @Override
    public final String getDescription() {
        return this.description;
    }

    @Override
    public <T extends ModelProperty> Optional<T> getModelProperty(Class<T> propertyType) {
        AbstractImmutableModel.checkArgument(propertyType != null, "Cannot get model properties of a null type");
        return Optional.ofNullable(this.modelProperties.get(propertyType));
    }

    @Override
    public Set<ModelProperty> getModelProperties() {
        return Collections.unmodifiableSet(new HashSet<ModelProperty>(this.modelProperties.values()));
    }

    public String toString() {
        return ToStringBuilder.reflectionToString((Object)this);
    }

    private void loadProperties(Collection<ModelProperty> properties) {
        if (properties != null) {
            properties.forEach(property -> this.modelProperties.put(property.getClass(), (ModelProperty)property));
        }
    }
}

