/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.extension.api.introspection.declaration.fluent;

import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import org.mule.runtime.extension.api.introspection.Described;
import org.mule.runtime.extension.api.introspection.ModelProperty;

public abstract class BaseDeclaration<T extends BaseDeclaration>
implements Described {
    private final Map<Class<? extends ModelProperty>, ModelProperty> modelProperties = new HashMap<Class<? extends ModelProperty>, ModelProperty>();
    private String description = "";

    public Set<ModelProperty> getModelProperties() {
        return Collections.unmodifiableSet(new HashSet<ModelProperty>(this.modelProperties.values()));
    }

    public <P extends ModelProperty> Optional<P> getModelProperty(Class<P> propertyType) {
        return Optional.ofNullable(this.modelProperties.get(propertyType));
    }

    public T addModelProperty(ModelProperty modelProperty) {
        if (modelProperty == null) {
            throw new IllegalArgumentException("Cannot add a null model property");
        }
        this.modelProperties.put(modelProperty.getClass(), modelProperty);
        return (T)this;
    }

    @Override
    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }
}

