/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.extension.api.introspection.operation;

import java.beans.Transient;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import org.mule.runtime.extension.api.introspection.ModelProperty;
import org.mule.runtime.extension.api.introspection.OutputModel;
import org.mule.runtime.extension.api.introspection.exception.ExceptionEnricherFactory;
import org.mule.runtime.extension.api.introspection.metadata.MetadataResolverFactory;
import org.mule.runtime.extension.api.introspection.operation.ImmutableOperationModel;
import org.mule.runtime.extension.api.introspection.operation.RuntimeOperationModel;
import org.mule.runtime.extension.api.introspection.parameter.ParameterModel;
import org.mule.runtime.extension.api.runtime.InterceptorFactory;
import org.mule.runtime.extension.api.runtime.operation.OperationExecutorFactory;

public final class ImmutableRuntimeOperationModel
extends ImmutableOperationModel
implements RuntimeOperationModel {
    private final transient OperationExecutorFactory executorFactory;
    private final transient Optional<ExceptionEnricherFactory> exceptionEnricherFactory;
    private final transient List<InterceptorFactory> interceptorFactories;
    private final MetadataResolverFactory metadataResolverFactory;

    public ImmutableRuntimeOperationModel(String name, String description, OperationExecutorFactory executorFactory, List<ParameterModel> parameterModels, OutputModel output, OutputModel outputAttributes, Set<ModelProperty> modelProperties, List<InterceptorFactory> interceptorFactories, Optional<ExceptionEnricherFactory> exceptionEnricherFactory, MetadataResolverFactory metadataResolverFactory) {
        super(name, description, parameterModels, output, outputAttributes, modelProperties);
        if (executorFactory == null) {
            throw new IllegalArgumentException(String.format("Operation '%s' cannot have a null executor factory", name));
        }
        this.executorFactory = executorFactory;
        this.exceptionEnricherFactory = exceptionEnricherFactory;
        this.interceptorFactories = interceptorFactories != null ? Collections.unmodifiableList(interceptorFactories) : Collections.emptyList();
        this.metadataResolverFactory = metadataResolverFactory;
    }

    @Override
    @Transient
    public OperationExecutorFactory getExecutor() {
        return this.executorFactory;
    }

    @Override
    @Transient
    public Optional<ExceptionEnricherFactory> getExceptionEnricherFactory() {
        return this.exceptionEnricherFactory;
    }

    @Override
    @Transient
    public List<InterceptorFactory> getInterceptorFactories() {
        return this.interceptorFactories;
    }

    @Override
    @Transient
    public MetadataResolverFactory getMetadataResolverFactory() {
        return this.metadataResolverFactory;
    }
}

