/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.extension.api.introspection.source;

import java.beans.Transient;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import org.mule.runtime.extension.api.introspection.ModelProperty;
import org.mule.runtime.extension.api.introspection.OutputModel;
import org.mule.runtime.extension.api.introspection.exception.ExceptionEnricherFactory;
import org.mule.runtime.extension.api.introspection.metadata.MetadataResolverFactory;
import org.mule.runtime.extension.api.introspection.parameter.ParameterModel;
import org.mule.runtime.extension.api.introspection.source.ImmutableSourceModel;
import org.mule.runtime.extension.api.introspection.source.RuntimeSourceModel;
import org.mule.runtime.extension.api.runtime.InterceptorFactory;
import org.mule.runtime.extension.api.runtime.source.SourceFactory;

public final class ImmutableRuntimeSourceModel
extends ImmutableSourceModel
implements RuntimeSourceModel {
    private final transient SourceFactory sourceFactory;
    private final transient Optional<ExceptionEnricherFactory> exceptionEnricherFactory;
    private final transient MetadataResolverFactory metadataResolverFactory;
    private final transient List<InterceptorFactory> interceptorFactories;

    public ImmutableRuntimeSourceModel(String name, String description, List<ParameterModel> parameterModels, OutputModel output, OutputModel outputAttributes, SourceFactory sourceFactory, Set<ModelProperty> modelProperties, List<InterceptorFactory> interceptorFactories, Optional<ExceptionEnricherFactory> exceptionEnricherFactory, MetadataResolverFactory metadataResolverFactory) {
        super(name, description, parameterModels, output, outputAttributes, modelProperties);
        if (sourceFactory == null) {
            throw new IllegalArgumentException(String.format("Source '%s' cannot have a null source factory", name));
        }
        this.sourceFactory = sourceFactory;
        this.exceptionEnricherFactory = exceptionEnricherFactory;
        this.metadataResolverFactory = metadataResolverFactory;
        this.interceptorFactories = interceptorFactories != null ? Collections.unmodifiableList(interceptorFactories) : Collections.emptyList();
    }

    @Override
    @Transient
    public SourceFactory getSourceFactory() {
        return this.sourceFactory;
    }

    @Override
    @Transient
    public Optional<ExceptionEnricherFactory> getExceptionEnricherFactory() {
        return this.exceptionEnricherFactory;
    }

    @Override
    @Transient
    public List<InterceptorFactory> getInterceptorFactories() {
        return this.interceptorFactories;
    }

    @Override
    @Transient
    public MetadataResolverFactory getMetadataResolverFactory() {
        return this.metadataResolverFactory;
    }
}

