/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.extension.api.runtime.operation;

import java.util.ServiceLoader;
import org.mule.runtime.api.message.Attributes;
import org.mule.runtime.extension.api.runtime.operation.OperationResult;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class OperationResultBuilderFactory {
    private static final Logger LOGGER = LoggerFactory.getLogger(OperationResultBuilderFactory.class);
    private static final OperationResultBuilderFactory DEFAULT_FACTORY;

    public static final OperationResultBuilderFactory getDefaultFactory() {
        return DEFAULT_FACTORY;
    }

    public abstract <Output, A extends Attributes> OperationResult.Builder<Output, A> create();

    static {
        try {
            OperationResultBuilderFactory factory = ServiceLoader.load(OperationResultBuilderFactory.class).iterator().next();
            LOGGER.info(String.format("Loaded %s implementation '%s' form classloader '%s'", OperationResultBuilderFactory.class.getSimpleName(), factory.getClass().getName(), factory.getClass().getClassLoader().toString()));
            DEFAULT_FACTORY = factory;
        }
        catch (Exception e) {
            LOGGER.error(String.format("Error loading %s implementation.", OperationResultBuilderFactory.class.getSimpleName()), (Throwable)e);
            throw e;
        }
    }
}

