/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.extension.api.util;

import java.util.LinkedList;
import java.util.List;
import java.util.stream.Collectors;
import org.mule.runtime.extension.api.ExtensionWalker;
import org.mule.runtime.extension.api.IdempotentExtensionWalker;
import org.mule.runtime.extension.api.introspection.ComponentModel;
import org.mule.runtime.extension.api.introspection.EnrichableModel;
import org.mule.runtime.extension.api.introspection.ExtensionModel;
import org.mule.runtime.extension.api.introspection.Named;
import org.mule.runtime.extension.api.introspection.config.ConfigurationModel;
import org.mule.runtime.extension.api.introspection.operation.HasOperationModels;
import org.mule.runtime.extension.api.introspection.operation.OperationModel;
import org.mule.runtime.extension.api.introspection.parameter.ExpressionSupport;
import org.mule.runtime.extension.api.introspection.parameter.ParameterModel;
import org.mule.runtime.extension.api.introspection.parameter.ParameterizedModel;
import org.mule.runtime.extension.api.introspection.property.ConfigTypeModelProperty;
import org.mule.runtime.extension.api.introspection.property.ConnectivityModelProperty;
import org.mule.runtime.extension.api.introspection.property.PagedOperationModelProperty;
import org.mule.runtime.extension.api.introspection.source.HasSourceModels;
import org.mule.runtime.extension.api.introspection.source.SourceModel;

public class ExtensionModelUtils {
    private ExtensionModelUtils() {
    }

    public static List<ParameterModel> getDynamicParameters(ParameterizedModel model) {
        return model.getParameterModels().stream().filter(parameter -> ExtensionModelUtils.acceptsExpressions(parameter.getExpressionSupport())).collect(Collectors.toList());
    }

    public static boolean acceptsExpressions(ExpressionSupport support) {
        return support == ExpressionSupport.SUPPORTED || support == ExpressionSupport.REQUIRED;
    }

    public static List<ComponentModel> getConnectedComponents(ExtensionModel extensionModel) {
        final LinkedList<ComponentModel> connectedModels = new LinkedList<ComponentModel>();
        new IdempotentExtensionWalker(){

            @Override
            public void onOperation(OperationModel model) {
                this.collect(model);
            }

            @Override
            public void onSource(SourceModel model) {
                this.collect(model);
            }

            private void collect(EnrichableModel model) {
                if (ExtensionModelUtils.isConnected(model)) {
                    connectedModels.add((ComponentModel)model);
                }
            }
        }.walk(extensionModel);
        return connectedModels;
    }

    public static List<ComponentModel> getConnectedComponents(ExtensionModel extensionModel, final ConfigurationModel configurationModel) {
        final LinkedList<ComponentModel> connectedModels = new LinkedList<ComponentModel>();
        new ExtensionWalker(){

            @Override
            public void onOperation(HasOperationModels owner, OperationModel model) {
                if (owner == configurationModel) {
                    this.collect(owner, model);
                }
            }

            @Override
            public void onSource(HasSourceModels owner, SourceModel model) {
                this.collect(owner, model);
            }

            private void collect(Object owner, EnrichableModel model) {
                if (owner == configurationModel && ExtensionModelUtils.isConnected(model)) {
                    connectedModels.add((ComponentModel)model);
                }
            }
        }.walk(extensionModel);
        return connectedModels;
    }

    public static boolean requiresConfig(Named component) {
        if (component instanceof EnrichableModel) {
            EnrichableModel model = (EnrichableModel)((Object)component);
            return model.getModelProperty(ConfigTypeModelProperty.class).isPresent() || ExtensionModelUtils.isConnected(model);
        }
        return false;
    }

    public static boolean isConnected(EnrichableModel component) {
        return component.getModelProperty(ConnectivityModelProperty.class).isPresent() || component.getModelProperty(PagedOperationModelProperty.class).isPresent();
    }
}

