/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.extension.api.util;

import com.google.common.collect.ImmutableList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.mule.metadata.api.model.MetadataType;
import org.mule.metadata.utils.MetadataTypeUtils;

public class SubTypesMappingContainer {
    private final Map<MetadataType, List<MetadataType>> subTypesMapping;
    private final Map<String, List<MetadataType>> subTypesById;

    public SubTypesMappingContainer(Map<MetadataType, List<MetadataType>> subTypesMapping) {
        this.subTypesMapping = subTypesMapping;
        this.subTypesById = subTypesMapping.entrySet().stream().filter(e -> MetadataTypeUtils.getTypeId((MetadataType)((MetadataType)e.getKey())).isPresent()).collect(Collectors.toMap(e -> (String)MetadataTypeUtils.getTypeId((MetadataType)((MetadataType)e.getKey())).get(), Map.Entry::getValue));
    }

    public List<MetadataType> getSubTypes(MetadataType type) {
        List<MetadataType> subTypes = MetadataTypeUtils.getTypeId((MetadataType)type).map(this.subTypesById::get).orElse(this.subTypesMapping.get(type));
        return subTypes != null ? ImmutableList.copyOf(subTypes) : ImmutableList.of();
    }

    public List<MetadataType> getSuperTypes(MetadataType type) {
        ImmutableList.Builder builder = ImmutableList.builder();
        this.subTypesMapping.entrySet().stream().filter(entry -> ((List)entry.getValue()).contains(type)).forEach(entry -> {
            builder.add(entry.getKey());
            builder.addAll(this.getSuperTypes((MetadataType)entry.getKey()));
        });
        return builder.build();
    }

    public boolean containsBaseType(MetadataType type) {
        return MetadataTypeUtils.getTypeId((MetadataType)type).map(this.subTypesById::get).orElse(this.subTypesMapping.get(type)) != null;
    }

    public List<MetadataType> getAllSubTypes() {
        return this.subTypesMapping.values().stream().flatMap(Collection::stream).collect(Collectors.toList());
    }

    public List<MetadataType> getAllBaseTypes() {
        return ImmutableList.copyOf(this.subTypesMapping.keySet());
    }
}

