/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.extension.api.declaration.type;

import java.lang.reflect.Field;
import java.util.Collection;
import java.util.LinkedList;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.mule.metadata.api.model.MetadataType;
import org.mule.runtime.api.meta.ExpressionSupport;
import org.mule.runtime.api.meta.model.display.LayoutModel;
import org.mule.runtime.api.meta.model.parameter.ParameterRole;
import org.mule.runtime.extension.api.annotation.Alias;
import org.mule.runtime.extension.api.annotation.Ignore;
import org.mule.runtime.extension.api.annotation.param.Parameter;
import org.mule.runtime.extension.api.annotation.param.ParameterGroup;
import org.mule.runtime.extension.api.declaration.type.annotation.ExpressionSupportAnnotation;
import org.mule.runtime.extension.api.declaration.type.annotation.InfrastructureTypeAnnotation;
import org.mule.runtime.extension.api.declaration.type.annotation.LayoutTypeAnnotation;
import org.mule.runtime.extension.api.declaration.type.annotation.ParameterRoleAnnotation;
import org.mule.runtime.extension.api.declaration.type.annotation.XmlHintsAnnotation;
import org.mule.runtime.extension.api.util.ExtensionModelUtils;

public final class TypeUtils {
    private TypeUtils() {
    }

    public static Collection<Field> getParameterFields(Class<?> declaringType) {
        return TypeUtils.getAllFields(declaringType).stream().filter(field -> (field.getAnnotation(Parameter.class) != null || field.getAnnotation(ParameterGroup.class) != null) && field.getAnnotation(Ignore.class) == null).collect(Collectors.toList());
    }

    public static Collection<Field> getAllFields(Class<?> declaringType) {
        return TypeUtils.getAllSuperClasses(declaringType).stream().flatMap(type -> Stream.of(type.getDeclaredFields())).collect(Collectors.toList());
    }

    public static Collection<Class<?>> getAllSuperClasses(Class<?> type) {
        LinkedList result = new LinkedList();
        if (type != null && !type.equals(Object.class)) {
            result.add(type);
            result.addAll(TypeUtils.getAllSuperClasses(type.getSuperclass()));
        }
        return result;
    }

    public static String getAlias(Field field) {
        Alias alias = field.getAnnotation(Alias.class);
        String name = alias != null ? alias.value() : null;
        return name == null || name.length() == 0 ? field.getName() : name;
    }

    public static ExpressionSupport getExpressionSupport(MetadataType metadataType) {
        return metadataType.getAnnotation(ExpressionSupportAnnotation.class).map(ExpressionSupportAnnotation::getExpressionSupport).orElse(ExpressionSupport.SUPPORTED);
    }

    public static ParameterRole getParameterRole(MetadataType metadataType) {
        return metadataType.getAnnotation(ParameterRoleAnnotation.class).map(ParameterRoleAnnotation::getRole).orElse(ParameterRole.BEHAVIOUR);
    }

    public static boolean isContent(MetadataType type) {
        return ExtensionModelUtils.isContent(TypeUtils.getParameterRole(type));
    }

    public static Optional<LayoutModel> getLayoutModel(MetadataType metadataType) {
        if (metadataType.getAnnotation(LayoutTypeAnnotation.class).isPresent()) {
            LayoutTypeAnnotation layoutTypeAnnotation = (LayoutTypeAnnotation)metadataType.getAnnotation(LayoutTypeAnnotation.class).get();
            return Optional.of(layoutTypeAnnotation.getLayoutModel());
        }
        return Optional.empty();
    }

    public static boolean isInfrastructure(MetadataType type) {
        return type.getAnnotation(InfrastructureTypeAnnotation.class).isPresent();
    }

    public static boolean acceptsReferences(MetadataType metadataType) {
        return metadataType.getAnnotation(XmlHintsAnnotation.class).map(XmlHintsAnnotation::allowsReferences).orElse(true);
    }
}

