/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.extension.api.model.source;

import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import org.mule.runtime.api.meta.model.ModelProperty;
import org.mule.runtime.api.meta.model.OutputModel;
import org.mule.runtime.api.meta.model.display.DisplayModel;
import org.mule.runtime.api.meta.model.error.ErrorModel;
import org.mule.runtime.api.meta.model.parameter.ParameterGroupModel;
import org.mule.runtime.api.meta.model.source.SourceCallbackModel;
import org.mule.runtime.api.meta.model.source.SourceModel;
import org.mule.runtime.api.metadata.descriptor.InputMetadataDescriptor;
import org.mule.runtime.api.metadata.descriptor.OutputMetadataDescriptor;
import org.mule.runtime.extension.api.model.AbstractComponentModel;
import org.mule.runtime.extension.api.util.ExtensionModelUtils;

public class ImmutableSourceModel
extends AbstractComponentModel<SourceModel>
implements SourceModel {
    private final boolean hasResponse;
    private final SourceCallbackModel successCallback;
    private final SourceCallbackModel errorCallback;

    public ImmutableSourceModel(String name, String description, boolean hasResponse, List<ParameterGroupModel> parameterGroupModels, OutputModel output, OutputModel outputAttributes, Optional<SourceCallbackModel> successCallbackModel, Optional<SourceCallbackModel> errorCallbackModel, boolean requiresConnection, boolean transactional, DisplayModel displayModel, Set<ModelProperty> modelProperties) {
        super(name, description, parameterGroupModels, output, outputAttributes, requiresConnection, transactional, displayModel, modelProperties);
        this.hasResponse = hasResponse;
        this.successCallback = successCallbackModel.orElse(null);
        this.errorCallback = errorCallbackModel.orElse(null);
    }

    public boolean hasResponse() {
        return this.hasResponse;
    }

    public Optional<SourceCallbackModel> getSuccessCallback() {
        return Optional.ofNullable(this.successCallback);
    }

    public Optional<SourceCallbackModel> getErrorCallback() {
        return Optional.ofNullable(this.errorCallback);
    }

    public Set<ErrorModel> getErrorModels() {
        return Collections.emptySet();
    }

    public SourceModel getTypedModel(InputMetadataDescriptor inputMetadataDescriptor, OutputMetadataDescriptor outputMetadataDescriptor) {
        OutputModel typedOutputModel = ExtensionModelUtils.resolveOutputModelType(this.getOutput(), outputMetadataDescriptor.getPayloadMetadata());
        OutputModel typedAttributesModel = ExtensionModelUtils.resolveOutputModelType(this.getOutputAttributes(), outputMetadataDescriptor.getAttributesMetadata());
        return new ImmutableSourceModel(this.getName(), this.getDescription(), this.hasResponse(), ExtensionModelUtils.resolveParameterGroupModelType(this.getParameterGroupModels(), inputMetadataDescriptor.getAllParameters()), typedOutputModel, typedAttributesModel, ExtensionModelUtils.resolveSourceCallbackType(this.getSuccessCallback(), inputMetadataDescriptor.getAllParameters()), ExtensionModelUtils.resolveSourceCallbackType(this.getErrorCallback(), inputMetadataDescriptor.getAllParameters()), this.requiresConnection(), this.isTransactional(), this.getDisplayModel().orElse(null), this.getModelProperties());
    }
}

