/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.extension.api.util;

import java.lang.reflect.Modifier;
import java.util.Map;
import org.mule.metadata.api.annotation.TypeAliasAnnotation;
import org.mule.metadata.api.annotation.TypeIdAnnotation;
import org.mule.metadata.api.model.MetadataFormat;
import org.mule.metadata.api.model.MetadataType;
import org.mule.metadata.api.model.ObjectFieldType;
import org.mule.metadata.api.utils.MetadataTypeUtils;
import org.mule.metadata.java.api.annotation.ClassInformationAnnotation;
import org.mule.metadata.java.api.utils.JavaTypeUtils;
import org.mule.runtime.extension.api.annotation.Alias;
import org.mule.runtime.extension.api.declaration.type.annotation.FlattenedTypeAnnotation;
import org.mule.runtime.extension.api.util.NameUtils;

public final class ExtensionMetadataTypeUtils {
    private ExtensionMetadataTypeUtils() {
    }

    public static String getAlias(ObjectFieldType fieldType) {
        return fieldType.getAnnotation(TypeAliasAnnotation.class).map(TypeAliasAnnotation::getValue).orElse(MetadataTypeUtils.getLocalPart((ObjectFieldType)fieldType));
    }

    public static String getAlias(MetadataType metadataType) {
        return metadataType.getAnnotation(TypeAliasAnnotation.class).map(TypeAliasAnnotation::getValue).orElse(metadataType.getMetadataFormat().equals((Object)MetadataFormat.JAVA) ? NameUtils.getAliasName(JavaTypeUtils.getType((MetadataType)metadataType)) : "");
    }

    public static String getAlias(MetadataType metadataType, String defaultName) {
        return metadataType.getAnnotation(TypeAliasAnnotation.class).map(TypeAliasAnnotation::getValue).orElse(metadataType.getMetadataFormat().equals((Object)MetadataFormat.JAVA) ? NameUtils.getAliasName(defaultName, JavaTypeUtils.getType((MetadataType)metadataType).getAnnotation(Alias.class)) : defaultName);
    }

    public static boolean isFinal(MetadataType metadataType) {
        try {
            return metadataType.getAnnotation(ClassInformationAnnotation.class).map(ClassInformationAnnotation::isFinal).orElse(metadataType.getMetadataFormat().equals((Object)MetadataFormat.JAVA) && Modifier.isFinal(JavaTypeUtils.getType((MetadataType)metadataType).getModifiers()));
        }
        catch (Exception e) {
            return false;
        }
    }

    public static boolean isMap(MetadataType metadataType) {
        if (metadataType.getAnnotation(TypeIdAnnotation.class).isPresent() && Map.class.getName().equals(((TypeIdAnnotation)metadataType.getAnnotation(TypeIdAnnotation.class).get()).getValue())) {
            return true;
        }
        return metadataType.getAnnotation(ClassInformationAnnotation.class).map(classInformationAnnotation -> classInformationAnnotation.getImplementedInterfaces().contains(Map.class.getName())).orElse(false);
    }

    public static String getId(MetadataType metadataType) {
        try {
            return MetadataTypeUtils.getTypeId((MetadataType)metadataType).orElse(metadataType.getMetadataFormat().equals((Object)MetadataFormat.JAVA) ? JavaTypeUtils.getType((MetadataType)metadataType).getName() : "");
        }
        catch (Exception e) {
            return "";
        }
    }

    public static boolean isParameterGroup(MetadataType type) {
        return type.getAnnotation(FlattenedTypeAnnotation.class).isPresent();
    }
}

