/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.extension.api.util;

import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import org.mule.metadata.api.model.MetadataType;
import org.mule.metadata.api.model.ObjectType;
import org.mule.metadata.api.model.UnionType;
import org.mule.metadata.api.utils.MetadataTypeUtils;
import org.mule.metadata.api.visitor.MetadataTypeVisitor;
import org.mule.runtime.api.meta.ExpressionSupport;
import org.mule.runtime.api.meta.NamedObject;
import org.mule.runtime.api.meta.model.ComponentModel;
import org.mule.runtime.api.meta.model.ExtensionModel;
import org.mule.runtime.api.meta.model.OutputModel;
import org.mule.runtime.api.meta.model.SubTypesModel;
import org.mule.runtime.api.meta.model.config.ConfigurationModel;
import org.mule.runtime.api.meta.model.operation.HasOperationModels;
import org.mule.runtime.api.meta.model.operation.OperationModel;
import org.mule.runtime.api.meta.model.parameter.ParameterGroupModel;
import org.mule.runtime.api.meta.model.parameter.ParameterModel;
import org.mule.runtime.api.meta.model.parameter.ParameterRole;
import org.mule.runtime.api.meta.model.parameter.ParameterizedModel;
import org.mule.runtime.api.meta.model.source.HasSourceModels;
import org.mule.runtime.api.meta.model.source.SourceCallbackModel;
import org.mule.runtime.api.meta.model.source.SourceModel;
import org.mule.runtime.api.meta.model.util.ExtensionWalker;
import org.mule.runtime.api.meta.model.util.IdempotentExtensionWalker;
import org.mule.runtime.api.metadata.descriptor.ParameterMetadataDescriptor;
import org.mule.runtime.api.metadata.descriptor.TypeMetadataDescriptor;
import org.mule.runtime.api.util.Preconditions;
import org.mule.runtime.api.util.Reference;
import org.mule.runtime.extension.api.annotation.param.Content;
import org.mule.runtime.extension.api.model.ImmutableOutputModel;
import org.mule.runtime.extension.api.model.parameter.ImmutableParameterGroupModel;
import org.mule.runtime.extension.api.model.parameter.ImmutableParameterModel;
import org.mule.runtime.extension.api.model.source.ImmutableSourceCallbackModel;
import org.mule.runtime.extension.internal.property.InfrastructureParameterModelProperty;

public class ExtensionModelUtils {
    private ExtensionModelUtils() {
    }

    public static Optional<String> getDefaultValue(ParameterModel model) {
        Object defaultValue = model.getDefaultValue();
        return defaultValue == null ? Optional.empty() : Optional.of(String.valueOf(defaultValue));
    }

    public static Optional<String> getDefaultValue(final String name, MetadataType model) {
        final Reference value = new Reference();
        model.accept(new MetadataTypeVisitor(){

            protected void defaultVisit(MetadataType metadataType) {
                MetadataTypeUtils.getDefaultValue((MetadataType)metadataType).ifPresent(arg_0 -> ((Reference)value).set(arg_0));
            }

            public void visitObject(ObjectType objectType) {
                objectType.getFields().stream().filter(f -> f.getKey().getName().getLocalPart().equals(name)).findFirst().ifPresent(fieldType -> MetadataTypeUtils.getDefaultValue((MetadataType)fieldType).ifPresent(arg_0 -> ((Reference)value).set(arg_0)));
            }

            public void visitUnion(UnionType unionType) {
                unionType.getTypes().stream().map(type -> ExtensionModelUtils.getDefaultValue(name, type)).filter(Optional::isPresent).findFirst().ifPresent(defaultValue -> {
                    String cfr_ignored_0 = (String)value.set(defaultValue.get());
                });
            }
        });
        return Optional.ofNullable(value.get());
    }

    public static List<ParameterModel> getDynamicParameters(ParameterizedModel model) {
        return model.getAllParameterModels().stream().filter(parameter -> ExtensionModelUtils.acceptsExpressions(parameter.getExpressionSupport())).collect(Collectors.toList());
    }

    public static boolean acceptsExpressions(ExpressionSupport support) {
        return support == ExpressionSupport.SUPPORTED || support == ExpressionSupport.REQUIRED;
    }

    public static List<ComponentModel> getConnectedComponents(ExtensionModel extensionModel) {
        final LinkedList<ComponentModel> connectedModels = new LinkedList<ComponentModel>();
        new IdempotentExtensionWalker(){

            public void onOperation(OperationModel model) {
                this.collect((ComponentModel)model);
            }

            public void onSource(SourceModel model) {
                this.collect((ComponentModel)model);
            }

            private void collect(ComponentModel model) {
                if (model.requiresConnection()) {
                    connectedModels.add(model);
                }
            }
        }.walk(extensionModel);
        return connectedModels;
    }

    public static List<ComponentModel> getConnectedComponents(ExtensionModel extensionModel, final ConfigurationModel configurationModel) {
        final LinkedList<ComponentModel> connectedModels = new LinkedList<ComponentModel>();
        new ExtensionWalker(){

            public void onOperation(HasOperationModels owner, OperationModel model) {
                if (owner == configurationModel) {
                    this.collect(owner, (ComponentModel)model);
                }
            }

            public void onSource(HasSourceModels owner, SourceModel model) {
                this.collect(owner, (ComponentModel)model);
            }

            private void collect(Object owner, ComponentModel model) {
                if (owner == configurationModel && model.requiresConnection()) {
                    connectedModels.add(model);
                }
            }
        }.walk(extensionModel);
        return connectedModels;
    }

    public static boolean requiresConfig(ExtensionModel extensionModel, final NamedObject component) {
        if (!(component instanceof ComponentModel)) {
            return false;
        }
        ComponentModel model = (ComponentModel)component;
        if (model.requiresConnection()) {
            return true;
        }
        final Reference result = new Reference((Object)false);
        new ExtensionWalker(){

            public void onOperation(HasOperationModels owner, OperationModel model) {
                this.resolve((ComponentModel)model, owner);
            }

            public void onSource(HasSourceModels owner, SourceModel model) {
                this.resolve((ComponentModel)model, owner);
            }

            private void resolve(ComponentModel model, Object owner) {
                if (!(owner instanceof ExtensionModel) && model == component) {
                    result.set((Object)true);
                }
            }
        }.walk(extensionModel);
        return (Boolean)result.get();
    }

    public static boolean isContent(ParameterModel parameterModel) {
        return ExtensionModelUtils.isContent(parameterModel.getRole());
    }

    public static boolean isContent(ParameterRole purpose) {
        Preconditions.checkArgument((purpose != null ? 1 : 0) != 0, (String)"cannot evaluate null purpose");
        return purpose != ParameterRole.BEHAVIOUR;
    }

    public static ParameterRole roleOf(Optional<Content> content) {
        return content.map(c -> c.primary() ? ParameterRole.PRIMARY_CONTENT : ParameterRole.CONTENT).orElse(ParameterRole.BEHAVIOUR);
    }

    public static Map<ObjectType, Set<ObjectType>> toSubTypesMap(Collection<SubTypesModel> subTypes) {
        return subTypes.stream().collect(Collectors.toMap(SubTypesModel::getBaseType, SubTypesModel::getSubTypes));
    }

    public static OutputModel resolveOutputModelType(OutputModel untypedModel, TypeMetadataDescriptor typeMetadataDescriptor) {
        return new ImmutableOutputModel(untypedModel.getDescription(), typeMetadataDescriptor.getType(), typeMetadataDescriptor.isDynamic(), untypedModel.getModelProperties());
    }

    public static List<ParameterGroupModel> resolveParameterGroupModelType(List<ParameterGroupModel> untypedParameterGroups, Map<String, ParameterMetadataDescriptor> inputTypeDescriptors) {
        LinkedList<ParameterGroupModel> parameterGroups = new LinkedList<ParameterGroupModel>();
        untypedParameterGroups.stream().forEach(parameterGroup -> {
            LinkedList<ParameterModel> parameters = new LinkedList<ParameterModel>();
            parameterGroup.getParameterModels().forEach(parameterModel -> {
                ParameterMetadataDescriptor parameterMetadataDescriptor = (ParameterMetadataDescriptor)inputTypeDescriptors.get(parameterModel.getName());
                ImmutableParameterModel typedParameterModel = new ImmutableParameterModel(parameterModel.getName(), parameterModel.getDescription(), parameterMetadataDescriptor.getType(), parameterMetadataDescriptor.isDynamic(), parameterModel.isRequired(), parameterModel.getExpressionSupport(), parameterModel.getDefaultValue(), parameterModel.getRole(), parameterModel.getDslConfiguration(), parameterModel.getDisplayModel().orElse(null), parameterModel.getLayoutModel().orElse(null), parameterModel.getModelProperties());
                parameters.add(typedParameterModel);
            });
            parameterGroups.add(new ImmutableParameterGroupModel(parameterGroup.getName(), parameterGroup.getDescription(), parameters, parameterGroup.getExclusiveParametersModels(), parameterGroup.isShowInDsl(), parameterGroup.getDisplayModel().orElse(null), parameterGroup.getLayoutModel().orElse(null), parameterGroup.getModelProperties()));
        });
        return parameterGroups;
    }

    public static Optional<SourceCallbackModel> resolveSourceCallbackType(Optional<SourceCallbackModel> sourceCallbackModel, Map<String, ParameterMetadataDescriptor> inputTypeDescriptors) {
        return sourceCallbackModel.map(cb -> new ImmutableSourceCallbackModel(cb.getName(), cb.getDescription(), ExtensionModelUtils.resolveParameterGroupModelType(cb.getParameterGroupModels(), inputTypeDescriptors), cb.getDisplayModel().orElse(null), cb.getModelProperties()));
    }

    public static boolean isInfrastructure(ParameterModel parameter) {
        return parameter.getModelProperty(InfrastructureParameterModelProperty.class).isPresent();
    }
}

