/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.extension.internal.dsl.syntax;

import com.google.common.collect.ImmutableSet;
import java.util.ArrayDeque;
import java.util.Collection;
import java.util.Collections;
import java.util.Deque;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import org.mule.metadata.api.ClassTypeLoader;
import org.mule.metadata.api.model.ArrayType;
import org.mule.metadata.api.model.MetadataType;
import org.mule.metadata.api.model.ObjectFieldType;
import org.mule.metadata.api.model.ObjectType;
import org.mule.metadata.api.model.StringType;
import org.mule.metadata.api.model.UnionType;
import org.mule.metadata.api.visitor.MetadataTypeVisitor;
import org.mule.runtime.api.dsl.DslResolvingContext;
import org.mule.runtime.api.meta.ExpressionSupport;
import org.mule.runtime.api.meta.NamedObject;
import org.mule.runtime.api.meta.model.ExtensionModel;
import org.mule.runtime.api.meta.model.ParameterDslConfiguration;
import org.mule.runtime.api.meta.model.XmlDslModel;
import org.mule.runtime.api.meta.model.connection.HasConnectionProviderModels;
import org.mule.runtime.api.meta.model.parameter.ParameterGroupModel;
import org.mule.runtime.api.meta.model.parameter.ParameterModel;
import org.mule.runtime.api.meta.model.parameter.ParameterizedModel;
import org.mule.runtime.api.meta.type.TypeCatalog;
import org.mule.runtime.api.util.Reference;
import org.mule.runtime.extension.api.declaration.type.ExtensionsTypeLoaderFactory;
import org.mule.runtime.extension.api.declaration.type.TypeUtils;
import org.mule.runtime.extension.api.dsl.syntax.DslElementSyntax;
import org.mule.runtime.extension.api.dsl.syntax.resolver.DefaultImportTypesStrategy;
import org.mule.runtime.extension.api.dsl.syntax.resolver.DslSyntaxResolver;
import org.mule.runtime.extension.api.dsl.syntax.resolver.ImportTypesStrategy;
import org.mule.runtime.extension.api.util.ExtensionMetadataTypeUtils;
import org.mule.runtime.extension.api.util.ExtensionModelUtils;
import org.mule.runtime.extension.api.util.NameUtils;
import org.mule.runtime.extension.internal.dsl.syntax.DslElementSyntaxBuilder;
import org.mule.runtime.extension.internal.dsl.syntax.DslSyntaxUtils;
import org.mule.runtime.extension.internal.property.QNameModelProperty;

public class XmlDslSyntaxResolver
implements DslSyntaxResolver {
    private final ExtensionModel extensionModel;
    private final TypeCatalog typeCatalog;
    private final XmlDslModel languageModel;
    private final Map<String, DslElementSyntax> resolvedTypes = new HashMap<String, DslElementSyntax>();
    private final Map<MetadataType, XmlDslModel> importedTypes;
    private final Deque<String> typeResolvingStack = new ArrayDeque<String>();
    private final ClassTypeLoader typeLoader = ExtensionsTypeLoaderFactory.getDefault().createTypeLoader();

    public XmlDslSyntaxResolver(ExtensionModel model, DslResolvingContext context) {
        this.extensionModel = model;
        this.languageModel = model.getXmlDslModel();
        this.typeCatalog = this.getTypeCatalog(model, context);
        this.importedTypes = new DefaultImportTypesStrategy(model, context).getImportedTypes();
    }

    public XmlDslSyntaxResolver(ExtensionModel model, ImportTypesStrategy importTypesStrategy) {
        this.extensionModel = model;
        this.languageModel = model.getXmlDslModel();
        this.typeCatalog = TypeCatalog.getDefault(Collections.singleton(model));
        this.importedTypes = importTypesStrategy.getImportedTypes();
    }

    @Override
    public DslElementSyntax resolve(NamedObject component) {
        DslElementSyntaxBuilder dsl = DslElementSyntaxBuilder.create().withElementName(NameUtils.hyphenize(NameUtils.sanitizeName(component.getName())).replaceAll("\\s+", "")).withNamespace(this.languageModel.getNamespace(), this.languageModel.getNamespaceUri()).supportsTopLevelDeclaration(true).supportsChildDeclaration(true).supportsAttributeDeclaration(false).requiresConfig(ExtensionModelUtils.requiresConfig(this.extensionModel, component));
        if (component instanceof ParameterizedModel) {
            this.resolveGroupsDsl((ParameterizedModel)component, dsl);
        }
        if (component instanceof HasConnectionProviderModels) {
            ((HasConnectionProviderModels)component).getConnectionProviders().forEach(c -> dsl.containing(c.getName(), this.resolve((NamedObject)c)));
        }
        return dsl.build();
    }

    @Override
    public DslElementSyntax resolve(final ParameterModel parameter) {
        final ExpressionSupport expressionSupport = parameter.getExpressionSupport();
        final DslElementSyntaxBuilder builder = DslElementSyntaxBuilder.create();
        final ParameterDslConfiguration dslConfig = parameter.getDslConfiguration();
        final Reference namespace = new Reference((Object)this.languageModel.getNamespace());
        final Reference namespaceUri = new Reference((Object)this.languageModel.getNamespaceUri());
        final Reference elementName = new Reference((Object)NameUtils.hyphenize(parameter.getName()));
        parameter.getModelProperty(QNameModelProperty.class).map(QNameModelProperty::getValue).ifPresent(qName -> {
            elementName.set((Object)qName.getLocalPart());
            namespace.set((Object)qName.getPrefix());
            namespaceUri.set((Object)qName.getNamespaceURI());
        });
        final boolean isContent = ExtensionModelUtils.isContent(parameter);
        parameter.getType().accept(new MetadataTypeVisitor(){

            public void visitUnion(UnionType unionType) {
                unionType.getTypes().forEach(type -> type.accept((MetadataTypeVisitor)this));
            }

            protected void defaultVisit(MetadataType metadataType) {
                if (isContent) {
                    this.addContentChildWithNoAttribute();
                } else {
                    XmlDslSyntaxResolver.this.addAttributeName(builder, parameter, isContent, dslConfig);
                }
            }

            public void visitString(StringType stringType) {
                if (DslSyntaxUtils.isText(parameter) || isContent) {
                    this.addContentChildWithNoAttribute();
                } else {
                    builder.supportsAttributeDeclaration(true).supportsChildDeclaration(false).withAttributeName(parameter.getName());
                }
            }

            public void visitArrayType(ArrayType arrayType) {
                this.defaultVisit((MetadataType)arrayType);
                builder.withNamespace((String)namespace.get(), (String)namespaceUri.get()).withElementName((String)elementName.get());
                MetadataType genericType = arrayType.getType();
                boolean supportsInline = DslSyntaxUtils.supportsInlineDeclaration((MetadataType)arrayType, expressionSupport, dslConfig, isContent);
                boolean requiresWrapper = XmlDslSyntaxResolver.this.typeRequiresWrapperElement(genericType);
                if (supportsInline || requiresWrapper) {
                    builder.supportsChildDeclaration(true);
                    if (!isContent) {
                        genericType.accept(XmlDslSyntaxResolver.this.getArrayItemTypeVisitor(builder, parameter.getName(), (String)namespace.get(), (String)namespaceUri.get(), false));
                    }
                }
            }

            public void visitObject(ObjectType objectType) {
                XmlDslSyntaxResolver.this.addAttributeName(builder, parameter, isContent, dslConfig);
                builder.withNamespace((String)namespace.get(), (String)namespaceUri.get());
                if (ExtensionMetadataTypeUtils.isMap((MetadataType)objectType)) {
                    XmlDslSyntaxResolver.this.resolveMapDsl(objectType, builder, isContent, expressionSupport, dslConfig, parameter.getName(), (String)namespace.get(), (String)namespaceUri.get());
                } else {
                    builder.withNamespace((String)namespace.get(), (String)namespaceUri.get()).withElementName((String)elementName.get());
                    XmlDslSyntaxResolver.this.resolveObjectDsl(parameter, objectType, builder, isContent, dslConfig, expressionSupport);
                }
            }

            private void addContentChildWithNoAttribute() {
                builder.withNamespace((String)namespace.get(), (String)namespaceUri.get()).withElementName((String)elementName.get()).supportsChildDeclaration(true).supportsAttributeDeclaration(false);
            }
        });
        return builder.build();
    }

    @Override
    public DslElementSyntax resolveInline(ParameterGroupModel group) {
        DslElementSyntaxBuilder builder = DslElementSyntaxBuilder.create();
        builder.withNamespace(this.languageModel.getNamespace(), this.languageModel.getNamespaceUri()).withElementName(NameUtils.hyphenize(NameUtils.sanitizeName(group.getName())).replaceAll("\\s+", "")).supportsAttributeDeclaration(false).supportsChildDeclaration(true).supportsTopLevelDeclaration(false);
        group.getParameterModels().forEach(parameter -> builder.containing(parameter.getName(), this.resolve((ParameterModel)parameter)));
        return builder.build();
    }

    @Override
    public Optional<DslElementSyntax> resolve(MetadataType type) {
        return type instanceof ObjectType ? this.resolvePojoDsl((ObjectType)type) : Optional.empty();
    }

    private Optional<DslElementSyntax> resolvePojoDsl(ObjectType type) {
        String namespaceUri;
        boolean requiresWrapper = this.typeRequiresWrapperElement((MetadataType)type);
        boolean supportsInlineDeclaration = DslSyntaxUtils.supportsInlineDeclaration((MetadataType)type, ExpressionSupport.NOT_SUPPORTED);
        boolean supportTopLevelElement = DslSyntaxUtils.supportTopLevelElement((MetadataType)type);
        if (!supportsInlineDeclaration && !supportTopLevelElement && !requiresWrapper && this.typeCatalog.getSuperTypes(type).isEmpty()) {
            return Optional.empty();
        }
        String namespace = this.getNamespace((MetadataType)type);
        String key = DslSyntaxUtils.getTypeKey((MetadataType)type, namespace, namespaceUri = this.getNamespaceUri((MetadataType)type));
        if (this.resolvedTypes.containsKey(key)) {
            return Optional.of(this.resolvedTypes.get(key));
        }
        DslElementSyntaxBuilder builder = DslElementSyntaxBuilder.create().withNamespace(namespace, namespaceUri).withElementName(NameUtils.getTopLevelTypeName((MetadataType)type)).supportsTopLevelDeclaration(supportTopLevelElement).supportsChildDeclaration(supportsInlineDeclaration).supportsAttributeDeclaration(false).asWrappedElement(requiresWrapper);
        String typeId = DslSyntaxUtils.getId((MetadataType)type);
        if (!this.typeResolvingStack.contains(typeId)) {
            if (supportTopLevelElement || supportsInlineDeclaration) {
                this.withStackControl(typeId, () -> this.declareFieldsAsChilds(builder, type.getFields(), namespace, namespaceUri));
            }
            DslElementSyntax dsl = builder.build();
            this.resolvedTypes.put(key, dsl);
            return Optional.of(dsl);
        }
        return Optional.of(builder.build());
    }

    private void resolveObjectDsl(ParameterModel parameter, ObjectType objectType, DslElementSyntaxBuilder builder, boolean isContent, ParameterDslConfiguration dslConfig, ExpressionSupport expressionSupport) {
        boolean requiresWrapper;
        boolean shouldGenerateChild;
        boolean supportsTopLevel;
        if (ExtensionModelUtils.isInfrastructure(parameter)) {
            supportsTopLevel = dslConfig.allowTopLevelDefinition();
            shouldGenerateChild = dslConfig.allowsInlineDefinition();
            requiresWrapper = false;
        } else {
            supportsTopLevel = DslSyntaxUtils.supportTopLevelElement((MetadataType)objectType, dslConfig);
            shouldGenerateChild = DslSyntaxUtils.supportsInlineDeclaration((MetadataType)objectType, expressionSupport, dslConfig, isContent);
            requiresWrapper = this.typeRequiresWrapperElement((MetadataType)objectType);
        }
        builder.supportsTopLevelDeclaration(supportsTopLevel);
        if (shouldGenerateChild || requiresWrapper) {
            builder.supportsChildDeclaration(true);
            if (requiresWrapper) {
                builder.asWrappedElement(true);
            } else if (!isContent) {
                this.declareFieldsAsChilds(builder, objectType.getFields(), this.languageModel.getNamespace(), this.languageModel.getNamespaceUri());
            }
        }
    }

    private void resolveMapDsl(ObjectType objectType, DslElementSyntaxBuilder builder, boolean isContent, ExpressionSupport expressionSupport, ParameterDslConfiguration dslModel, String name, String namespace, String namespaceUri) {
        String parameterName = isContent ? name : NameUtils.pluralize(name);
        builder.withElementName(NameUtils.hyphenize(parameterName)).supportsChildDeclaration(DslSyntaxUtils.supportsInlineDeclaration((MetadataType)objectType, expressionSupport, isContent));
        if (!isContent) {
            objectType.getOpenRestriction().ifPresent(type -> type.accept(this.getMapValueTypeVisitor(builder, name, namespace, namespaceUri, dslModel)));
        }
    }

    private void resolveGroupsDsl(ParameterizedModel component, DslElementSyntaxBuilder dsl) {
        List inlineGroupedParameters = component.getParameterGroupModels().stream().filter(ParameterGroupModel::isShowInDsl).peek(group -> dsl.containing(group.getName(), this.resolveInline((ParameterGroupModel)group))).flatMap(g -> g.getParameterModels().stream()).collect(Collectors.toList());
        component.getAllParameterModels().stream().filter(p -> !inlineGroupedParameters.contains(p)).forEach(parameter -> dsl.containing(parameter.getName(), this.resolve((ParameterModel)parameter)));
    }

    private MetadataTypeVisitor getArrayItemTypeVisitor(final DslElementSyntaxBuilder listBuilder, final String parameterName, final String namespace, final String namespaceUri, final boolean asItem) {
        return new MetadataTypeVisitor(){

            public void visitObject(ObjectType objectType) {
                if (ExtensionMetadataTypeUtils.isMap((MetadataType)objectType)) {
                    this.defaultVisit((MetadataType)objectType);
                    return;
                }
                if (XmlDslSyntaxResolver.this.typeRequiresWrapperElement((MetadataType)objectType)) {
                    listBuilder.withGeneric((MetadataType)objectType, DslElementSyntaxBuilder.create().withNamespace(XmlDslSyntaxResolver.this.getNamespace((MetadataType)objectType), XmlDslSyntaxResolver.this.getNamespaceUri((MetadataType)objectType)).withElementName(NameUtils.getTopLevelTypeName((MetadataType)objectType)).supportsAttributeDeclaration(false).supportsChildDeclaration(DslSyntaxUtils.supportsInlineDeclaration((MetadataType)objectType, ExpressionSupport.NOT_SUPPORTED)).asWrappedElement(true).supportsTopLevelDeclaration(DslSyntaxUtils.supportTopLevelElement((MetadataType)objectType, ParameterDslConfiguration.getDefaultInstance())).build());
                } else if (DslSyntaxUtils.isValidBean(objectType)) {
                    listBuilder.withGeneric((MetadataType)objectType, XmlDslSyntaxResolver.this.resolve((MetadataType)objectType).get());
                }
            }

            public void visitArrayType(ArrayType arrayType) {
                DslElementSyntaxBuilder genericBuilder = DslElementSyntaxBuilder.create().withNamespace(namespace, namespaceUri).withElementName(XmlDslSyntaxResolver.this.resolveItemName(parameterName, asItem)).supportsAttributeDeclaration(false);
                MetadataType genericType = arrayType.getType();
                boolean supportsInline = DslSyntaxUtils.supportsInlineDeclaration(genericType, ExpressionSupport.SUPPORTED);
                boolean requiresWrapper = XmlDslSyntaxResolver.this.typeRequiresWrapperElement(genericType);
                if (supportsInline || requiresWrapper) {
                    genericBuilder.supportsChildDeclaration(true);
                    genericType.accept(XmlDslSyntaxResolver.this.getArrayItemTypeVisitor(genericBuilder, parameterName, namespace, namespaceUri, true));
                }
                listBuilder.withGeneric((MetadataType)arrayType, genericBuilder.build());
            }

            protected void defaultVisit(MetadataType metadataType) {
                listBuilder.withGeneric(metadataType, DslElementSyntaxBuilder.create().withNamespace(namespace, namespaceUri).withElementName(XmlDslSyntaxResolver.this.resolveItemName(parameterName, asItem)).supportsAttributeDeclaration(false).supportsChildDeclaration(true).containing("value", DslElementSyntaxBuilder.create().withAttributeName("value").build()).build());
            }
        };
    }

    private MetadataTypeVisitor getMapValueTypeVisitor(final DslElementSyntaxBuilder mapBuilder, final String parameterName, final String namespace, final String namespaceUri, final ParameterDslConfiguration dslModel) {
        return new MetadataTypeVisitor(){

            protected void defaultVisit(MetadataType metadataType) {
                mapBuilder.withGeneric(metadataType, this.createBaseValueEntryDefinition().containing("value", DslElementSyntaxBuilder.create().withAttributeName("value").build()).build());
            }

            public void visitObject(ObjectType objectType) {
                if (ExtensionMetadataTypeUtils.isMap((MetadataType)objectType)) {
                    this.defaultVisit((MetadataType)objectType);
                    return;
                }
                boolean supportsInlineDeclaration = DslSyntaxUtils.supportsInlineDeclaration((MetadataType)objectType, ExpressionSupport.SUPPORTED, dslModel, false);
                boolean requiresWrapperElement = XmlDslSyntaxResolver.this.typeRequiresWrapperElement((MetadataType)objectType);
                if (supportsInlineDeclaration || requiresWrapperElement) {
                    DslElementSyntaxBuilder valueEntry = this.createBaseValueEntryDefinition();
                    String namespace2 = XmlDslSyntaxResolver.this.getNamespace((MetadataType)objectType);
                    String namespaceUri2 = XmlDslSyntaxResolver.this.getNamespaceUri((MetadataType)objectType);
                    DslElementSyntaxBuilder innerPojoDsl = DslElementSyntaxBuilder.create().withAttributeName("value").withNamespace(namespace2, namespaceUri2);
                    if (supportsInlineDeclaration) {
                        innerPojoDsl.withElementName(NameUtils.getTopLevelTypeName((MetadataType)objectType)).supportsChildDeclaration(true);
                        XmlDslSyntaxResolver.this.withStackControl(DslSyntaxUtils.getId((MetadataType)objectType), () -> XmlDslSyntaxResolver.this.declareFieldsAsChilds(innerPojoDsl, objectType.getFields(), namespace2, namespaceUri2));
                    } else {
                        innerPojoDsl.asWrappedElement(true);
                    }
                    valueEntry.containing("value", innerPojoDsl.build());
                    mapBuilder.withGeneric((MetadataType)objectType, valueEntry.build());
                } else {
                    this.defaultVisit((MetadataType)objectType);
                }
            }

            public void visitArrayType(ArrayType arrayType) {
                DslElementSyntaxBuilder valueEntry = this.createBaseValueEntryDefinition().containing("value", DslElementSyntaxBuilder.create().withAttributeName("key").build());
                MetadataType genericType = arrayType.getType();
                boolean genericSupportsInline = DslSyntaxUtils.supportsInlineDeclaration(genericType, ExpressionSupport.SUPPORTED, dslModel, false);
                boolean genericRequiresWrapper = XmlDslSyntaxResolver.this.typeRequiresWrapperElement(genericType);
                if (genericSupportsInline || genericRequiresWrapper) {
                    genericType.accept(XmlDslSyntaxResolver.this.getArrayItemTypeVisitor(valueEntry, parameterName, namespace, namespaceUri, true));
                }
                mapBuilder.withGeneric((MetadataType)arrayType, valueEntry.build());
            }

            private DslElementSyntaxBuilder createBaseValueEntryDefinition() {
                return DslElementSyntaxBuilder.create().withNamespace(namespace, namespaceUri).withElementName(NameUtils.hyphenize(NameUtils.singularize(parameterName))).supportsAttributeDeclaration(false).supportsChildDeclaration(true).containing("key", DslElementSyntaxBuilder.create().withAttributeName("key").build());
            }
        };
    }

    private void addBeanDeclarationSupport(ObjectType objectType, Collection<ObjectFieldType> childFields, DslElementSyntaxBuilder builder, String namespace, String namespaceUri, boolean introspectObjectFields) {
        boolean supportsChildDeclaration = DslSyntaxUtils.supportsInlineDeclaration((MetadataType)objectType, ExpressionSupport.SUPPORTED);
        boolean supportsTopDeclaration = DslSyntaxUtils.supportTopLevelElement((MetadataType)objectType);
        builder.supportsChildDeclaration(supportsChildDeclaration).supportsTopLevelDeclaration(supportsTopDeclaration).asWrappedElement(this.typeRequiresWrapperElement((MetadataType)objectType));
        if (introspectObjectFields && (supportsChildDeclaration || supportsTopDeclaration)) {
            this.declareFieldsAsChilds(builder, childFields, namespace, namespaceUri);
        }
    }

    private MetadataTypeVisitor getObjectFieldVisitor(final DslElementSyntaxBuilder objectFieldBuilder, final boolean isText, final String fieldName, final String ownerNamespace, final String ownerNamespaceUri) {
        return new MetadataTypeVisitor(){

            protected void defaultVisit(MetadataType metadataType) {
                objectFieldBuilder.withAttributeName(fieldName);
            }

            public void visitString(StringType stringType) {
                if (isText) {
                    objectFieldBuilder.supportsAttributeDeclaration(false).supportsChildDeclaration(true).withElementName(NameUtils.hyphenize(fieldName)).withNamespace(ownerNamespace, ownerNamespaceUri);
                } else {
                    this.defaultVisit((MetadataType)stringType);
                }
            }

            public void visitObject(ObjectType objectType) {
                objectFieldBuilder.withAttributeName(fieldName);
                if (ExtensionMetadataTypeUtils.isMap((MetadataType)objectType)) {
                    objectFieldBuilder.withElementName(NameUtils.hyphenize(NameUtils.pluralize(fieldName))).withNamespace(ownerNamespace, ownerNamespaceUri);
                    objectFieldBuilder.supportsChildDeclaration(true);
                    objectFieldBuilder.withGeneric(XmlDslSyntaxResolver.this.typeLoader.load(String.class), DslElementSyntaxBuilder.create().withAttributeName("key").build());
                    objectFieldBuilder.withAttributeName("key");
                    objectType.getOpenRestriction().ifPresent(type -> type.accept(XmlDslSyntaxResolver.this.getMapValueTypeVisitor(objectFieldBuilder, fieldName, ownerNamespace, ownerNamespaceUri, ParameterDslConfiguration.getDefaultInstance())));
                } else {
                    objectFieldBuilder.withElementName(NameUtils.hyphenize(fieldName)).withNamespace(XmlDslSyntaxResolver.this.getNamespace((MetadataType)objectType, ownerNamespace), XmlDslSyntaxResolver.this.getNamespaceUri((MetadataType)objectType, ownerNamespaceUri));
                    String typeId = DslSyntaxUtils.getId((MetadataType)objectType);
                    if (!XmlDslSyntaxResolver.this.typeResolvingStack.contains(typeId)) {
                        XmlDslSyntaxResolver.this.withStackControl(typeId, () -> {
                            List fields = objectType.getFields().stream().filter(f -> !XmlDslSyntaxResolver.this.typeResolvingStack.contains(DslSyntaxUtils.getId(f.getValue()))).collect(Collectors.toList());
                            XmlDslSyntaxResolver.this.addBeanDeclarationSupport(objectType, fields, objectFieldBuilder, ownerNamespace, ownerNamespaceUri, true);
                        });
                    } else {
                        XmlDslSyntaxResolver.this.addBeanDeclarationSupport(objectType, Collections.emptyList(), objectFieldBuilder, ownerNamespace, ownerNamespaceUri, false);
                    }
                }
            }

            public void visitArrayType(ArrayType arrayType) {
                objectFieldBuilder.withAttributeName(fieldName).withElementName(NameUtils.hyphenize(fieldName)).withNamespace(ownerNamespace, ownerNamespaceUri);
                MetadataType genericType = arrayType.getType();
                if (DslSyntaxUtils.supportsInlineDeclaration(genericType, ExpressionSupport.SUPPORTED)) {
                    objectFieldBuilder.supportsChildDeclaration(true);
                    genericType.accept(XmlDslSyntaxResolver.this.getArrayItemTypeVisitor(objectFieldBuilder, fieldName, ownerNamespace, ownerNamespaceUri, false));
                }
            }
        };
    }

    private void declareFieldsAsChilds(DslElementSyntaxBuilder objectBuilder, Collection<ObjectFieldType> fields, String namespace, String namespaceUri) {
        fields.forEach(field -> {
            DslElementSyntaxBuilder fieldBuilder = DslElementSyntaxBuilder.create();
            String childName = field.getKey().getName().getLocalPart();
            MetadataType fieldValue = field.getValue();
            if (DslSyntaxUtils.isFlattened(field, fieldValue)) {
                this.declareFieldsAsChilds(objectBuilder, ((ObjectType)fieldValue).getFields(), namespace, namespaceUri);
            } else {
                if (TypeUtils.isContent((MetadataType)field)) {
                    fieldBuilder.supportsAttributeDeclaration(false).supportsChildDeclaration(true).withElementName(NameUtils.hyphenize(childName)).withNamespace(namespace, namespaceUri);
                } else {
                    fieldValue.accept(this.getObjectFieldVisitor(fieldBuilder, DslSyntaxUtils.isText((MetadataType)field), childName, namespace, namespaceUri));
                }
                objectBuilder.containing(childName, fieldBuilder.build());
            }
        });
    }

    private void addAttributeName(DslElementSyntaxBuilder builder, ParameterModel parameter, boolean isContent, ParameterDslConfiguration dslModel) {
        if (this.supportsAttributeDeclaration(parameter, isContent, dslModel)) {
            builder.withAttributeName(parameter.getName());
        } else {
            builder.supportsAttributeDeclaration(false);
        }
    }

    private boolean supportsAttributeDeclaration(ParameterModel parameter, boolean isContent, ParameterDslConfiguration dslModel) {
        return !isContent && (dslModel.allowsReferences() || !ExpressionSupport.NOT_SUPPORTED.equals((Object)parameter.getExpressionSupport()));
    }

    private boolean typeRequiresWrapperElement(MetadataType metadataType) {
        return metadataType instanceof ObjectType && (DslSyntaxUtils.isExtensible(metadataType) || this.typeCatalog.containsBaseType((ObjectType)metadataType));
    }

    private String getNamespace(MetadataType type) {
        return this.getNamespace(type, this.languageModel.getNamespace());
    }

    private String getNamespace(MetadataType type, String defaultNamespace) {
        XmlDslModel originXml = this.importedTypes.get(type);
        return originXml != null ? originXml.getNamespace() : defaultNamespace;
    }

    private String getNamespaceUri(MetadataType type) {
        return this.getNamespaceUri(type, this.languageModel.getNamespaceUri());
    }

    private String getNamespaceUri(MetadataType type, String defaultUri) {
        XmlDslModel originXml = this.importedTypes.get(type);
        return originXml != null ? originXml.getNamespaceUri() : defaultUri;
    }

    private String resolveItemName(String parameterName, boolean forceItemize) {
        String singularizedName = NameUtils.singularize(parameterName);
        return forceItemize || parameterName.equals(singularizedName) ? NameUtils.itemize(singularizedName) : NameUtils.hyphenize(singularizedName);
    }

    private TypeCatalog getTypeCatalog(ExtensionModel model, DslResolvingContext context) {
        return context.getExtension(model.getName()).isPresent() ? context.getTypeCatalog() : TypeCatalog.getDefault((Set)ImmutableSet.builder().add((Object)model).addAll((Iterable)context.getExtensions()).build());
    }

    private void withStackControl(String stackId, Runnable action) {
        if (!this.typeResolvingStack.contains(stackId)) {
            this.typeResolvingStack.push(stackId);
            action.run();
            this.typeResolvingStack.pop();
        }
    }
}

